#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <stdlib.h>
#include "mysql.h"
#include "forms.h"
#include "xmysqladmin.h"
#include "xmysqladmin2.h"  /* struct setup and stat */

extern struct setup Setup;
extern struct stat Stat;
FD_connect *f_connect;

/* callback for connect button */
void main_connect(FL_OBJECT *obj, long data)
{
  if(Stat.flagConnect) return;
  Stat.flagConnect=1;
  
  f_connect = create_form_connect();
  fl_show_form(f_connect->connect, FL_PLACE_MOUSE, FL_TRANSIENT, "XmysqlAdmin connect");

  fl_set_input_maxchars(f_connect->host            , 60);
  fl_set_input_maxchars(f_connect->user            , 14);
  fl_set_input_maxchars(f_connect->password        , 20);
  fl_set_input_maxchars(f_connect->port        , 4);

  fl_set_input(f_connect->host           , Setup.host);
  fl_set_input(f_connect->user           , Setup.user);
  fl_set_input(f_connect->password       , Setup.password);
  fl_set_input(f_connect->port           , Setup.port);
  fl_deactivate_object(f_connect->result);
  
}

void connect_callback(FL_OBJECT *obj, long data)
{
  strcpy(Setup.host, fl_get_input(f_connect->host));
  strcpy(Setup.user, fl_get_input(f_connect->user));
  strcpy(Setup.password, fl_get_input(f_connect->password));
  strcpy(Setup.port, fl_get_input(f_connect->port));
}
void connect_close(FL_OBJECT *obj, long data)
{
  fl_hide_form(f_connect->connect);
  fl_free_form(f_connect->connect);
  free(f_connect);
  Stat.flagConnect=0;
}
void connect_try(FL_OBJECT *obj, long data)
{
  MYSQL connection, *sock;
  connect_callback(obj, data);

  if((sock = g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password)))
  {
    mysql_close(&connection);
    fl_set_input(f_connect->result, "Connection has been successfull!");
  }
  else
  {
    fl_set_input(f_connect->result, "Connection error");
  }
}





