#include <ctype.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <stdlib.h>
#include <string.h>
#include "forms.h"
#include "xmysqladmin.h"
#include "xmysqladmin2.h"
#include "mysql.h"

/* #define GDEBUG  */

extern struct setup Setup;
extern struct stat Stat;

MYSQL *g_mysql_connect(MYSQL *mysql,const char *host,
		     const char *user, const char *passwd)
{
   /* printf("host:%s, user:%s,passw:%s, port:%s\n",host,user,passwd,Setup.port);  */
   return mysql_real_connect(mysql,host,user,passwd,(unsigned int) atoi(Setup.port), (char *) 0,0);
}



void browser_getDatabases(FL_OBJECT *browser)
{
  if(fl_get_browser_maxline(browser))
    fl_clear_browser(browser);

  {
    MYSQL connection;
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      MYSQL_ROW row;
      int i;
      
      if ((result=mysql_list_dbs(&connection, "%")))
      {
        while ((row=mysql_fetch_row(result)))
	{
          for(i = 0; i < mysql_num_fields(result); i++)
	  {  
            fl_addto_browser_chars(browser, row[i]);
	    if(i < mysql_num_fields(result) - 1)
	      fl_addto_browser_chars(browser, "\t"); 
	  }
	  fl_addto_browser_chars(browser, "\n"); 
        }
	mysql_free_result(result);
      }
      mysql_close(&connection);
    }
  }
}


void browser_getTables(FL_OBJECT *browser, char *database)
{
  MYSQL connection;
  
  if(fl_get_browser_maxline(browser))
    fl_clear_browser(browser);

#ifdef GDEBUG
  printf("browser_getTables(%s) apres clear browser\n", database);
#endif
  
  if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
  {
    MYSQL_RES *result;
    MYSQL_ROW row;
    int i;

    mysql_select_db(&connection, database);
#ifdef GDEBUG
  printf("browser_getTables(%s) apres selectdb\n", database);
#endif
      
    if((result=mysql_list_tables(&connection, "%")))
    {
#ifdef GDEBUG
  printf("browser_getTables(%s) apres mysql_list_tables()\n", database);
#endif

      while ((row=mysql_fetch_row(result)))
      {
	for(i = 0; i < mysql_num_fields(result); i++)
	{  
	  fl_addto_browser_chars(browser, row[i]);

#ifdef GDEBUG
  printf("browser_getTables(%s) ligne:%d = [%s]\n", database,i,row[i]);
#endif
	  
	  if(i < mysql_num_fields(result) - 1)
	  {
	    fl_addto_browser_chars(browser, "\t"); 
	  }
	  fl_addto_browser_chars(browser, "\n"); 
	}
      }
      mysql_free_result(result);
      mysql_close(&connection);
    }
    else
    {
      fl_show_alert("Can't retrieve tables", database, "", 1);
    }
  }
  else
  {
    fl_show_alert("Can't connect to server", "","",1);
  }
}			  

void choice_getTables(FL_OBJECT *choice, char *database)
{
  MYSQL connection;
  
  if(fl_get_choice_maxitems(choice))
    fl_clear_choice(choice);

#ifdef GDEBUG
  printf("choice_getTables(%s) apres clear \n", database);
#endif
  
  if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
  {
    MYSQL_RES *result;
    MYSQL_ROW row;
    
    mysql_select_db(&connection, database);
      
    if((result=mysql_list_tables(&connection, "%")))
    {
      fl_addto_choice(choice, "Select a table");

      while ((row=mysql_fetch_row(result)))
      {
#ifdef GDEBUG
	printf("choice_getTables(%s) table:[%s]\n", database, row[0]);
#endif
	fl_addto_choice(choice, row[0]);
      }
      mysql_free_result(result);
      mysql_close(&connection);
    }
    else
    {
      fl_show_alert("Can't retrieve tables", database, "", 1);
    }
  }
  else
  {
    fl_show_alert("Can't connect to server", "","",1);
  }
}			  


void choice_getDatabases(FL_OBJECT *choice)
{
  if(fl_get_choice_maxitems(choice))
    fl_clear_choice(choice);
  fl_addto_choice(choice, "Select a database");
  {
    MYSQL connection;
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      MYSQL_ROW row;
      
      if ((result=mysql_list_dbs(&connection, "%")))
      {
        while ((row=mysql_fetch_row(result)))
	{
	  fl_addto_choice(choice, row[0]);
        }
	mysql_free_result(result);
      }
      mysql_close(&connection);
    }
  }
}

/*------------------------------------------------*/
/* verifie si la table existe deja dans la banque */
/*------------------------------------------------*/
int tableExist(char *database, char *table)
{
  int rows = 0;

  MYSQL connection;
  if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
  {
    MYSQL_RES *result;
      
    mysql_select_db(&connection, database);
    result = mysql_list_tables(&connection, table);
    rows = mysql_num_rows(result);
    mysql_free_result(result);
    mysql_close(&connection);
  }
  return rows;
}


/*---------------------------------------------------------*/
/* execute le rapport et place le resultat dans un browser */
/*---------------------------------------------------------*/
void util_exec_sql(FL_OBJECT *browser, char *database, char *sql)
{
   MYSQL connection;
   char *str;
   char *format;

   str = (char *) malloc(256);
   format  = (char *) malloc(256);

   if(fl_get_browser_maxline(browser))
      fl_clear_browser(browser);


   fl_addto_command_log("\n");
   fl_addto_command_log("\n");
   fl_addto_command_log("Connecting to server...");
   if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
   {
      MYSQL_RES *result;
      char *error;
      
      fl_addto_command_log(" OK\n");
      mysql_select_db(&connection, database);
      fl_addto_command_log("Database \"");
      fl_addto_command_log(database);
      fl_addto_command_log("\" selected...\n\n");

      fl_addto_command_log("Executing \"");
      fl_addto_command_log(sql);
      fl_addto_command_log("\n");
      if(!mysql_query(&connection, sql))
      {
	 MYSQL_ROW row;
	 int ligne;
	 int lg;
	 char lga[128];
	 int i;

	 for(ligne = 0; ligne < 128; ligne++)
	    lga[ligne] = '\0';

	 result = mysql_store_result(&connection);
	 sprintf(str, "%ld row(s) affected\n\n", 
		 mysql_affected_rows(&connection));
	 fl_addto_command_log(str);

	 /*--------------------------------*/
	 /*--------------------------------*/
	 /* ajoute resultat sur le browser */
	 /*--------------------------------*/
	 /*--------------------------------*/
	 /*
	  * calcule la longueur maximale de chaque champ 
	  */
	 while ((row=mysql_fetch_row(result)))
	 {
	    for(i = 0; i < mysql_num_fields(result); i++)
	    { 
	       if(row[i])
	       {
		  lg = strlen(row[i]);
		  if(lg > lga[i]) lga[i] = lg;
	       } /* endif si info dans colonne */
	    } /* fin mwsure des champs de la ligne */
	 } /* endwhile mesure  des colonnes  */

	 /*----------------------------------*/
	 /* Place les champs dans le browser */
	 /*----------------------------------*/
	 mysql_data_seek(result, 0);  /* revient au debut des lignes */
	 while ((row=mysql_fetch_row(result)))
	 {
	    for(i = 0; i < mysql_num_fields(result); i++)
	    { 
	       if(row[i])
	       {
		  sprintf(format, "%c%ds ", '%',lga[i]);
		  sprintf(str, format, row[i]);
		  fl_addto_browser_chars(browser, str);
	       } /* endif si info dans colonne */
	       sprintf(str, "%c", 127); /* separateur invisible de champs */
	       fl_addto_browser_chars(browser, str);
	    } /* fin lecture des champs de la ligne */
	    fl_addto_browser_chars(browser, "\n");
	 } /* endwhile lecture des lignes  */

	 mysql_free_result(result);
      }
      else
      {
	 error = mysql_error(&connection);
	 fl_addto_command_log(" * ERROR *\n");
	 fl_addto_command_log(error);
	 fl_addto_command_log("\n\n");
      }
      mysql_close(&connection);
      fl_addto_command_log("Connection closed.\n");
   }

   free(format);  free(str);
}
/*---------------------------------------------------------*/
/* execute le rapport et place le resultat dans un browser */
/*---------------------------------------------------------*/
int util_exec_voidsql(char *database, char *sql)
{
   MYSQL connection;
   char *str;
   int stat = 0;

   str = (char *) malloc(256);

   fl_addto_command_log("\n");
   fl_addto_command_log("\n");
   fl_addto_command_log("Connecting to server...");
   if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
   {
      MYSQL_RES *result;
      char *error;
      
      fl_addto_command_log(" OK\n");
      mysql_select_db(&connection, database);
      fl_addto_command_log("Database \"");
      fl_addto_command_log(database);
      fl_addto_command_log("\" selected...\n\n");

      fl_addto_command_log("Executing \"");
      fl_addto_command_log(sql);
      fl_addto_command_log("\n");
      if(!mysql_query(&connection, sql))
      {
	 result = mysql_store_result(&connection);
	 sprintf(str, "%ld row(s) affected\n\n", 
		 mysql_affected_rows(&connection));
	 fl_addto_command_log(str);
	 mysql_free_result(result);
      }
      else
      {
	 stat = 1;
	 error = mysql_error(&connection);
	 fl_addto_command_log(" * ERROR *\n");
	 fl_addto_command_log(error);
	 fl_addto_command_log("\n\n");
      }
      mysql_close(&connection);
      fl_addto_command_log("Connection closed.\n");
   }
   else
   {
      stat = 1;
      fl_addto_command_log("Cannot connect to server.\n");
   }

  free(str);
  return stat;
}


void g_deactivate_object(FL_OBJECT *obj)
{
  fl_deactivate_object(obj);
  fl_set_object_lcol(obj, FL_INACTIVE);
}
void g_activate_object(FL_OBJECT *obj)
{
  fl_activate_object(obj);
  fl_set_object_lcol(obj, FL_BLACK);
}

void g_activate_form(FL_FORM *form)
{
  FL_OBJECT *obj;

  fl_freeze_form(form);
  obj = form->first;
  while(obj)
  {
     if(    obj->objclass == FL_BUTTON
	 || obj->objclass == FL_LIGHTBUTTON
	 || obj->objclass == FL_ROUNDBUTTON
	 || obj->objclass == FL_ROUND3DBUTTON
	 || obj->objclass == FL_CHECKBUTTON
	 || obj->objclass == FL_BITMAPBUTTON
	 || obj->objclass == FL_PIXMAPBUTTON
	 || obj->objclass == FL_MENU
	 || obj->objclass == FL_CHART
	 || obj->objclass == FL_CHOICE
	 || obj->objclass == FL_COUNTER
	 || obj->objclass == FL_SLIDER
	 || obj->objclass == FL_VALSLIDER
	 || obj->objclass == FL_INPUT
	 || obj->objclass == FL_BROWSER
	 || obj->objclass == FL_DIAL
	 || obj->objclass == FL_TIMER
	 || obj->objclass == FL_CLOCK
	 || obj->objclass == FL_POSITIONER)
	g_activate_object(obj);

    obj = obj->next;
  }
  fl_unfreeze_form(form);
}
void g_deactivate_form(FL_FORM *form)
{
  FL_OBJECT *obj;

  fl_freeze_form(form);
  obj = form->first;
  while(obj)
  {
     if(    obj->objclass == FL_BUTTON
	 || obj->objclass == FL_LIGHTBUTTON
	 || obj->objclass == FL_ROUNDBUTTON
	 || obj->objclass == FL_ROUND3DBUTTON
	 || obj->objclass == FL_CHECKBUTTON
	 || obj->objclass == FL_BITMAPBUTTON
	 || obj->objclass == FL_PIXMAPBUTTON
	 || obj->objclass == FL_MENU
	 || obj->objclass == FL_CHART
	 || obj->objclass == FL_CHOICE
	 || obj->objclass == FL_COUNTER
	 || obj->objclass == FL_SLIDER
	 || obj->objclass == FL_VALSLIDER
	 || obj->objclass == FL_INPUT
	 || obj->objclass == FL_BROWSER
	 || obj->objclass == FL_DIAL
	 || obj->objclass == FL_TIMER
	 || obj->objclass == FL_CLOCK
	 || obj->objclass == FL_POSITIONER)
	g_deactivate_object(obj);

    obj = obj->next;
  }
  fl_unfreeze_form(form);
}

int stricmp(char *str1, char *str2)
{
  char *t1, *t2;
  int r;
  
  t1 = (char *) malloc(strlen(str1) + 1);
  t2 = (char *) malloc(strlen(str2) + 1);
  strcpy(t1, str1);
  strcpy(t2, str2);
  strupr(t1);
  strupr(t2);
  r = strcmp(t1, t2);
  free(t1);
  free(t2);
  return r;
}

char *strupr(char *string)
{
  char *p;
  
  p = string;
  while(*p)
  {
    *p = toupper(*p);
    p++;
  }
  return string;
}

char *strlwr(char *string)
{
  char *p;
  
  p = string;
  while(*p)
  {
    *p = tolower(*p);
    p++;
  }
  return string;
}

/*****************************************************/
/* escape les caracteres reserves dans un string sql */
/*****************************************************/
char *g_escapeStr(char *string)
{
  char *p,*c;
  char *temp;

  if(!string || !string[0]) return string;

  temp = (char *) malloc(strlen(string) + 256);
  p = string;
  c = temp;

  while(*p)
  {
     if(*p == '\'' || *p == '\\')
     {
	*c = '\\';
	c++;
     }
     *c = *p;
     c++; p++; 
  }  
  *c = '\0';

  strcpy(string, temp);
  free(temp);
  return string;
}



/*******************************************/
/* enleve les espaces au debut d'un string */
/*******************************************/
char *leftTrim(char *string)
{
  char *p;
  char *temp;

  if(!string || !string[0]) return string;

  temp = (char *) malloc(strlen(string) + 1);
  p = string;

  while(*p)
  {
     if(*p != ' ')
     {
	break;
     }
     p++;
  }  
  
  if(*p)
  {
     strcpy(temp, p);

     p = &temp[strlen(temp) - 1];
     while(p > temp)
     {
	if(isspace(*p))
	   *p = '\0';
	else
	   break;
	p--;
     }

     strcpy(string, temp);
  }

  free(temp);

  return string;
}

/**************************************************************/
/* enleve tous les espaces d'un string y compris les internes */
/**************************************************************/
char *trim(char *string)
{
  char *courant;
  char *cur, *p;
  
  courant = (char *) malloc(strlen(string) + 1);
  cur = courant;
  p = string;
  
  while(*p)
  {
    if(!isspace(*p))
    {
      *cur = *p;
      cur++;
    }
      
    p++;
  }
  *cur = '\0';
  
  strcpy(string, courant);
  free(courant);
  return string;
}

/*-----------------------------------------------------------------*/
/* retourne un substring dont le separateur est dans le char sep   */
/* retourne le no mot du string                                    */
/*-----------------------------------------------------------------*/
char *getSubstr(char *string, char sep, int no)
{
  char *deb, *der;
  int cur = 0;
  char *copie;
  char reponse[256];

  copie = (char *) malloc(strlen(string) + 1);

  strcpy(copie, string);
  
  
  deb = copie;
  der = copie;
  
  while(*der)
  {
    if(*der == sep)
    {
      *der = '\0';
      if(cur == no) 
      {
	 strcpy(reponse, deb);
	 deb = reponse;
	 free(copie);
	 return deb;
      }
      if(*(der+1) == '\0') 
      {
	 free(copie);
	 return "";
      }
      deb=der+1; cur++;
    }
    der++;
  }
  if(no == cur)
  {
     strcpy(reponse, deb);
     deb = reponse;
     free(copie);
     return deb;
  }
  else
  {
     free(copie);
     return "";
  }
}

/*-----------------------------------------------------------------*/
/* retourne un substring dont le separateur est dans le string sep */
/* retourne le no mot du string                                    */
/*-----------------------------------------------------------------*/
char *getSSubstr(char *string, char *sep, int no)
{
  char *deb, *der, *max;
  int cur = 0;
  int lg;
  char reponse[256];
  char *copie;

  lg = strlen(string);
  copie = (char *) malloc(lg + 1);
  strcpy(copie, string);
  
  deb = copie;
  der = copie;
  max = der + lg;

  /* si separateur au debut, avance de 1 */
  while(strchr(sep, (int) (*der)))
  {
     der++; deb++;
     if(der > max) return "";
  }
 
  while(*der)
  {
    if(strchr(sep, (int) (*der)))
    {
      *der = '\0';
      if(cur == no) 
      {
	 strcpy(reponse, deb);
	 deb = reponse;
	 free(copie);
	 return deb;
      }
      if(*(der+1) == '\0') 
      {
	 free(copie);
	 return "";
      }
      deb=der+1;
      /* si separateur au debut, avance de 1 */
      while(strchr(sep, (int) (*deb)))
      {
	 deb++; der++;
	 if(deb > max || der > max) return "";
      }
      cur++;
    }
    der++;
  }
  if(no == cur)
  {
     strcpy(reponse, deb);
     deb = reponse;
     free(copie);
     return deb;
  }
  else
  {
     free(copie);
     return "";
  }
}

