/* 
   buttons.m

   All of the various NSButtons

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Author:  Ovidiu Predescu <ovidiu@net-community.com>
   Date: June 1996
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#import <Foundation/NSAutoreleasePool.h>
#import <AppKit/AppKit.h>

@interface MyObject : NSObject
{
  id textfield;
}
@end

@implementation MyObject
- (void)buttonAction:(id)sender
{
  NSLog (@"buttonAction:");
}

- (void)buttonAction2:(id)sender
{
  NSLog (@"buttonAction2:");
  [textfield setStringValue:[sender intValue] ? @"on" : @"off"];
}

- (void)setTextField:(id)anObject
{
  [anObject retain];
  [textfield release];
  textfield = anObject;
}
@end

int
main(int argc, char **argv, char** env)
{
    NSApplication *theApp;
    NSWindow *win;
    NSRect wf = {{100, 100}, {400, 400}};
    NSView *v;
    id pool;
    NSView* anotherView1;
    NSView* anotherView2;

    NSButton *mpush, *ponpoff, *toggle, *swtch, *radio, *mchange, *onoff,
	    *light;
    NSRect bf0 = {{5, 5}, {200, 50}};
    NSRect bf1 = {{5, 65}, {90, 45}};
    NSRect bf2 = {{5, 115}, {90, 26}};
    NSRect bf3 = {{5, 170}, {200, 26}};
    NSRect bf4 = {{5, 225}, {200, 26}};
    NSRect bf5 = {{5, 280}, {200, 50}};
    NSRect bf6 = {{10, 10}, {100, 20}};
    NSRect bf7 = {{120, 115}, {90, 26}};
    NSRect anotherView1Frame = {{5, 335}, {240, 70}};
    NSRect anotherView2Frame = {{10, 10}, {220, 50}};
    NSRect textFieldRect = {{125, 10}, {80, 20}};
    NSTextField* textfield;
    MyObject* target;

#if LIB_FOUNDATION_LIBRARY
  [NSProcessInfo initializeWithArguments:argv count:argc environment:env];
#endif

#ifndef NX_CURRENT_COMPILER_RELEASE
    initialize_gnustep_backend();
#endif

    pool = [NSAutoreleasePool new];
    theApp = [NSApplication sharedApplication];

#if 0
    win = [[NSWindow alloc]
		initWithContentRect:wf
		styleMask:NSTitledWindowMask
		backing:NSBackingStoreNonretained
		defer:NO];
#else
    win = [[NSWindow alloc] init];
#endif
    [win setFrame: wf display: YES];
    [win setTitle:@"GNUstep Buttons"];
//    [win makeKeyAndOrderFront:nil];

    v = [win contentView];

    NSLog(@"Create the buttons\n");
    mpush = [[NSButton alloc] initWithFrame: bf0];
    [mpush setTitle: @"MomentaryPush"];
    [mpush setTarget:[[MyObject new] autorelease]];
    [mpush setAction:@selector(buttonAction:)];
    [mpush setContinuous:YES];

    ponpoff = [[NSButton alloc] initWithFrame: bf1];
    [ponpoff setButtonType:NSToggleButton];
    [ponpoff setTitle: @"Toggle"];
    [ponpoff setAlternateTitle: @"Alternate"];
    [ponpoff setImage:[NSImage imageNamed:@"NSSwitch"]];
    [ponpoff setAlternateImage:[NSImage imageNamed:@"NSHighlightedSwitch"]];
    [ponpoff setImagePosition:NSImageAbove];
    [ponpoff setAlignment:NSCenterTextAlignment];

    toggle = [[NSButton alloc] initWithFrame: bf2];
    [toggle setButtonType: NSToggleButton];
    [toggle setTitle: @"Toggle"];

    light = [[NSButton alloc] initWithFrame: bf7];
    [light setButtonType: NSMomentaryLight];
    [light setTitle: @"Light"];

    swtch = [[NSButton alloc] initWithFrame: bf3];
    [swtch setButtonType: NSSwitchButton];
    [swtch setBordered: NO];
    [swtch setTitle: @"Switch"];
    [swtch setAlternateTitle: @"Alternate"];

    radio = [[NSButton alloc] initWithFrame: bf4];
    [radio setButtonType: NSRadioButton];
    [radio setBordered: NO];
    [radio setTitle: @"Radio"];
    [radio setAlternateTitle: @"Alternate"];

    mchange = [[NSButton alloc] initWithFrame: bf5];
    [mchange setButtonType: NSMomentaryChangeButton];
    [mchange setTitle: @"MomentaryChange"];
//    [mchange setAlternateTitle: @"Alternate"];

    anotherView1 = [[NSView alloc] initWithFrame:anotherView1Frame];
    anotherView2 = [[NSView alloc] initWithFrame:anotherView2Frame];

    onoff = [[NSButton alloc] initWithFrame: bf6];
    [onoff setButtonType: NSOnOffButton];
    [onoff setTitle: @"OnOff"];
    target = [[MyObject new] autorelease];
    [onoff setTarget:target];
    [onoff setAction:@selector(buttonAction2:)];

    textfield = [[[NSTextField alloc] initWithFrame:textFieldRect]
			autorelease];
    [target setTextField:textfield];
    [textfield setStringValue:@"off"];

    NSLog(@"Make the buttons subviews\n");
    [v addSubview: mpush];
    [v addSubview: ponpoff];
    [v addSubview: toggle];
    [v addSubview: swtch];
    [v addSubview: radio];
    [v addSubview: mchange];
    [v addSubview:anotherView1];
    [anotherView1 addSubview:anotherView2];
    [anotherView2 addSubview:onoff];
    [anotherView1 addSubview:textfield];
    [v addSubview:light];

    [win orderFront:nil];

    NSLog(@"Start the application\n");
    [theApp run];

    [pool release];
    return 0;
}
