# =============================================================================
#
# File:		cb_bindings.tcl
# Project:	cb_tools
# Started:	?
# Changed:	10.07.95
# Author:       Christian Bolik (zzhibol@rrzn-user.uni-hannover.de)
#
# Description:	This file contains additional bindings for several 
#		widget classes.
#
# -----------------------------------------------------------------------------
#
# Sections:
#	==== Entry-Bindings
#
# =============================================================================

# Make some bindings available even if tk_strictMotif is true:
#if $tk_strictMotif {}
# Buttons:
bind Button <Return> [bind Button <space>]
bind Checkbutton <Return> [bind Button <space>]
bind Radiobutton <Return> [bind Button <space>]

# Text:
bind Text <2> {
    %W scan mark %x %y
    set tkPriv(x) %x
    set tkPriv(y) %y
    set tkPriv(mouseMoved) 0
}
bind Text <B2-Motion> {
    if {(%x != $tkPriv(x)) || (%y != $tkPriv(y))} {
	set tkPriv(mouseMoved) 1
    }
    if $tkPriv(mouseMoved) {
	%W scan dragto %x %y
    }
}
bind Text <ButtonRelease-2> {
    if {!$tkPriv(mouseMoved)} {
	tkTextPaste %W %x %y
    }
}
bind Text <Control-k> {
    if [%W compare insert == {insert lineend}] {
	%W delete insert
    } else {
	%W delete insert {insert lineend}
    }
}


# ==== Entry-Bindings =========================================================

#bind Entry <FocusIn> {
#    %W selection range 0 end
#}

# ==== Text-Bindings ==========================================================

catch {bind Text <braceleft> {%W insert insert \{;cb_Text_change_callback %W}}
catch {bind Text <braceright> {%W insert insert \};cb_Text_change_callback %W}}
catch {bind Text <bracketleft> {%W insert insert \[;cb_Text_change_callback %W}}
catch {bind Text <bracketright> {%W insert insert \];cb_Text_change_callback %W}}
catch {bind Text <backslash> {%W insert insert \\;cb_Text_change_callback %W}}
catch {bind Text <at> {%W insert insert @;cb_Text_change_callback %W}}
catch {bind Text <mu> {%W insert insert ;cb_Text_change_callback %W}}
catch {bind Text <bar> {%W insert insert |;cb_Text_change_callback %W}}
catch {bind Text <asciitilde> {%W insert insert ~;cb_Text_change_callback %W}}
catch {bind Text <grave> {%W insert insert `;cb_Text_change_callback %W}}

bind Text <Control-Left> {
    %W mark set insert "insert - 1 chars"
    %W mark set insert "insert wordstart"
    %W yview -pickplace insert
    cb_Text_extend_sel %W    
}
bind Text <Control-Right> {
    %W mark set insert "insert wordend"
    %W yview -pickplace insert
    cb_Text_extend_sel %W    
}
bind Text <Alt-d> {
    set tmpsel {insert "insert wordend"}
    set cb_Text(cutbuffer,%W) [eval %W get $tmpsel]
    eval %W delete $tmpsel
    catch "selection clear %W"
    cb_Text_change_callback %W %A
}
bind Text <Control-space> {
    selection clear %W
    if [info exists cb_Text(selstart)] {
	if [%W compare cb_selstart) == insert] {
	    %W mark unset cb_selstart
	    unset cb_Text(selstart)
	} else {
	    %W mark unset cb_selstart
	    %W mark set cb_selstart insert
	    set cb_Text(selstart) 1
	}
    } else {
	%W mark set cb_selstart insert
	set cb_Text(selstart) 1
    }
}
bind Text <Left> {+cb_Text_extend_sel %W}
bind Text <Right> {+cb_Text_extend_sel %W}
bind Text <Up> {+cb_Text_extend_sel %W}
bind Text <Down> {+cb_Text_extend_sel %W}
bind Text <Prior> {+cb_Text_extend_sel %W}
bind Text <Next> {+cb_Text_extend_sel %W}
bind Text <Home> {+cb_Text_extend_sel %W}
bind Text <End> {+cb_Text_extend_sel %W}
bind Text <Button-1> {+if [info exists cb_Text(selstart)] {
    unset cb_Text(selstart)
    catch {%W mark unset cb_selstart}
}   }

bind Text <Key> {+cb_Text_change_callback %W %A}
bind Text <Control-d> {+cb_Text_change_callback %W}
bind Text <Control-h> {+cb_Text_change_callback %W}
bind Text <Control-k> {+cb_Text_change_callback %W}
bind Text <Control-i> {+cb_Text_change_callback %W}
bind Text <Control-o> {+cb_Text_change_callback %W}
bind Text <Control-t> {+cb_Text_change_callback %W}
bind Text <Control-w> {+cb_Text_change_callback %W}
bind Text <BackSpace> {+cb_Text_change_callback %W}
bind Text <Delete> {+cb_Text_change_callback %W}
bind Text <F18> {+cb_Text_change_callback %W}
bind Text <F20> {+cb_Text_change_callback %W}
bind Text <Return> {+cb_Text_change_callback %W}
bind Text <Tab> {+cb_Text_change_callback %W}
bind Text <mu> {+cb_Text_change_callback %W}
bind Text <Meta-BackSpace> {+cb_Text_change_callback %W}
bind Text <Meta-Delete> {+cb_Text_change_callback %W}

#
# ==== Procs ==================================================================
#

#
# -----------------------------------------------------------------------------
#
# Proc:		cb_pointToType
# Args:		
# Returns: 	""
# Desc:		Adds bindings to toplevels, entries and texts to support
#		point-to-type focus model.
# Side-FX:	none
#

proc cb_pointToType {} {

    bind Toplevel <Any-Enter> "
	[bind Toplevel <Any-Enter>]
	focus %W
	"
    bind Text <Any-Enter> "
	[bind Text <Any-Enter>]
	focus %W
	"
    bind Entry <Any-Enter> "
	[bind Entry <Any-Enter>]
	focus %W
	"
    bind Toplevel <Any-Leave> "
	[bind Toplevel <Any-Leave>]
	if {\[focus\] == \"%W\"} {
	    focus none
	}
	"
    bind Text <Any-Leave> "
	[bind Text <Any-Leave>]
	if {\[focus\] == \"%W\"} {
	    focus none
	}
	"
    bind Entry <Any-Leave> "
	[bind Entry <Any-Leave>]
	if {\[focus\] == \"%W\"} {
	    focus none
	}
	"
}

#
# -----------------------------------------------------------------------------
#
# Proc:		cb_bindForCompletion
# Args:		w	entry widget name
#		ev	(opt.) event that triggers the completion (in <...>)
# Returns: 	""
# Desc:		This adds a binding to the entry widget $w that tries
#		to complete its contents to a filename.
# Side-FX:	none
#

proc cb_bindForCompletion {w {ev "<Tab>"}} {
    global cb_tools

    bind $w $ev {
	set tmp [%W get]*
	if {[set tmpspc [string first " " $tmp]] > -1} {
	    set tmp [string range $tmp [expr $tmpspc + 1] end]
	}
	set tmplist ""
	catch "set tmplist \[glob $tmp\]"
	if {[llength $tmplist] == 1} {
	    if [file isdirectory $tmplist] {
		set tmplist $tmplist/
	    }
	    %W delete [expr $tmpspc + 1] end
	    %W insert end $tmplist
	    %W xview end
	} else {
	    if [info exists cb_tools(bell_cmd)] {
		eval $cb_tools(bell_cmd)
	    } else {
		catch blt_bell
	    }
	}
	catch "unset tmp tmplist tmpspc"
	break
    }
}

# -----------------------------------------------------------------------------
#
# Proc:    cb_Text_extend_sel
# Desc:    Extends the sel tag on the given window.
# In:      w: text widget
# Out:     ""
# Side FX: none
#

proc cb_Text_extend_sel {w} {
    global cb_Text

    if [info exists cb_Text(selstart)] {
	$w tag remove sel 1.0 end
	if [$w compare cb_selstart < insert] {
	    $w tag add sel cb_selstart insert
	} else {
	    $w tag add sel insert cb_selstart
	}
    }
}

# -----------------------------------------------------------------------------
#
# Proc:    cb_Text_change_callback
# Desc:    Invokes a callback when the text widget's contents has been changed.
# In:      w: text widget's name
# Out:     ""
# Side FX: none
#

proc cb_Text_change_callback {w {char x}} {
    global cb_Text

    if [info exists cb_Text(selstart)] {
	unset cb_Text(selstart)
	catch {$w mark unset cb_selstart}
    }
    if {$char != ""} {
	if [info exists cb_Text(change_callback,$w)] {
	    eval $cb_Text(change_callback,$w)
	}
    }
}

