#
# $Source: /home/nlfm/Working/Zircon/Development/lib/RCS/userCmds.tcl,v $
# $Date: 1996/01/22 09:12:06 $
# $Revision: 1.16.1.6 $
#
#
#	Users cmds
#
#
proc userInvite {net chan} {
    mkEntryBox .@invite Invite {Enter user and channel:} \
      "{User {}} {Channel $chan}" "OK {$net INVITE}" {Cancel {}}
}
#
proc doMsg {net nk} {
    if {${nk} != {}} { Message :: make $nk }
}
#
proc userMsg {net} {
    mkEntryBox .@msg Message {Enter user name:} \
      {{User {}}} "OK {doMsg $net}" {Cancel {}}
}
#
proc userFinger {net} {
    mkEntryBox .@msg Finger {Enter user name:} \
      {{User ""}} "OK {finger $net}" {Cancel {}}
}
#
proc userNotice {net} {
    mkEntryBox .@not Message {Enter user name and notice text:} \
      {{User {}} {Notice {}}} "OK {$net NOTICE}" {Cancel {}}
}
#
proc userWhois {net} {
    mkEntryBox .@wis Whois {Enter user name and server:} \
      {{User {}} {Where {}}} "OK {$net WHOIS}" {Cancel {}}
}
#
proc userWhowas {net} {
    mkEntryBox .@was Whowas {Enter user name and count:} \
      {{User {}} {Count {}}} "OK {$net WHOWAS}" {Cancel {}}
}
#
proc doUMode {net nk mode} {
    if {$nk != {} && [string match {[+-]*} mode]} {$net qSend MODE $nk :$mode }
}
#
proc userMode {net} {
    global myid
    mkEntryBox .@umode {User Mode} {Enter user and mode:} \
      "{User [$myid name]} {Mode {}}" "OK {doUMode $net}" {Cancel {}}
}
#
proc userCmd {net cmd args} {
    switch -exact -- $cmd {
    Mode { userMode $net}
    Finger {userFinger $net}
    Invite { userInvite $net {} }
    Msg {userMsg $net}
    Notice {userNotice $net}
    Kill {userKill $net}
    Whois {userWhois $net}
    Whowas {userWhowas $net}
    default {
	    mkEntryBox .@$cmd "$cmd" {Enter user pattern:} {{User {}}}\
	      "OK {$net send [string toupper $cmd]}" {Cancel {}}
	}
    }
}
