#
# $Source: /user/nlfm/Working/Zircon/Development/lib/RCS/On.tcl,v $
# $Date: 1995/09/26 11:32:27 $
# $Revision: 1.16.1.2 $
#
#
# ON condition support code
#
proc on {action pattern code} {
    global OnCode
    set pat {}
    foreach p $pattern { lappend pat [string tolower $p] }
    lappend OnCode([string toupper $action]) [list $pat $code]
}
#
proc processOns {} {
    global OnCode ons
    if {$ons != {}} {
	foreach act $ons {
	    lappend OnCode([lindex $act 0]) [lrange $act 1 end]
	}
	mkDialog {} .@ons {On Warning} \
	  {Your configuration file needs updating ("on" format).} {} \
	  {Update {saverc}} {Cancel {}}
    }
}
#
proc handleOn {action pattern} {
    global OnCode zircon
    if {!$zircon(o) && [info exists OnCode($action)]} {
	foreach act $OnCode($action) {
	    set re [lindex $act 0]
	    set i 0
	    set match 1
	    foreach pat $pattern {
		set up [lindex $re $i]
		if {$up != {} && ![regexp -nocase -- $up $pat]} {
		    set match 0
		    break
		}
		incr i
	    }
	    if $match {
		set i 0
		foreach pat $pattern {
		    global onPar${i}
		    set onPar${i} $pat
		    incr i
		}
		if [catch {uplevel #0 [lindex $act 1]} msg] {
		    mkDialog ON .@on "On Command Error" \
		  "Error when executing on command \"[lindex $act 1]\" : $msg" \
		  {} "OK {}"
		}
		catch {eval unset [info globals onPar*]}
		if !$zircon(multion) return
	    }
	}
    }
}
#
proc operator {chan} {
    return [[Channel :: find ${chan}] operator]
}
