.\" $Id: xboard.man,v 1.52 1995/12/09 07:49:09 mann Exp $
.TH xboard 6 "$Date: 1995/12/09 07:49:09 $" "GNU"
.SH NAME
.PP
xboard \- X user interface for GNU Chess, the Internet Chess Server (ICS),
and electronic mail correspondence chess.
.SH SYNOPSIS
.PP
To run with GNU Chess:
.B xboard [options]
.br
To run with the ICS:
.B xboard -ics [options]
.br
To play email chess: See
.BR cmail (6).
.br
To run standalone:
.B xboard -ncp [options]
.br
To use in a pipeline:
.B |pxboard
.SH DESCRIPTION
.PP
.BR xboard
is a graphical chessboard that can serve as a
user interface for GNU Chess, for the Internet Chess Server, 
or for electronic mail correspondence chess.
.BR xboard 
can also be used by itself.
.PP
As an interface to GNU Chess,
.BR xboard
lets you play a game against the machine,
set up arbitrary positions,
force variations, or watch
a game between two machines.
.PP
As an interface to the Internet Chess Server (ICS),
.B xboard -ics
lets you play against other ICS users,
observe games they are playing, or review
games that have recently finished.  
All the "wild" chess variants on ICS are supported,
including bughouse.
.PP
As an interface to electronic mail correspondence chess,
.BR xboard
works with the
.BR cmail (6)
program.  See its manual page for instructions.
.PP
You can also use
.BR xboard
as a chessboard to play through games.
It will read and write game files and allow you to play 
through variations manually.
You can use it to browse games off the net
or review GNU Chess, ICS, and correspondence games you have saved.  
These features are available at all times; even if you do not have
access to GNU Chess or the ICS, you can use them by giving the command
.BR "xboard -ncp" .
.PP
To view games from a netnews reader like
.BR rn (1)
or
.BR xrn (1),
use the news reader's Save command and specify "|pxboard"
as the save
file name.  This pipes the article to 
.BR pxboard ,
a simple shell script that saves the article to a temporary file and runs
.BR xboard
in the background.  See the script itself for more information.
.PP
After starting
.BR xboard ,
you make moves by dragging pieces with the mouse.  
Press mouse button 1 while the cursor is on one of your pieces, then
move the cursor to another square and release the button.
To drop a new piece on a square (when applicable),
press button 2 or 3 over the square and select from the popup menu.
.PP
When
.BR xboard
is iconized, its graphical icon is a white knight if it is White's turn to
move, a black knight if it is Black's turn.  See 
.B Iconize
below if you have problems getting this feature to work.
.SH OPTIONS
.PP
Most of the 
.BR xboard
options have both a long name and a short name.
To turn a boolean option on or off from the command line, either give
its long name followed by the value True or False
.RI ( -longOptionName
True), or give
just the short name to turn the option on
.RI ( -opt ),
or the short name preceded by "x" to turn the option off
.RI ( - x opt ).
For options that take strings or numbers as values, you can use the long or
short option names interchangeably.
.PP
Each option corresponds to an X resource
with the same name, so you can set options in your
.IR \&.Xdefaults
file if you like.
For options that have two names, the longer
one is the name of the corresponding X resource; the short name is not
recognized in \&.Xdefaults.
To turn a boolean option on or off in your \&.Xdefaults
file, give its long name followed by the value True or False 
.RI (XBoard* longOptionName :
True).
.SH GNU Chess Options
.TP 8
.B -tc or -timeControl minutes[:seconds]
Each player begins with his clock set to the timeControl period.
Default: 5 minutes.
The additional options movesPerSession and timeIncrement are mutually
exclusive.  
.TP 8
.B -mps or -movesPerSession moves
When both players have made movesPerSession moves, a
new timeControl period is added to both clocks.  Default: 40 moves.
.TP 8
.B -inc or -timeIncrement seconds
If this option is specified, movesPerSession is ignored.
Instead, after each player's move, timeIncrement seconds are
added to his clock.  
Use -timeIncrement 0 if you want to require the entire
game to be played in one timeControl period, with no increment.
Default: -1, which specifies movesPerSession mode.
.TP 8
.B -clock or -clockMode
Determines whether or not to display the chess clocks.
If clockMode is False, the clocks are not shown, but the
side that is to play next is still highlighted.  Also, unless 
searchTime or searchDepth is set, GNU Chess still keeps track of the
clock time and uses it to determine how fast to make its moves.
.TP 8
.B -st or -searchTime minutes[:seconds]
Tells GNU Chess to spend at most the given amount of time searching
for each of its moves.  Without this option, GNU Chess chooses
its search time based on the number of moves and amount of time
remaining until the next time control.
Setting this option also sets clockMode to False.
.TP 8
.B -sd or -searchDepth number
Tells GNU Chess to look ahead at most the given number of moves when searching
for a move to make.  Without this option, GNU Chess chooses
its search depth based on the number of moves and amount of time
remaining until the next time control.
Setting this option also sets clockMode to False.
.TP 8
.B -thinking or -showThinking
If this option is set, GNU Chess's notion of the score and best line of play
from the current position is displayed as it is thinking.  The score indicates
how many pawns ahead (or if negative, behind) GNU Chess thinks it is.  
When GNU Chess is thinking on your time, this thinking is not shown if GNU
Chess was compiled with the -DQUIETBACKGROUND option.
In matches between two machines, the score is prefixed by W or B to indicate
whether the display is of White's thinking or Black's, and thinking on the
opponent's time is never shown.
.TP 8
.B -mm or -matchMode
Automatically runs a game between two chess programs.
If the loadGameFile or loadPositionFile option is set, 
.BR xboard
starts the game with the given opening moves or the given
position; 
otherwise, the game starts with the standard initial chess position.
If the saveGameFile 
option is set, a move record for the match
is appended to the specified file.
If the savePositionFile 
option is set, the final position reached in the match
is appended to the specified file.
When the match is over, 
.BR xboard
exits.
Default: False.
.TP 8
.B -fcp or -firstChessProgram program
Name of first chess program.
In matches between two machines, this program plays Black.
Default:
.IR gnuchessx .
.TP 8
.B -scp or -secondChessProgram program
Name of second chess program, if needed.
In matches between two machines, this program plays White; otherwise
it is not started.
Default: 
.IR gnuchessx .
.TP 8
.B -fh or -firstHost host
.PD 0
.TP 8
.B -sh or -secondHost host
Hosts on which the chess programs are to run.  
The default for each is 
.IR localhost .
If you specify another host, 
.BR xboard
uses 
.BR rsh (1)
to run the chess program there.
(You can substitute a different remote shell program for rsh using the
remoteShell option described below.)
.PD
.TP 8
.B -initString string
The string that is sent to initialize the chess program.
Default:
.nf
    new
    beep
    random
    easy
.fi
Setting this option from the command line is tricky,
because you must type in real newline characters, including one at the end.
In most shells you can
do this by entering a "\\" character followed by a newline.
It is easier to set the option from your \&.Xdefaults file;
in that case you can include the character sequence "\\n" in the string, and
it will be converted to a newline.

If you change this option, don't remove the 
.I new
and
.I beep
commands.
You can remove the 
.I random
command if you
like; including it causes GNU Chess to randomize its move selection slightly so
that it doesn't play the same moves in every game.  
(Even without 
.IR random ,
GNU Chess
randomizes its choice of moves from its opening book.)
You can also remove 
.I easy
if you like; including it toggles easy mode
off, causing GNU Chess to think on your time.
That is, if 
.I easy
is 
.I included
in the initString, GNU Chess thinks on your time; if not, it does not.  
Yes, this does seem backwards, doesn't it!
You can also try adding other commands to the initString; 
see the GNU Chess documentation for details.
.TP 8
.B -whiteString string
.PD 0
.TP 8
.B -blackString string
These options control what is sent when the Machine White and Machine Black
buttons are selected.  This is mostly for compatibility with obsolete versions
of GNU Chess.
.PD
.SH Internet Chess Server Options
.TP 8
.B -ics or -internetChessServerMode
Connect with an Internet Chess Server to play chess against
its other users, observe games they are playing, or
review games that have recently finished.  Default: False.

To use xboard in ICS mode, run it in the foreground, and use the
terminal you started it from to type commands and receive text responses
from the chess server.  Useful ICS commands include
.IR who
to see who is logged on,
.IR games
to see what games are being played,
.IR match
to challenge another player to a game,
.IR observe
to observe an ongoing game,
.IR examine
or
.IR oldmoves
to review a recently completed game,
and of course
.IR help .
Some special 
.BR xboard
features are activated when you are in 
.IR examine 
mode on ICS.  See the descriptions of the menu commands
Forward, Backward, Pause, ICS Client, and Stop Examining below.
.TP 8
.B -icslogon or -internetChessServerLogonScript file-name
Whenever
.BR xboard
connects to the Internet Chess Server, if it finds a file with
the name given in this option,
it feeds the file's contents to the ICS as commands.
The default file name is 
.IR .icsrc .
Usually the first two lines of the file should be your ICS user name
and password.
The file can be either in $CHESSDIR, in 
.BR xboard 's
working directory if CHESSDIR is not set, or in your home directory.
.TP 8
.B -autocomm or -autoComment
If autoComment is True, any remarks made on ICS while you are observing or
playing a game are recorded as a comment on the current move.  This includes
remarks made with the ICS commands
.I say, tell, whisper,
and
.I kibitz.
Limitation: remarks that you type yourself are not recognized;
.BR xboard
scans only the output from ICS, not the input you type to it.
Default: False.
.TP 8
.B -autoflag or -autoCallFlag
If autoCallFlag is True and your opponent runs out of time
before you do,
.BR xboard
will automatically call his flag, claiming a win on time (or a draw
if you do not have mating material).
Default: False.
.TP 8
.B -autobs or -autoObserve
If autoObserve is True and you add a player to your 
.IR gnotify
list on ICS,
.BR xboard
will automatically observe all of that player's games, unless you are
doing something else (such as observing or playing a game of your own) when
one starts.
The games are displayed 
from the point of view of the player on your gnotify list; that is, his
pawns move from the bottom of the window towards the top.
Exceptions:  If both players in a game are on your gnotify list, if
your ICS 
.IR highlight
variable is set to 0, or if the ICS you are using does not 
properly support observing from Black's point of view,
you will see the game from White's point of view.
Default: False.
.TP 8
.B -moves or -getMoveList
If getMoveList is True, whenever
.BR xboard
receives the first board of a new game (or a different game from
the one it is currently displaying), it
retrieves the list of past moves from the ICS.
You can then review the moves with the Forward and Backward commands
or save them with Save Game.  The default is True.  You might want to
turn off this option if you are observing several blitz games at once,
to keep from wasting time and network bandwidth fetching the move lists over
and over.
.TP 8
.B -quiet or -quietPlay
If this option is True, 
.BR xboard
will automatically issue a 
.I "set shout 0"
command whenever you start an ICS
game and a 
.I "set shout 1"
command whenever you finish one.  Default: False.
.TP 8
.B -icshost or -internetChessServerHost host
The Internet host name or address of the chess server to connect 
to when in ICS mode.  
Default: chess.lm.com.
See the file 
.I ics-addresses
in the 
.BR xboard
source distribution for a list of other addresses to try.  See
also the output of the command 
.IR "finger chess@ics.onenet.net" .
If your site doesn't have a working Internet name server, try 
specifying the host address in numeric form.  The address of chess.lm.com
is 192.231.221.16; that of ics.onenet.net is 164.58.253.10.
.TP 8
.B -icsport or -internetChessServerPort port-number
The port number to use when connecting to a chess server in ICS mode.
Default: 5000.
.TP 8
.B -gateway host-name
If this option is set to a host name,
.BR xboard
uses
.BR rsh (1)
to run the 
.BR telnet (1)
program on the given host to communicate with the Internet
Chess Server instead of using its own internal implementation 
of the telnet protocol.
You can substitute a different remote shell program for rsh using the
remoteShell option described below.
See the FIREWALLS section below for an explanation of when this option is
useful. 
.TP 8
.B -telnet or -useTelnet
If this option is set to True,
.BR xboard 
runs the 
.BR telnet (1)
program to communicate with the Internet Chess
Server.  If the option is False (the default),
.BR xboard
opens a TCP socket and uses its own internal implementation 
of the telnet protocol to communicate with the ICS.  
See the FIREWALLS section
below for an explanation of when this option is useful.
.TP 8
.B -telnetProgram prog-name
This option gives the name of the telnet program to be used with the 
gateway and useTelnet options.  The default is 
.IR telnet .
The telnet program 
is invoked with the value of internetChessServerHost as its first argument
and the value of internetChessServerPort as its second argument.
See the FIREWALLS section below for an explanation of when this option is
useful. 
.TP 8
.B -internetChessServerCommPort or -icscomm dev-name
If this option is set, 
.BR xboard
communicates with the ICS through the given character I/O device
instead of opening a TCP connection.
Use this option if your system
does not have any kind of Internet connection itself (not
even a SLIP or PPP connection), but you do have dialup access 
(or a hardwired terminal line) to an Internet
service provider from which you can telnet to the ICS.

The support for this option in 
.BR xboard
is minimal.  You need to set all communication parameters and tty modes
before you enter
.BR xboard .

Use a script something like this:

.nf
    stty raw -echo 9600 > /dev/tty00
    xboard -ics -icscomm /dev/tty00
.fi

Here replace 
.IR /dev/tty00
with the name of the device that your
modem is connected to.  
You might have to add several more options to these stty commands.  See the
man pages for 
.BR stty (1)
and
.BR tty (4)
if you run into problems.  Also, on many systems
stty works on its standard input instead of standard output, so you
have to use "<" instead of ">".

If you are using linux, try starting with the script below.  Change it as
necessary for your installation.

.nf
    ##################################################
    #!/bin/sh -f
    # configure modem and fire up xboard
    
    # configure modem
    ( stty 2400 ; stty raw ; stty hupcl ; stty -clocal 
      stty ignbrk ; stty ignpar ; stty ixon ; stty ixoff 
      stty -iexten ; stty -echo ) < /dev/modem

    xboard -ics -icscomm /dev/modem
    ##################################################
.fi

After you start
.BR xboard
in this way, type whatever commands are necessary to dial out to
your Internet provider and log in.
Then telnet to ICS, using a command like 
.IR "telnet chess.lm.com 5000" .
Important: See the paragraph in the LIMITATIONS section below 
about extra echoes.
.SH Load and Save Options
.TP 8
.B -lgf or -loadGameFile file
.PD 0
.TP 8
.B -lgi or -loadGameIndex index
If the loadGameFile option is set,
.BR xboard
loads the specified game file at startup.
The file name "-" specifies the standard input.
If there is more than one game in the file,
.BR xboard
pops up a menu of the available games, with entries based on their PGN 
(portable game notation) tags.
If the loadGameIndex option is set to
.IR N ,
the menu is suppressed and
the
.IR N th
game found in the file is loaded immediately.
The menu is also suppressed if matchMode is enabled or if the game file
is a pipe; in these cases the first game in
the file is loaded immediately.  Use the
.BR pxboard
shell script if you want to pipe files containing multiple games into
.BR xboard 
and still see the menu.
.PD
.TP 8
.B -td or -timeDelay seconds
Time delay between moves during 
.BR Load Game .
Fractional seconds are allowed; try -td 0.4.  
A time delay value of -1 tells
.BR xboard
not to step through game files automatically.
Default: 1 second.
.TP 8
.B -sgf or -saveGameFile file
If this option is set, 
.BR xboard 
appends a record of every game played to the specified file.
The file name "-" specifies the standard output.
.TP 8
.B -autosave or -autoSaveGames
If this option is True, at the end of every game
.BR xboard
prompts you for a file name and appends a record
of the game to the file you specify.  Ignored if saveGameFile is set.
.TP 8
.B -lpf or -loadPositionFile file
.PD 0
.TP 8
.B -lpi or -loadPositionIndex index
If the loadPositionFile option is set,
.BR xboard
loads the specified position file at startup.
The file name "-" specifies the standard input.
If the loadPositionIndex option is set to 
.IR N ,
the
.IR N th
position found in the file is loaded; otherwise the first position is loaded.
.PD
.TP 8
.B -spf or -savePositionFile file
If this option is set, 
.BR xboard 
appends the final position reached in
every game played to the specified file.
The file name "-" specifies the standard output.
.TP 8
.B -oldsave or -oldSaveStyle
If this option is False (the default), 
.BR xboard
saves games in PGN (portable game notation) and positions in FEN
(Forsythe-Edwards notation).  If the option is True, 
a save style that is compatible with older versions of
.BR xboard
is used instead.
.SH User Interface Options
.TP 8
.B standard Xt options
.BR xboard
accepts standard Xt options like -display, -geometry, and -iconic.
.TP 8
.B -bell or -ringBellAfterMoves
If this option is True,
.BR xboard
alerts you by ringing the terminal bell after each
of your opponent's moves (or after every move if
you are observing a game on the Internet Chess Server).
The bell is not rung after moves you make 
or moves read from a saved game file.  Default: False.

If you turn on this option when using
.BR xboard
with the Internet Chess Server, you will probably want to
give the 
.I "set bell 0"
command to the ICS, since otherwise the ICS
will ring the bell itself after every move.
.TP 8
.B -queen or -alwaysPromoteToQueen
If this option is False (the default),
.BR xboard
brings up a dialog box whenever you move a pawn to the last rank,
asking what piece you want to promote it to.  
If the option is True, your pawns are always promoted to
queens.  (Your opponent can still underpromote, however.)
.TP 8
.B -size or -boardSize "(Large | Medium | Small | Tiny | n1,n2,n3,n4,n5,n6)"
Determines how large the board will be.
The Large board uses 80x80 pieces, Medium 64x64, Small 40x40, and Tiny 21x21.
Piece bitmaps of all these sizes are built into
.BR xboard .
The default depends on the size of your screen; it is approximately the
largest size that will fit without clipping.

You can select other sizes or vary other layout parameters by providing
a list of comma-separated values (with no spaces) as the argument.
The n1 value gives the piece size, n2 the width of the black border
between squares, n3 the preferred pixel size for the 
.IR clockFont ,
n4 the preferred pixel size for the 
.IR coordFont ,
n5 the smallLayout flag (0 or 1), and n6 the tinyLayout flag (0 or 1).  
If smallLayout is 1 and 
.I titleInWindow
is True, 
the window layout is rearranged to make more room for the title.
If tinyLayout is 1, the labels on the menu bar are abbreviated
to one character each, the buttons in the button bar are made narrower,
and a smaller default font is used.
You do not need to provide all the values; for any you omit from the
end of the list, defaults are taken from the nearest built-in size.
.TP 8
.B -coords or -showCoords
If this option is True,
.BR xboard
displays algebraic coordinates along the board's left and bottom edges.
The default is False.  The
.IR coordFont
option specifies what font to use.  
.TP 8
.B -flip or -flipView
If you are
playing a game on the ICS, the board is always
oriented at the start of the game so that your 
pawns move from the bottom of the window towards the top.
Otherwise, the starting orientation 
is determined by the flipView option; if it is
False (the default), White's pawns move from bottom to top at the
start of each game; if it is True, Black's pawns move from bottom to top.
.TP 8
.B -title or -titleInWindow 
If this option is True, 
.BR xboard
displays player names (for ICS games) and game file names (for Load
Game) inside its main window.  If the option is False (the default),
this information is displayed only in the window banner.  You probably
won't want to set this option unless the information is not showing up
in the banner, as happens with a few X window managers.
.TP 8
.B -mono or -monoMode
Determines whether
.BR xboard
displays its pieces and squares with two colors (True) or four (False).
You shouldn't have to specify monoMode;
.BR xboard
will determine if it is necessary.
.TP 8
.B -borderXoffset
.PD 0
.TP 8
.B -borderYoffset
These options are part of a kludge 
that helps position the Comment and Edit Comment
windows in the same place on the screen when they are closed and reopened.
They should be set equal to the width and height of the borders that
your X window manager adds to windows when it displays them.  The
defaults are correct for 
.BR tvtwm (1).
.PD
.TP 8
.B -clockFont
The font used for the clocks.
If the option
value is a pattern that does not specify the font size, 
.BR xboard
tries to choose an appropriate font for the board size being used.
Default: -*-helvetica-bold-r-normal--*-*-*-*-*-*-*-*.
.TP 8
.B -coordFont
The font used for rank and file coordinate labels if 
.IR showCoords
is True.
If the option
value is a pattern that does not specify the font size, 
.BR xboard
tries to choose an appropriate font for the board size being used.
Default: -*-helvetica-bold-r-normal--*-*-*-*-*-*-*-*.
.TP 8
.B -font
The font used for popup dialogs, menus, comments, etc.
If tinyLayout is true (e.g., if "-size Tiny" is specified), the default is
-*-helvetica-medium-r-normal--11-*-*-*-*-*-*-*.  Otherwise, the default is
-*-helvetica-medium-r-normal--14-*-*-*-*-*-*-*.
.TP 8
.B -bitmapDirectory or -bm
By default, 
.BR xboard
uses a set of compiled-in bitmaps for its pieces, icons, and menu checkmark.
If the
.IR bitmapDirectory
option is set at runtime,
bitmaps are taken from files in the specified directory.
If any bitmap file is missing or unusable, 
.BR xboard
looks for a built-in bitmap of the required type and size instead.

Files in the bitmapDirectory must be named as follows:
The first character of a piece bitmap name gives the piece it 
represents (p, n, b, r, q, or k),
the next characters give the size in pixels, the
following character indicates whether the piece is solid or outline (s or o),
and the extension is ".bm".
For example, a solid 80x80 knight would be named "n80s.bm".
The outline bitmaps are used only in monochrome mode.
The icons are named "icon_white.bm" and "icon_black.bm", and the
menu checkmark is named "checkmark.bm".

Two sets of bitmaps are distributed with
.BR xboard .
Those in the directory
.I bitmaps
are normally compiled in as the default.
Those in the
.I bitmaps.xchess
directory can be selected at runtime with the bitmapDirectory option.
If you want to compile in the latter set as the default, rename the
.I bitmaps 
directory to "bitmaps.fselch" and the
.I bitmaps.xchess
directory to "bitmaps"; then recompile
.BR xboard .
If you want to add another compiled-in size, edit the bitmaps.h file
in the bitmaps directory, and
optionally edit xboard.h to associate a name and default layout
parameters with your new size.
.TP 8
.B -whitePieceColor
.PD 0
.TP 8
.B -blackPieceColor
.TP 8
.B -lightSquareColor
.TP 8
.B -darkSquareColor
Colors to use for the pieces and squares.
Defaults:

.nf
    -whitePieceColor     #FFFFCC
    -blackPieceColor     #202020
    -lightSquareColor    #C8C365
    -darkSquareColor     #77A26D
.fi

If you are using a grayscale monitor, try setting the colors to:

.nf
    -whitePieceColor     gray100
    -blackPieceColor     gray0
    -lightSquareColor    gray80
    -darkSquareColor     gray60
.fi
.PD
.SH Other Options
.TP 8
.B -ncp or -noChessProgram
If this option is True,
.BR xboard
acts as a passive chessboard; it does not
start a chess program at all.
Turning on this option also turns off clockMode.
Default: False.
.TP 8
.B -debug or -debugMode
Turns on debugging printout.
.TP 8
.B -rsh or -remoteShell shell-name
Name of the command used to run programs remotely.  
The default is 
.I rsh
or
.IR remsh ,
determined when
.BR xboard
is configured and compiled.
.TP 8
.B -ruser or -remoteUser user-name
User name on the remote system when running programs with the remoteShell.
The default is your local user name.
.SH MENU COMMANDS, BUTTONS, AND KEYS
.PP
All 
.BR xboard
commands are available on menus.  The most frequently used
commands also have shortcut keys or on-screen buttons.
.SH File Menu
.TP 8
.B Reset
Resets
.BR xboard
and GNU Chess to the beginning of a new chess game.
The "r" key is a keyboard equivalent.
In Internet Chess Server mode, clears the current state of 
.BR xboard ,
then resynchronizes with ICS by sending a 
.IR refresh
command.
If you want to stop playing, observing, or examining a game 
on ICS, use an appropriate command from the 
Action menu, not Reset.
.TP 8
.B Load Game
Plays a game from a record file.
The "g" key is a keyboard equivalent.
A popup dialog prompts you for the file name.
If the file contains more than one game, a second popup dialog displays
a list of games (with information drawn from their PGN tags, if any), and you
can select the one you want.
Alternatively, you can load the 
.IR N th
game in the file directly from the file name dialog, by typing the number
.IR N 
after the file name, separated by a space.

The game file parser will accept PGN (portable game notation), or
in fact almost any file that contains moves in algebraic notation.
Notation of the form "P@f7" is accepted for piece-drops in bughouse games;
this is a nonstandard extension to PGN.
If the file includes a PGN position (FEN tag), or an old-style
.BR xboard
position diagram
bracketed by "[--" and "--]" before the
first move, the game starts from that position.
Text enclosed in parentheses, square brackets, or curly braces 
is assumed to be commentary and is displayed in a pop-up window.
Any other text in the file is ignored.  PGN variations (enclosed in 
parentheses) are treated as comments; 
.BR xboard
is not able to walk variation trees.
.TP 8
.B Load Next Game
Loads the next game from the last game record file you loaded.
The shifted "N" key is a keyboard equivalent.
.TP 8
.B Load Previous Game
Loads the previous game from the last game record file you loaded.
The shifted "P" key is a keyboard equivalent.
Not available if the last game was loaded from a pipe.
.TP 8
.B Reload Same Game
Reloads the last game you loaded.
Not available if the last game was loaded from a pipe.
.TP 8
.B Load Position
Sets up a position from a position file.
A popup dialog prompts you for the file name.
If the file contains more than one saved position, and you want
to load the 
.IR N th
one, type the number 
.IR N 
after the file name, separated by a space.
Position files must be in FEN (Forsythe-Edwards notation), or in the format
that the Save Position command writes when oldSaveStyle is turned on.
.TP 8
.B Save Game
Appends a record of the current game to a file.
A popup dialog prompts you for the file name.
If the game did not begin with the standard starting position,
the game file includes the starting position used.
Games are saved in the PGN (portable game notation) format,
unless the oldSaveStyle option is
True, in which case they are saved in an older format that is specific to 
.BR xboard .
Both formats are human-readable, and both can be read back by the Load Game 
command. 
Notation of the form "P@f7" is generated for piece-drops in bughouse games;
this is a nonstandard extension to PGN.
.TP 8
.B Save Position
Appends a diagram of the current position to a file.
A popup dialog prompts you for the file name.
Positions are saved in FEN (Forsythe-Edwards notation) format unless
the oldSaveStyle option is True, in which case they are saved in an older,
human-readable format that is specific to 
.BR xboard .
Both formats can be read back by the Load Position command.
.TP 8
.B Mail Move
.PD 0
.TP 8
.B Reload CMail Message
See the manual page for
.BR cmail (6).
.PD
.TP 8
.B Exit
Exits from
.BR xboard .
The "q" key is a keyboard equivalent.
.SH Mode Menu
.TP 8
.B Machine White
Forces GNU Chess to play White.  GNU Chess mode only.
.TP 8
.B Machine Black
Forces GNU Chess to play Black.  GNU Chess mode only.
.TP 8
.B Two Machines
Plays a game between two computer programs.  GNU Chess mode only.
.TP 8
.B ICS Client
ICS mode only.  Takes 
.BR xboard
out of the Edit Game or Edit Position state.

While you are examining a game on the ICS,
you can issue the ICS position-editing commands with the mouse.  
Do this with ICS Client selected on the Mode menu, not Edit Position; the
latter edits only your local copy of the position.
To drop a new piece on a square, press mouse button 2 or 3
over the square.  This brings up a menu of white pieces (button 2) or black
pieces (button 3).  Additional menu choices let you empty the square or
clear the board.
You cannot set the side to play or drag pieces to arbitrary squares while
examining on ICS, however; the ICS permits only legal moves in this mode.

If you are playing a bughouse game on the ICS, you can drop an offboard piece
by pressing mouse button 2 or 3 over an empty square to bring up a piece menu.
It makes no difference which button you use.  A list of the offboard pieces
each player has available is shown in the window title after the player's name.
.TP 8
.B Edit Game
Allows you to make moves for both Black and White, and
to change moves after backing up with the Backward command.
The clocks do not run.

In GNU Chess mode, GNU chess continues to check moves for
legality but does not participate in the game.  You can bring GNU
Chess back into the game by selecting Machine White, Machine Black, 
or Two Machines.

In ICS mode, the moves are not sent to the ICS:
Edit Game takes 
.BR xboard
out of ICS Client mode and lets you edit games locally.
If you want to edit
games on ICS in a way that other ICS users can see,
use the ICS
.IR examine
command or start an ICS match against yourself.
.TP 8
.B Edit Position
Lets you set up an arbitrary board position.
Use mouse button 1 to drag pieces to new squares, or to
delete a piece by dragging it off the board or dragging an empty square
on top of it.  To drop a new piece on a square, press mouse button 2 or 3
over the square.  This brings up a menu of white pieces (button 2) or black
pieces (button 3).  Additional menu choices let you empty the square or
clear the board.  You can set the side to play next
by clicking on the White or Black indicator at the top of the screen.
Selecting Edit Position causes 
.BR xboard
to discard all remembered moves in the current game.

In ICS mode, changes made to the position by Edit Position
are not sent to the ICS:  Edit Position takes 
.BR xboard
out of ICS Client mode and lets you edit positions locally.
If you want to edit
positions on ICS in a way that other ICS users can see,
use the ICS
.IR examine
command, or start an ICS match against yourself.  
(See also the ICS Client topic above.)
.TP 8
.B Show Game List
Shows or hides the list of games generated by the last Load Game command.
.TP 8
.B Edit Tags
Lets you edit the PGN (portable game notation)
tags for the current game.  After editing, the tags must still conform to
the PGN tag syntax:

.nf
    <tag-section> ::= <tag-pair> <tag-section>
		      <empty>
    <tag-pair> ::= [ <tag-name> <tag-value> ]
    <tag-name> ::= <identifier>
    <tag-value> ::= <string>
.fi

See the PGN Standard for full details.  Here is an example:

.nf
    [Event "Portoroz Interzonal"]
    [Site "Portoroz, Yugoslavia"]
    [Date "1958.08.16"]
    [Round "8"]
    [White "Robert J. Fischer"]
    [Black "Bent Larsen"]
    [Result "1-0"]
.fi

Any characters that do not match this syntax are silently ignored.  Note that
the PGN standard requires all games to have at least the seven tags shown
above.  Any that you omit will be filled in by
.BR xboard
with "?" (unknown value), or "-" (inapplicable value).
.TP 8
.B Edit Comment
Adds or modifies a comment on the current position.  Comments are
saved by Save Game and are displayed by Load Game, Forward, and Backward.
.TP 8
.B Pause
Pauses updates to the board, and if you are playing
against GNU Chess, also pauses your clock.
To continue, select Pause again, and the display will automatically
update to the latest position.
The [P] button and keyboard "p" key are equivalents.

If you select Pause when you are playing against GNU Chess and
it is not your move, GNU Chess's clock
will continue to run and it will eventually make a move, at which point
both clocks will stop.  Since board updates are paused, however,
you will not see the move until you exit from Pause mode (or select Forward).
This behavior is meant to simulate adjournment with a sealed move.

If you select Pause while you are in 
.IR examine
mode on ICS, you can step
backward and forward in the current history of the examined game without
affecting the other observers and examiners.  Select Pause again to reconnect
yourself to the current state of the game on ICS.

If you select Pause while you are loading a game, the 
game stops loading.
You can load more moves manually by selecting Forward, or resume automatic
loading by selecting Pause again.
.SH Action Menu
.TP 8
.B Accept
Accepts a pending match offer.
If there is more than one offer pending, you will have to type in a more
specific command instead of using this menu choice.  (ICS mode only)
.TP 8
.B Decline
Declines a pending offer (match, draw, adjourn, etc.).
If there is more than one offer pending, you will have to type in a more
specific command instead of using this menu choice.  (ICS mode only)
.TP 8
.B Call Flag
Calls your opponent's flag, claiming a win on time, or claiming a draw
if you are both out of time.  You can also call your opponent's flag
by clicking on his clock or by pressing the keyboard "t" key.
.TP 8
.B Draw
Offers a draw to your opponent, accepts a pending draw offer
from your opponent, or claims a draw by repetition or the 50-move 
rule, as appropriate.  The "d" key is a keyboard equivalent.  (Not available
in GNU Chess mode.)
.TP 8
.B Adjourn
Asks your opponent to agree to adjourning the current game, or
agrees to a pending adjournment offer from your opponent.  (ICS mode only)
.TP 8
.B Abort
Asks your opponent to agree to aborting the current game, or
agrees to a pending abort offer from your opponent.
An aborted game ends immediately without affecting either player's rating.
.TP 8
.B Resign
Resigns the game to your opponent.  The shifted "R" key is a keyboard
equivalent. 
.TP 8
.B Stop Observing
Ends your participation in observing a game, by issuing the ICS
.IR observe
command with no arguments.  (ICS mode only)
.TP 8
.B Stop Examining
Ends your participation in examining a game, by issuing the ICS
.IR unexamine
command.  (ICS mode only)
.SH Step Menu
.TP 8
.B Backward
Steps backward through a series of remembered moves.
The [<] button and the "b" key are equivalents.

In most modes, Backward only lets you look back at 
old positions; it does not retract moves.
This is the case if you are playing against GNU Chess, playing or
observing a game on the ICS, or loading a game.  If you select Backward in any
of these situations, you will not be allowed to make a different move.
Use Retract Move or Edit Game if you want to change past moves.

If you are examining a game on ICS, the behavior of
Backward depends on whether 
.BR xboard
is in Pause mode.
If Pause mode is off, Backward issues the ICS 
.IR backward
command, which
backs up everyone's view of the game and allows you to make a different move.
If Pause mode is on, Backward only backs up your local view.
.TP 8
.B Forward
Steps forward through a series of remembered moves (undoing the effect of
Backward) or forward through a game file.
The [>] button and the f key are equivalents.

If you are examining a game on ICS, the behavior of
Forward depends on whether 
.BR xboard
is in Pause mode.
If Pause mode is off, Forward issues the ICS 
.IR forward
command, which
moves everyone's view of the game forward along the current line.
If Pause mode is on, Forward only moves your local view forward, and it
will not go past the position that the game was in when you paused.
.TP 8
.B Back to Start
Jumps backward to the first remembered position in the game.
The [<<] button and the shifted "B" key are equivalents.

In most modes, Back to Start only lets you look back at 
old positions; it does not retract moves.
This is the case if you are playing against GNU chess, playing or
observing a game on the ICS, or loading a game.  If you select Back to
Start in any
of these situations, you will not be allowed to make different moves.
Use Retract Move or Edit Game if you want to change past moves; or
use Reset to start a new game.

If you are examining a game on ICS, the behavior of
Back to Start depends on whether 
.BR xboard
is in Pause mode.
If Pause mode is off, Back to Start issues the ICS 
.I backward 999999
command, which
backs up everyone's view of the game to the start and allows you to make
different moves.
If Pause mode is on, Back to Start only backs up your local view.
.TP 8
.B Forward to End
Jumps forward to the last remembered position in the game.
The [>>] button and the shifted "F" key are equivalents.

If you are examining a game on ICS, the behavior of
Forward to End depends on whether 
.BR xboard
is in Pause mode.
If Pause mode is off, Forward to End issues the ICS 
.I forward 999999
command, which moves everyone's view of the game forward to the end
of the current line.  
If Pause mode is on, Forward to End only moves your local view forward, and it
will not go past the position that the game was in when you paused.
.TP 8
.B Revert
If you are examining a game on ICS and Pause mode is off, 
issues the ICS command
.IR revert .
.TP 8
.B Truncate Game
Discards all remembered moves of the game beyond the current position.
Puts 
.BR xboard
into Edit Game mode if it was not there already.
.TP 8
.B Move Now
Forces GNU Chess to move immediately.  (GNU Chess mode only)
.TP 8
.B Retract Move
Retracts your last move.  
In GNU Chess mode, you can do this only after GNU Chess has replied to
your move; if GNU Chess is still thinking, use Move Now first.
In ICS mode, Retract Move issues the command 
.I takeback 1
or
.I takeback 2
depending on whether it is your opponent's move or yours.
.SH Options Menu
.TP 8
.B Always Queen
Toggles the alwaysPromoteToQueen option.
.TP 8
.B Auto Comment
Toggles the autoComment option.
.TP 8
.B Auto Flag
Toggles the autoCallFlag option.
.TP 8
.B Auto Observe
Toggles the autoObserve option.
.TP 8
.B Auto Save
Toggles the autoSaveGames option.  Disabled if the saveGameFile
option is set, as in that case all games are saved to the specified file.
.TP 8
.B Bell
Toggles the ringBellAfterMoves option.
.TP 8
.B Flip View
Inverts your view of the chess board for the duration of the current
game.  Starting a new game returns the board to normal.  

If you are
playing a game on the ICS, the board is always
oriented at the start of the game so that your 
pawns move from the bottom of the window towards the top.
Otherwise, the starting orientation is determined by the flipView command line
option; if it is False (the default), White's pawns move from bottom
to top at the start of each game; if it is True, Black's pawns move
from bottom to top.
.TP 8
.B Get Move List
Toggles the getMoveList option.  
When you turn this option on from the menu,
.BR xboard
immediately fetches the move list of the current game (if any).
.TP 8
.B Old Save Style
Toggles the oldSaveStyle option.
.TP 8
.B Quiet Play
Toggles the quietPlay option.
.TP 8
.B Show Coords
Toggles the showCoords option.
.TP 8
.B Show Thinking
Toggles the showThinking option.
.SH Help Menu
.TP 8
.B Hint
Displays a move hint from GNU Chess.  GNU Chess mode only.
.TP 8
.B Book
Displays a list of possible moves from GNU Chess's opening book.
The first column gives moves, the second column gives one possible response
for each move, and the third column shows the number of lines in the
book that include the move from the first column.  If you select this option
and nothing happens, GNU Chess is out of its book.  GNU Chess mode only.
.TP 8
.B About XBoard
Shows the current 
.BR xboard
version number.
.SH Other shortcut keys
.TP 8
.B Iconize
Pressing the i or c key iconizes
.BR xboard .
The graphical icon displays a white knight if it is White's move, or a
black knight if it is Black's move.  If your X window manager displays only
text icons, not graphical ones, check its documentation; there is probably a
way to enable graphical icons.  If you are running the Motif window manager 
.BR mwm (1),
add these lines to your \&.Xdefaults file and restart mwm:

.nf
    Mwm*iconDecoration: activelabel label image
    Mwm*XBoard*iconImageBackground: White
    Mwm*XBoard*iconImageForeground: Black
.fi

The first line above enables graphical icons in 
.BR mwm ;
you don't need it if you already have them.
The next two lines force the white knights to come out white and the black
knights black.  Unfortunately these resources can't be set from inside 
.BR xboard ;
you have to set them in your \&.Xdefaults.
.PP
You can add or remove
.BR xboard
shortcut keys
using the X resource 
.IR form.translations .
Here is an example of what would go in your \&.Xdefaults file:

.nf
    XBoard*form.translations: Shift<Key>?: AboutGameProc() \\n \\
	<Key>y: AcceptProc() \\n \\
	<Key>n: DeclineProc() \\n \\
	<Key>i: NothingProc()
.fi

Binding a key to NothingProc makes it do nothing, thus removing it as a
shortcut key.
The 
.BR xboard
functions that can be bound to keys are: 
AbortProc,
AboutGameProc,
AboutProc,
AcceptProc,
AdjournProc,
AlwaysQueenProc,
AutobsProc,
AutoflagProc,
AutosaveProc,
BackwardProc,
BellProc,
BookProc,
CallFlagProc,
DebugProc,
DeclineProc,
DrawProc,
EditCommentProc,
EditGameProc,
EditPositionProc,
EditTagsProc,
FlipViewProc,
ForwardProc,
GetMovesProc,
HintProc,
Iconify,
IcsClientProc,
LoadGameProc,
LoadNextGameProc,
LoadPositionProc,
LoadPrevGameProc,
MachineBlackProc,
MachineWhiteProc,
MailMoveProc,
MoveNowProc,
NothingProc,
OldSaveStyleProc,
PauseProc,
QuietPlayProc,
QuitProc,
ReloadCmailMsgProc,
ReloadGameProc,
ResetProc,
ResignProc,
RetractMoveProc,
RevertProc,
SaveGameProc,
SavePositionProc,
ShowCoordsProc,
ShowGameListProc,
ShowThinkingProc,
StopExaminingProc,
StopObservingProc,
ToEndProc,
ToStartProc,
TruncateGameProc, and
TwoMachinesProc.
.SH FIREWALLS
.PP
By default,
.B xboard -ics
communicates with an Internet Chess Server by opening a TCP socket
directly from the machine it is running on to the ICS.  If there is a 
firewall between your machine and the ICS, this won't work.  Here are some
recipes for getting around common kinds of firewalls using special options to
xboard.
Important: See the paragraph in the LIMITATIONS section below 
about extra echoes.

Suppose that you can't telnet directly to ICS, but you can telnet to a
firewall host, log in, and then telnet from there to ICS.  Let's say the
firewall is called fire.wall.com.  Set command-line options as
follows: 

.nf
    xboard -ics -icshost fire.wall.com -icsport 23
.fi

Or in your \&.Xdefaults file:

.nf
    XBoard*internetChessServerHost: fire.wall.com
    XBoard*internetChessServerPort: 23
.fi

Then when you run
.BR xboard
in ICS mode, you will be prompted to log in to the firewall host.
(This works because port 23 is the standard telnet login service.)
Log in, then telnet to ICS, using a command like 
.IR "telnet chess.lm.com 5000" ,
or whatever command the firewall provides for telnetting to port 5000.

If your firewall lets you telnet (or rlogin) to remote hosts, but doesn't let
you telnet to port 5000, you will have to find some other host outside the
firewall that does let you do this, and hop through it.  For instance, suppose
you have an account at foo.edu.  Follow the recipe above, but
instead of typing 
.I "telnet chess.lm.com 5000"
to the firewall, type 
.I "telnet foo.edu" 
(or 
.IR "rlogin foo.edu" ),
log in there, and
then type 
.IR "telnet chess.lm.com 5000" .

Exception: chess.lm.com itself lets you connect to the chess server on the
default telnet port (23), which is what you get if you don't specify a port
to the telnet program. But the other chess servers don't allow this.

Suppose that you can't telnet directly to ICS, but you can use rsh to run
programs on a firewall host, and that host can telnet to ICS.  Let's say the
firewall is called rsh.wall.com.  Set command-line options as
follows: 

.nf
    xboard -ics -gateway rsh.wall.com -icshost chess.lm.com
.fi

Or in your \&.Xdefaults file:

.nf
    XBoard*gateway: rsh.wall.com
    XBoard*internetChessServerHost: chess.lm.com
.fi

Then when you run
.BR xboard
in ICS mode, it will connect to the ICS by using rsh
to run the command 
.I "telnet chess.lm.com 5000" 
on host rsh.wall.com.

Suppose that you can telnet anywhere you want, but you have to run a special
program called 
.BR ptelnet
to do so.  

First, we'll consider the easy case, in
which 
.I "ptelnet chess.lm.com 5000"
gets you to the chess server.  
In this case set command line options as follows:

.nf
    xboard -ics -telnet -telnetProgram ptelnet
.fi

Or in your \&.Xdefaults file:

.nf
    XBoard*useTelnet: true
    XBoard*telnetProgram: ptelnet
.fi

Then when you run
.BR xboard
in ICS mode, it will issue the command 
.I "ptelnet chess.lm.com 5000"
to connect to the ICS.

Next, suppose that 
.I "ptelnet chess.lm.com 5000" 
doesn't work; that is, your ptelnet program
doesn't let you connect to alternative ports.  In this case,
you will have to find some other host outside the
firewall that does let you do this, and hop through it.  For instance, suppose
you have an account at foo.edu.  Set command line options as
follows:

.nf
    xboard -ics -telnet -telnetProgram ptelnet -icshost foo.edu -icsport ""
.fi

Or in your \&.Xdefaults file:

.nf
    XBoard*useTelnet: true
    XBoard*telnetProgram: ptelnet
    XBoard*internetChessServerHost: foo.edu
    XBoard*internetChessServerPort:
.fi

Then when you run
.BR xboard
in ICS mode, it will issue the command 
.I "ptelnet foo.edu"
to connect to your account at foo.edu.  Log in there, then type
.IR "telnet chess.lm.com 5000" .
.SH ENVIRONMENT
.PP
Game and position files
are found in the directory named by the CHESSDIR environment
variable.  If this variable is not set, the current working
directory is used.
If CHESSDIR is set,
.BR xboard
actually changes its working directory to $CHESSDIR, so GNU Chess listing
files will be stored there as well.
.SH SEE ALSO
.PP
.BR gnuchess (6),
.BR cmail (6).
.SH LIMITATIONS
.PP
There is no way for two people running copies of
.BR xboard
to play each other without going through the Internet Chess Server.  
.PP
Under some circumstances, your ICS password may be echoed when you log on.
.PP
If you are connecting to the ICS by running telnet on an Internet provider
or firewall host, you may find that each line you type is echoed back an extra
time after you hit Return.  If your Internet provider is a Unix system, you
can probably turn its echo off by typing 
.I "stty -echo"
after you log in, and/or
typing ^E-Return (control-E followed by the Return key) to the telnet
program after you have logged into ICS.  It is a good idea to do this if you
can, because otherwise the extra echo can occasionally confuse
.BR xboard 's
parsing routines.
.PP
The game parser recognizes only algebraic notation.
.PP
The internal move legality tester does not look at the game history,
so in some cases it misses illegal castling or en passant captures.
It permits castling with the king on the d file because this is possible in
some "wild 1" games on ICS.  It does not check
piece drops in bughouse to see if you actually
hold the piece you are trying to drop.
However, if you attempt an illegal move when using
GNU Chess (or the ICS), 
.BR xboard
will accept the error message that comes
back, undo the move, and let you try another.
.PP
FEN positions saved by 
.BR xboard
do not include correct information about whether castling or en passant
are legal.
.PP
The mate detector does not understand that non-contact mate is not really mate
in bughouse.  The only problem this causes while playing is minor: a
"#" (mate indicator) character will show up after a non-contact mating move in
the move list
.BR xboard 
will 
.I not
assume the game is over at that point.
.PP
Edit Game mode always uses non-bughouse rules.  Although you can load and edit
games that contain piece drops, the piece menus are not active, so
you cannot insert piece drops.  Also,
.BR xboard
thinks an edited game is over when a mating move is inserted, even if the mate
is non-contact.
.PP
The .icsrc file does not work properly when you 
connect to ICS through a Unix gateway host with useTelnet mode.
The Unix login process apparently discards type-ahead.
.PP
Some
.BR xboard
functions may not work with versions of GNU Chess earlier 
than 4.0, patchlevel 73. 
.SH AUTHORS AND CONTRIBUTORS
.PP
Tim Mann has been responsible for 
.BR xboard
versions 1.3 through 3.4, and for
.BR WinBoard ,
a port of
.BR xboard
to Microsoft Win32 (Windows NT and Windows 95).
Jochen Wiedmann ported
.BR xboard
to the Amiga, creating
.BR AmyBoard ,
and converted the documentation to texinfo.
Chris Sears and Dan Sears wrote the original 
.BR xboard ;
they were responsible for versions 1.0 through 1.2.
.PP
Elmar Bartel contributed the new piece bitmaps for version 3.2.
Evan Welsh wrote
.BR cmail.
John Chanak contributed the initial implementation of ICS mode.
The color scheme and the old 80x80 piece bitmaps were taken from
Wayne Christopher's 
.BR XChess
program.
.PP
Send bug reports to <bug-gnu-chess@prep.ai.mit.edu>.  Please use the
.BR script (1)
program to start a typescript, run
.BR xboard
with the debug option, and include the typescript output in your message.
Also tell us what kind of machine and what operating system version you are
using.  The command 
.I "uname -a"
will usually tell you this.
.SH COPYRIGHT
.PP
Copyright 1991 by Digital Equipment Corporation, Maynard, Massachusetts.
Enhancements Copyright 1992-95 Free Software Foundation, Inc.
.PP
XBoard's alternative piece bitmaps (bitmaps.xchess) are derived from the
bitmaps in the XChess program, which was written and is copyrighted by Wayne
Christopher. 
.PP
The following terms apply to Digital Equipment Corporation's copyright
interest in XBoard:
.PP
.RS
All Rights Reserved
.PP
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
.PP
DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
.RE
.PP
The following terms apply to this enhanced version of XBoard distributed
by the Free Software Foundation:
.PP
.RS
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
.PP
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
.RE
