/* s__.h		-*- C++ -*-
 *$Header: /al/acs/src/RCS/s__.h,v 9.25 95/10/29 01:46:22 al Exp $
 * base class for simulation methods
 */
#ifndef S___H
#define S___H
#include "md.h"
#include "u_prblst.h"
#include "e_base.h"
/*--------------------------------------------------------------------------*/
class CARD;
class CS;
enum worst_t
   {wNONE, wWORST, wSENS, wRAND, wMAXDC, wMINDC, wMAXAC, wMINAC, wLEAD, wLAG};
/*--------------------------------------------------------------------------*/
class SIM : public CKT_BASE {
friend class NODE;
friend class node_t;
public:
 static	double freq;		/* AC frequency to analyze at (Hertz) */
 static	COMPLEX jomega;		/* AC frequency to analyze at (radians) */
 static double time0;		/* time now */
 static double time1;		/* time at previous time step */
 static double dtmin;		/* min internal step size */
 static double temp;		/* ambient temperature */
 static double damp;		/* Newton-Raphson damping coefficient actual */
 static int uic;		/* flag: use initial conditions (spice-like) */
 static int bypass_ok;		/* flag: ok to bypass model evaluation */
 static int inc_mode;		/* flag: make incremental changes */
 static int fulldamp;		/* flag: big iter. jump. use full (min) damp */
 static int mode;		/* simulation type (AC, DC, ...) */
 static int phase;		/* phase of simulation (iter, init-dc,) */
 static int freezetime;		/* flag: don't advance stored time */
 static double genout;		/* tr dc input to circuit (generator) */
protected: 
 static double last_time;	/* time at which "volts" is valid */
 static worst_t worstcase;	/* worst case, etc. mode */
 static	int	*nm;		/* node map (external to internal)	*/
 static	double	*i;		/* dc-tran current (i) vector		*/
 static	double	*v0;		/* dc-tran voltage, new			*/
 static	double	*vi1;		/* dc-tran voltage, 1 iter ago		*/
 static	double	*vt1;		/* dc-tran voltage, 1 time ago		*/
 static	double	*fw;		/* dc-tran fwd sub intermediate values	*/
 static	double	*vdc;		/* saved dc voltages			*/
 static	COMPLEX	*ac;		/* ac right side			*/
 
public:
	int stepno;		/* count of visible (saved) steps */
	PROBELIST alarmlist;	/* list of alarm probes */
	PROBELIST plotlist;	/* list of plot probes */
	PROBELIST printlist;	/* list of print probes */
	PROBELIST storelist;	/* list of probes to store for postproc */

private:
 virtual void	setup(CS&) = 0;
 virtual void	sweep() = 0;
 virtual void	finish(){}

public:
 static	void	init();			/* s__init.cc */
 static	void	uninit();

protected:
	void	keep();			/* s__aux.cc */
  	void	command_base(CS&);	/* s__init.cc */
	void	reset_timers();	
 static	void	alloc_hold_vectors();
 static	void	determine_matrix_structure(const CARD*);
	void	alloc_vectors();
 static	void	unalloc_vectors();
 static	void	count_nodes();
 static	void	map_nodes();		/* s__map.cc */
 static void	order_reverse();
 static void	order_forward();
 static void	order_auto();
 static void	map_list(CARD*);
	void	restore();		/* s__out.cc */
	void	out(double);
	void	head(double,double,int,const char*);
	void	print(double);
	void	alarm();
virtual	void	store();
	int	solve(int,int);		/* s__solve.cc */
	void	advance_time(void);
	void	clear_arrays(void);
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
