/* d_subckt.h		-*- C++ -*-
 *$Header: /al/acs/src/RCS/d_subckt.h,v 9.21 95/10/21 18:10:44 al Exp $
 * data structures for subcircuits
 */
#ifndef D_SUBCKT_H
#define D_SUBCKT_H
#include "e_subckt.h"
/*--------------------------------------------------------------------------*/
#define UNUSED 0
#define USED -3
#define NODESPERSUBCKT 1000
#define PORTSPERSUBCKT 100

#define sDEFAULT_modelname	""
/*--------------------------------------------------------------------------*/
class DEV_SUBCKT : public BASE_SUBCKT {
public:
	DEV_SUBCKT();
	DEV_SUBCKT(const DEV_SUBCKT&);
	~DEV_SUBCKT(){--Count;}
	CARD*	clone()const{return new DEV_SUBCKT(*this);}
	void	parse(CS&);
 	void	print(int,int)const;
	double	probe_tr_num(const char*)const;
	void	expand();
static	int	count(){return Count;}
private:
  static int	Count;
};

struct subckt {
   generic_t	*x;
   size_t	ssize;
   const generic_t *m;
   char		modelname[LABELEN+1];
   node_t	n[PORTSPERSUBCKT+1];
};

class MODEL_SUBCKT : public COMPONENT {
public:
	MODEL_SUBCKT(const char *name = "");
	MODEL_SUBCKT(const MODEL_SUBCKT& p){assert(!"copy-model??");}
	CARD*	clone()const{return new MODEL_SUBCKT(*this);}
	void	parse(CS&);
 	void	print(int,int)const;
};

struct smod {
   generic_t	*x;
   size_t	ssize;
   const generic_t *m;
   char		modelname[LABELEN+1];
   node_t	n[PORTSPERSUBCKT+1];
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
