/* ap.h -*- C++ -*-
 *$Header: /al/acs/src/RCS/ap.h,v 9.21 95/10/21 18:10:26 al Exp $
 * stuff for the "ap" family of parsing functions
 */
#ifndef AP_H
#define AP_H
#include <ctype.h>
#include <math.h>
#include <string.h>
/*--------------------------------------------------------------------------*/
	int	pmatch(const char*,const char*);
	int	wmatch(const char*,const char*);
/*--------------------------------------------------------------------------*/
enum AP_MODE{
   ONEPASS,	/* NO */
   REPEAT	/* YES */
};
enum AP_TYPE{
   aDOUBLE,	/* double */
   aUDOUBLE,	/* double, force positive */
   aINT,	/* int */
   aUINT,	/* int, force positive */
   aENUM,	/* int, set to next param, do not read */
   aODOUBLE,	/* double with offset */
   a2DOUBLE,	/* 2 doubles */
   aORENUM,	/* int, or to next param, do not read */
   aANDENUM,	/* int, and to next param, do not read */
   aFUNCTION,	/* call function with params cmd,cnt */
   a2FUNCTION,	/* 2 functions, in sequence */
   aSDOUBLE,	/* double with scale */
   aFINT,	/* int, but take in double format */
   aIDOUBLE,	/* inverted double */
   aSIDOUBLE,	/* scaled, inverted double (scaled first) */
   aOIDOUBLE,	/* offset, inverted double (offset first) */
   aOCTAL,	/* int in octal */
   aHEX,	/* int in hex */
   aFFUNCTION,	/* call function with CS object */
   a2FFUNCTION	/* 2 functions, in sequence */
};

class CS {
private:
   const char *cmd;
   int  cnt;
public:
   CS(const char *c,int i=0){cmd=c;cnt=i;}
   int	    index()const{return cnt;}
   void	    reset(int c=0){cnt=c;}
   const    char* fullstring()const{return cmd;}
   const    char* tail()const{return &cmd[cnt];}
   int	    ctoc(){return cmd[cnt++];}
   void	    skip(int c=1){cnt+=c;}
   int	    peek()const{return cmd[cnt];}
   int	    match(char c)const{return (cmd[cnt]==c);}
   int	    match1(const char *c)const{return cmd[cnt]&&strchr(c,cmd[cnt]);}
   int	    more(){skipbl();return cmd[cnt];}
   int	    end(){skipbl();return !cmd[cnt];}
   int	    is_xdigit()const{return (match1("0123456789abcdefABCDEF"));}
   int	    is_digit()const{return (match1("0123456789"));}
   int	    is_pfloat()const{return (match1(".0123456789"));}
   int      is_float()const{return (match1("+-.0123456789"));}
   int	    is_alpha()const{return isalpha(toascii(cmd[cnt]));}
   int	    is_term(const char *t)
   	    {char c=peek();return (c=='\0' || isspace(c) || strchr(t,c));}
   int	    skipcom(){return skip1b(",=");}
   int	    skiplparen(){return skip1b("([");}
   int	    skiprparen(){return skip1b(")]");}
   int	    skipequal(){return skip1b("=");}
   double   ctopf(){return fabs(ctof());}
   void     warn(int i){warn(i,index());}
   double   ctof();				// ap_ctof.cc
   int	    ctoi();				// ap_ctoi.cc
   unsigned ctou();
   int	    ctoo();
   int	    ctox();
   char*    ctostr(char*,int,const char*);	// ap_ctos.cc
   void	    check(int);				// ap_error.cc
   void	    warn(int,int);
   int	    pmatch(const char*);		// ap_match.cc
   int	    argparse(AP_MODE,...);		// ap_parse.cc
   void	    skipbl();				// ap_skip.cc
   int	    skip1b(const char*);
   int	    skip1(const char*);
   void	    skiparg();
};	
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
