/* fft.c
 *$Header: /al/acs/src/RCS/m_fft.cc,v 9.25 95/10/29 01:45:17 al Exp $
 * fast fourier transform
 */
#include "md.h"
#include "constant.h"
#include "declare.h"	/* self */
/*--------------------------------------------------------------------------*/
	void	fft(COMPLEX*,int,int);
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
void fft(COMPLEX *x, int n, int inv)
{
  int s = (inv) ? 1 : -1;
  int nxp, nxp2;
  for (nxp=n;  (nxp2=nxp/2) > 0;  nxp=nxp2){
    double wpwr = kPIx2 / nxp;
    int m;
    for (m = 0;  m < nxp2;  m++){
      double argg = m * wpwr;
      COMPLEX w = COMPLEX(cos(argg), s*sin(argg));
      int j1;
      for (j1 = m;  j1+nxp-m <= n;  j1 += nxp){
	int j2 = j1 + nxp2;
	COMPLEX t = x[j1] - x[j2];
	x[j1] += x[j2];
	x[j2] = t * w;
      }
    }
  }
  /* unscramble */
  {
    int i, j, k;
    for (i = j = 0;  i < n-1;  i++, j += k){
      if (i < j){
	COMPLEX t = x[j];
	x[j] = x[i];
	x[i] = t;
      }
      for (k = n/2;  k <= j;  k /= 2)
	j -= k;
    }
  }
  /* fix level */
  {
    if (!inv){
      int nn = n;
      int i;
      for (i = 0;  i < nn;  i++){
	x[i] /= nn;
      }
    }
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
