/* e_compon.h		-*- C++ -*-
 *$Header: /al/acs/src/RCS/e_compon.h,v 9.21 95/10/21 18:10:57 al Exp $
 * branch structure type definitions
 * device types (enumeration type?)
 */
#ifndef E_COMPON_H
#define E_COMPON_H
#include "e_card.h"
/*--------------------------------------------------------------------------*/
class MODEL_BASE;
/*--------------------------------------------------------------------------*/
class COMPONENT_COMMON {
protected:
	COMPONENT_COMMON(){model=NULL;}
	COMPONENT_COMMON(const COMPONENT_COMMON& p){*this = p;}
protected:
  const MODEL_BASE* model;
};
/*--------------------------------------------------------------------------*/
class COMPONENT : public CARD {
protected:
	COMPONENT(){common=NULL;}
	COMPONENT(const COMPONENT& p):CARD(p){common=p.common;}
	void	     parselabel(CS&);
	int	     parsenodes(CS&,int);
	void	     printnodes(int,int)const;
protected:
  COMPONENT_COMMON* common;
public:
	double	dampdiff(double&, double&, int);
};
/*--------------------------------------------------------------------------*/
#define conchk(o,n,a)	((fabs((n)-(o))<=(a))\
	|| (fabs(o)>(a) && uporder(OPT::lowlim, (n)/(o), OPT::uplim)))
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
