   $t insert end {A bird?  A plane?  TkMan!  (TkPerson?)

 by Tom Phelps 

implemented in John Ousterhout's Tcl 7.5/Tk 4.1, icon drawn by Rei Shinozuka
 Compatible with Sun Solaris, SunOS, Hewlett-Packard HP-UX, OSF/1 aka Digital UNIX, DEC Ultrix, AT&T System V, SGI IRIX, Linux, SCO, IBM AIX, FreeBSD, BSDI -- each of which, believe you me, is in some way different from all the others 

Copyright (c) 1993-1996  Thomas A. Phelps
 All Rights Reserved.
 University of California, Berkeley
 Department of Electrical Engineering and Computer Science
 Computer Science Division 

The latest version of TkMan is always available by anonymous FTP at ftp.cs.Berkeley.EDU in the /ucb/people/phelps/tcltk directory. 

PERMISSION IS GRANTED TO DISTRIBUTE THIS SOFTWARE FREELY, WITH THE EXCEPTION THAT ONE MAY NOT CHARGE FOR IT OR INCLUDE IT WITH SOFTWARE WHICH IS SOLD. Walnut Creek, O'Reilly -- this means you too! 

Before reporting a bug, first check the home site to make sure you're using the latest version  of TkMan.  If you send me bug reports and/or suggestions for new features, include your MANPATH, the versions of TkMan, Tcl, Tk, X, and UNIX, your machine and X window manager names, the edited Makefile, a copy of your ~/.tkman file,  and the first few lines of the tkman executable.  Otherwise don't waste my time. 


Introduction

"I encourage you to use TkMan for reading man pages. ... TkMan provides an extremely pleasant GUI for browsing man pages.  I cannot describe all the nice features of TkMan in this small space.  Instead I will merely say that I now actually look forward to reading man pages as long as I can do it with TkMan."
 -- Don Libes, Exploring Expect, page 21 

A graphical manual page browser, TkMan offers two major advantages over man and xman: hypertext links to other man pages (click on a word in the text which corresponds to a man page, and you jump there), and better navigation within long man pages with searches (both incremental and regular expression) and jumps to section headers.  TkMan also offers some convenience features, like a user-configurable list of commonly used man pages, a one-click printout, and integration of whatis and apropos. Further, one may highlight, as if with a yellow marker, arbitrary passages of text in man pages and subsequently jump directly to these passages by selecting an identifying excerpt from a pulldown menu.  Finally, TkMan gives one control over the directory-to-menu volume mapping of man pages with a capability similar to but superior to xman's mandesc in that rather than forcing all who share a man directory to follow a single organization, TkMan gives control to the individual.  For instance,  or a Tcl/Tk programmer may decide to group Tcl/Tk manual pages in their own volume listing, or a nonprogrammer may decide he has no use for instance the programmer routines in volumes 2, 3, 4, 8--and eliminate them from his personal database. 

Other features include:
 * full text search of manual pages (with Glimpse; optional)
 * when multiple pages match the search name, a pulldown list of all matches
 * regular expression searches for manual page names
 * a list of recently added or changed manual pages
 * a "history" list of the most recently visited pages
 * a preferences panel to control fonts, colors, and other system settings
 * compatibility with compressed pages (both as source and formatted)
 * diagnostics on your manual page installation
 * elision of those unsightly page headers and footers
 * and, when attempting to print a page available only in formatted form, reverse compilation into [tn]roff source, which can then be reformatted as good-looking PostScript. 

This help page is shipped with the distribution in HTML form for easy printing. 


Using TkMan

Locating a man page

There are several ways to specify the manual page you desire.  You can type its name into the entry box at the top of the screen and press Return or click the man button.  The name may be just the name of the command or may end with .n or (n), where n specifies in which section to look.  Man pages are matched using regular expressions, so you can use . to match any single character, * to match any (zero or more) of the previous regular expression, [ .. ] to match any single character in the enclosed class; see egrep for more information.  For instance, .*mail.*.1 searches section 1 (user commands) for commands with "mail" anywhere in their names. Likewise, one can collect all the various manual pages relating to Perl 5 with perl.*, or see a list of all X window managers with .*wm. If you're running TkMan from a shell and giving it an initial man page name to load up as an argument, use this syntax (adequately quoted for protection from the shell), as opposed to the syntax of the standard man command (which is man section name--that is, the section number comes first, whereas in TkMan it is part of the name. 

Usually TkMan searches the colon-separated list of directories in your MANPATH environment variable for the man page, but you may instead provide a path name for the man page by beginning it with  `~', `/', `.' or `..'; this is the way to access a man page which isn't installed in a MANPATH man directory.  File completion is invoked with Escape. Further, other Tcl interpreters may display a man page in TkMan by sending a message to the function manShowMan with the name of the desired man page, e.g. send tkman manShowMan tcl.n.  If multiple man page names match the specification, the first match (as searched for in MANPATH order) is shown and a pulldown menu appears which contains a list of the other matches.  Return from reading help or a volume listing to the last man page seen with C-m when the focus is in the main text display area. 

apropos information is available by typing the name and clicking apropos or hitting Shift-Return.  The output of apropos is piped through sort and uniq to remove duplicates.  To pass the matches through additional filters, simply give the pipe as in a shell, e.g., `search | grep ^g' (each space character is significant) returns all the search-related commands which begin with the letter g. The results of the last apropos query are available under the Volumes menu. 

If it's installed, you will see a button for glimpse, a full text search program that requires only small index files ("typically 2-5% the size of the original text" but larger percentages for smaller amounts of text),  written by Udi Manber, Sun Wu, and Burra Gopal of the University of Arizona's Department of Computer Science.  In their performance measurements, "a search for Schwarzkopf allowing two misspelling errors in 5600 files occupying 77MB took 7 seconds on a SUN IPC".  For example, one may search for the string `WWW' anywhere in any manual page by typing in `WWW' in the entry line at the top of the screen and clicking on the glimpse button or typing Meta-Return. Escape and C-g can interrupt a search after the current directory is done. To employ glimpse's command line options, simply place them before the search pattern in the entry box, or add them to the default options by editing the man(glimpse) variable in your ~/.tkman startup file (see Customizing TkMan, below). For instance, to search for "perl" as a word and not part of another word (as in "properly"), glimpse for -w perl. Glimpse supports an AND operation denoted by the symbol `;' and an OR operation denoted by the symbol `,'. Refer to the glimpse manual page for more information. The regular expression used by glimpse automatically sets the intrapage search  expression.  For this reason, the case sensitivity of the glimpsing is set to the same as intrapage regular expression searching. A complete set of matches from the last full text search is available under the Volumes menu. 

The Paths pulldown gives you complete control over which directory hierarchies of your MANPATH are searched for man pages and apropos information.  TkMan does not support "modules" of commands and their man pages that are dynamically added to and removed from a user's environment; instead, create the database with all potential modules, and control visibility with Paths.  You can call up a listing of all man pages in a volume through the Volumes pulldown menu and then select one to view by clicking on its name. New `pseudo-volumes' can be added, and arbitrary directories may be added to or deleted from a volume listing using tkmandesc commands, described below. In a volume listing, typing a letter jumps to the line in the listing starting with that letter (capital and lower case letters are distinct).  Return to the last volume seen with C-d when the focus is in the main text display area. 

Whenever you have a man page name in the text display box, whether from apropos, a volume listing or a reference within another man page, you can click on it to hypertext-jump to it.  In point of fact, man pages do not explicitly code man page references, but words that are especially likely to be references are distinguished, though any word may be clicked on to treat it as a man page reference.  Pressing shift while clicking opens up a new viewer box to display the page. 

The last few man pages you looked at can be accessed directly through the History pulldown menu.  The list is sorted top to bottom in order of increasing time since that page was last visited. Shortcuts lists your personal favorites and is used just like History, with the additional options of adding the current man page (by clicking +) or removing it (-) from the list.  A shift-click on - removes all shortcuts. 

(Man pages specified as above are processed through an nroff filter. TkMan can also read raw text from a file or from a command pipeline, which can then be read, searched and highlighted same as a man page.  To read from a file, make the first character in the name a <, as in <~/foo.txt.  To open a pipe, make the first character a | (vertical bar), as in `|gzcat foo.txt.gz' or `|cat ../foo.txt | grep bar' (that's no space after the first |, a space before and after any subsequent ones). After reading a file in this way, the current directory is set to its directory. Commands are not processed by a shell, but the metacharacters ., .., ~ and $ (for environment variables), are expanded nonetheless.  Typing is eased further by file name completion, bound to Escape.  Lone files (i.e., not part of a pipe) are automatically uncompressed--no need to read compressed files through a zcat pipe.  It is not expected that reading raw text will be done much; it is included so the occasional non-man page documentation, say, a FAQ or RFC, may be read from the same environment.) 


Working within a man page

The full pathname of the current manual page is shown at the top of the screen.  Via the Preferences dialog, this can be changed to the whatis information for the page. (whatis information is built by catman.) 

To the extent it follows conventional formatting, a manual page is parsed to yield its section and subsection titles (which are directly available from the Sections pulldown) and references to other man pages from throughout the page including its SEE ALSO section (Links pulldown).   One may jump directly to a section within a man page or a referenced man page, respectively, by selecting the corresponding entry from one of these pulldowns. 

Within a man page or raw text file or pipe, you may add ad hoc highlighting, as though with a yellow marker (underlining on monochrome monitors).  Highlighted regions may then be scrolled to directly through the Highlights pulldown menu.  To highlight a region, select the desired text by clicking button 1, dragging to the far extent of the desired region and releasing the button, then click on the + next to Highlights.  To remove any highlights or portions thereof in a region, select it as before but then click on -.  A shift-click on the menu title tours through all the highlights on the page.  A shift-click on - removes all highlights on the page.  A complete set of pages with highlighting is available under the Volumes menu. 

Highlighting information is robust against changes to and reformatting of the page.  Thus you can justify expending some effort in marking up pages with the knowledge that if a man page does change, as when the corresponding software pagkage and its documentation are updated, TkMan will try to reposition them to the corresponding positions in the new pages. Here's how highlight reattachment works. When you highlight a region, the starting and ending positions are saved along with some the content of the highlighted region and context.   When that page is viewed again, if those positions still match the context, the highlight is attached there (this is an exact match).  If not, the context is searched forward and backward for a match, with the closer match chosen if there are matches in both directions (a repositioned match).   If no match is found with the full context, gradually less and less of it is tried,  reasoning that perhaps the content of the context has been changed (repositioned, but with less confidence, triggering a warning dialog). If still no match is found (an orphan), the highlight is reported at the bottom of the page, where it must be reattached manually before leaving the page or it will be forgotten.  (With TkMan v1.8b3 and earlier, highlights were attached by positions only, and when the page modification date changed, the user had the choice of applying  highlights at those same positions regardless of the text there now or throwing out the highlights wholesale.  Old style highlights are automatically updated to the new style that can be automatically and robustly repositioned.  The next time an old style page is viewed, the old style highlights are applied as before, and from those postions new style highlights are composed.)  The annotation reattachment mechanism is inspired by Stanford's ComMentor system. 

You can move about the man page by using the scrollbar or typing a number of key combinations familiar to Emacs aficionados.  Space and C-v page down; delete and M-v page up.  (vi fans will be happy to hear that C-f and C-b also page down and page up, respectively.) C-n and C-p scroll up and down, respectively, by a single line. M-< goes to the top and M-> to the bottom of the text.  One may "scan" the page, which is to say scroll it up and down with the mouse but without the use of the scrollbar, by dragging on the text display with the middle mouse button pressed.  Like Emacs, C-space will mark one's current location, which can be returned to later with C-x, which exchanges the then-current position with the saved mark; a second C-x swaps back. 

C-s initiates an incremental search.  Subsequently typing a few letters attempts to find a line with that string, starting its search at the current match, if any, or otherwise the topmost visible line.   A second C-s finds the next match of the string typed so far.  (If the current search string is empty, a second C-s retrieves the previous search pattern.) C-r is similar to C-s but searches backwards. Escape or C-g cancels searching. Incremental search can be used to quickly locate a particular command-line option or a particular command in a group (as in csh's long list of internal commands). At the bottom of the screen, type in a regular expression to search for (see Tcl's regexp command), and hit return or click Search to begin a search.  Hit C-s, click the down arrow or keep hitting return to search for the next occurance; likewise C-r or the up arrow for previous occurances. 

The Tab key moves the focus from the man page type-in line to the text view of the man page to the search line and back around.  Shift-Tab jumps about in the opposite direction. 


Other commands

The Occasionals menu holds commands and options which you probably won't use frequently.  Help returns to this information screen.  Although virtually made obsolete by TkMan, Kill Trees makes a printout of the current man page on dead, cut, bleached trees, helping to starve the planet of life-giving oxygen.  A list of printers appears in the cascade menu; this list may be edited in Preferences/Misc.  (Even if only one printer is available, it placed in the cascade menu, rather than being directly available.  This is a feature.) (If the [tn]roff source is not available, TkMan asks if it should try to reverse compile the man page.  If successful, this produces much more appealing output than an ASCII dump.)  By default, incremental searching is not case sensitive, but regular expression searching is; these settings can be toggled with the next two menus.  iff upper means that searching is case sensitive if and only if there is at least one uppercase letter in the search expression--that is, all-lowercase searches are not case sensitive; this idea is taken from Emacs. With proportional fonts giving a ragged right margin, any change bars in the right margin will form an uneven line; by opting for Changebars on left, they will form a straight line at the left margin. 

As with xman one may instantiate multiple viewers.  When there is more than one viewer you may choose man pages in one viewer and have their contents shown in another.  Use the Output pulldown (which appears and disappears as relevant) to direct one viewer's output destination to another.  With this feature one may easily compare two similar man pages for differences, keep one man page always visible, or examine several man pages from a particular volume listing or a SEE ALSO section.  Output only affects the display destination of man pages. 

TkMan uses a database of all manual page names in searching for a match for a particular name.  This database is constructed automatically if it doesn't exist (this includes the first time TkMan is run for a particular user) and whenever it is out of date due to pages being added or changed, or changes in one's MANPATH or tkmandesc commands.  (If you want to add paths to your MANPATH or edit ~/.tkman, you will have to restart to see any changes take effect, however.)  If you install new manual pages or otherwise change the contents of man page directories after TkMan as been started, invoking Rebuild Database will permit them to show up in the next search or volume listing without the bother of quitting and re-executing TkMan.  Rebuild Glimpse Database creates and then maintains the index that is used for full text searches.  The Glimpse database is not updated automatically due to the large amount of time it may take. 

When exited via the Quit button, TkMan saves its state.  One may guard against losing highlighting, shortcuts and other would-be persistent information without quitting by by invoking Checkpoint state to .tkman; Quit, don't update performs the opposite operation. 

At the bottom right corner of the screen, Mono toggles between the proportionally-spaced font and a monospaced one, for use in those man pages that rely on a fixed-width font to align columns.  Quit exits TkMan, of course, after saving some state information (see below).  To exit without saving status information, select the Quit option from the Occasionals pulldown. 


Preferences

The Preferences... choice in the Occasionals pulldown menu brings up a graphical user interface to setting various attributes of TkMan, including fonts, colors, and icons.  Click on a checkbutton at the top of the window to bring up the corresponding group of choices.  After making a set of choices, the Apply button reconfigures the running application to show these changes, OK sets the changes for use now and in the future, Cancel quits the dialog and sets all choices to their settings as of the time Preferences was called up, and Defaults resets the settings in the current group to those set by TkMan out of the box. 

The first line in the Fonts group specifies the font to use for the general user interface, which amounts to the labels on buttons and the text in menus.  The first menu in the line labeled Interface sets the font family, the next menu sets the font size, and the last the font styling (normal, bold, italics, bold-italics). Text display makes these settings for the text box in which the manual page contents are displayed.  For listings of all man pages in a particular volume (as chosen with the Volumes menu), you may wish to use a smaller font so that more names fit on the screen at once. Screen DPI specifies the right set of fonts to use for your monitor. 

Colors sets the foreground and background colors to use for the manual page text display box, the general user interface, and the buttons of the user interface.  In addition it sets the color (or font) in which to show various classes of text in the text box, including manual page references, incremental search hits, regular expression search hits, and highlighted regions. 

The See group specifies what information to display. Usually manual page headers and footers are uninteresting and therefore are stripped out, but a canonical header and footer (along the date the page was installed in the man/mann directory or formatted to the man/catn directory) to be shown at the bottom of every page can be requested.  Solaris and IRIX systems come with many "subvolumes"--that is volumes with names like "3x" and "4dm" that form subgroupings under the main volumes "3" and "4", respectively--and you make use tkmandesc commands to add your own subvolumes.  You can reduce the length of the main Volumes menu by placing all volumes in such groups as cascaded menus. When a highlighted passage is jumped to via the Highlights menu, some number of lines of back context are included; the exact number of lines is configurable.   The information bar at the top of the window can display either the short, one-line description from a manual page's NAME section or the pathname of the page.   Around the man page display area runs a buffer region of a few pixels, the exact width of  which is configurable. Tk deviates from Motif behavior slightly, as for instance in highlighting buttons when they're under the cursor, but you can observe strict Motif behavior. 

The Icon group sets all the options relating to iconification. The pathnames of the icon bitmap and icon mask should be the full pathnames (beginning with a `/').  If Path name to icon bitmap is set to (default), the internal icon by Rei Shinozuka will be used. 

If a man page has not been formatted by nroff, TkMan must first pipe the source text through nroff.  By turing on Cache formatted (nroff'ed) pages in the Misc(ellaneous) group, the nroff-formatted text is saved to disk (if possible), thereby eliminating this time-consuming step the next time the man page is read.  The on & compress setting will compress the page, which saves on disk space (often substantially as much of a formatted page is whitespace), but will make it unavailable to other manual pagers that don't handle compression.   

By default, man page links are activated by single clicking.  If it is changed to double with Mouse click to activate hyperlink, the first click puts the name in the entry box so that it can be used as the apropos or glimpse pattern as well as for man searching.  This click once to select, twice to launch follows the Macintosh convention. 

TkMan can extract section headers from all manual pages, but only some manual page macros format subsection headers in a way that can be distinguished from ordinary text; if your macros do, turn this option on to add subsections to the Sections menu. The History pulldown must balance depth of the list against ease of finding an entry; set your own inflection point with this menu.  Volumes' (recent) choice will show all manual pages that have been added or changed n days, where n is set with this next menu.   

Glimpse works best when searching for relatively uncommon words; guard against getting too many hits by setting the maximum number reported. By default Glimpse indexes are placed at the root of the corresponding man hierarchy, where they can be shared.  For the case when an individual may not have write permission there, a single, unified index can be created and stored locally (though you lose control of it from Paths settings). Unified indexes are faster than distributed.  On the other hand, rebuilding the index generally takes longer, since the distributed version will only have to rebuild the indexes for those directories that changed. For unified indexes and also for "stray cats" (i.e., directories not part of a set of man hierarchy directories), you should specify an auxiliary directory to hold the index. 


Customizing TkMan

There are four levels of configuration. 

(1) Transparent.  Simply use TkMan and it will remember your window size and placement, short cuts, and highlights (if you quit out of TkMan via the Quit button). 

(2) Preferences editor (see Preferences above). 

(3) Configuration file.  Most interesting settings--those  in the Preferences dialogs and more not available there--can be changed by editing one's own ~/.tkman file.  Thus, a single copy of TkMan (i.e., the executable tkman) can be shared, but each user can have his own customized setup.  (The file ~/.tkman is created/rewritten every time one quits TkMan via the Quit button in the lower right corner.  Therefore, to get a ~/.tkman to edit, first run and quit TkMan.  Do not create one from scratch as it will not have the proper format used for saving other persistent information, and your work will be overwritten, which is to say lost.  As well, be careful not to edit a ~/.tkman file only to have it overwritten when a currently running TkMan quits.) 

Options that match the defaults are commented out (i.e., preceded by a #).  This is so that any changes in TkMan defaults will propagate nicely to end users, while maintaining a list of all interesting variables. To override the default settings for these options, first comment in the line. 

The ~/.tkman save file is the place to add or delete colors to the default set, which will subsequently become menu choices in Preferences, by editing in place the variable man(colors).  One may also edit the order of Shortcuts in the man(shortcuts) variable. Other interesting variables include man(highlight), which can be edited to change the background in place of the foreground, or both the foreground and background, or a color and the font as with the following setting:
set man(highlight) {bold-italics -background #ffd8ffffb332} 

Arbitrary Tcl commands, including tkmandesc commands (described below), can be appended to ~/.tkman (after the ### your additions go below line). 

To set absolutely the volume names for which all directories should be searched, edit the parallel arrays on these existing lines:
set man(manList) ...
set man(manTitleList) ...
 Changing the order volumes in these lists (make sure to keep the two lists in parallel correspondence) changes the precedence of matches when two or more pages have the same name: the page found in the earlier volume in this list is show first. 

Additional useful commands include wm(n), which deals with the window manager; bind(n), which changes keyboard and mouse bindings not related to the text display window; options, which sets the X defaults; and text(n), which describes the text widget. 

(4) Source code.  Of course, but if you make generally useful changes or have suggestions for some, please report them back to me so I may share the wealth with the next release. 


Command line options

 The environment variable named TKMAN, if it exists, is used to set command line options.  Any options specified explicitly (as from a shell or in a script) override the settings in TKMAN. Any settings made with command-line options apply for the current execution only. Many of these options can be set persistently via the Preferences dialog (under the Occasionals menu). 

-title title 
      Place title in the window's title bar. 

-geometry geometry 
      Specify the geometry for this invocation only.  To assign a persistent geometry, start up TkMan, size and place the window as desired, then (this is important) quit via the Quit button in the lower right corner. 

-iconify and -noiconify 
      Start up iconified or uniconified (the default), respectively. 

-iconname name 
      Use name in place of the uniconified window's title for the icon name. 

-iconbitmap bitmap-path and -iconmask bitmap-path 
      Specify the icon bitmap and its mask. 

-iconposition (+|-)x(+|-)y 
      Place the icon at the given position; -iconposition "" "" cancels any such hints to the window manager. 

-debug or -nodebug 
      Generate (or not) debugging information. 

-startup filename 
      Use filename in place of ~/.tkman as the startup file; "" indictates no startup file. 

-database filename 
      Use filename in place of ~/.tkmandatabase as the name of the file in which to create the database of man page names.  This can point to a shared file to save disk space or share a custom design, or to an OS-specific file for systems with multiple machine architectures that share home directories. 

-rebuildandquit 
      Simply rebuild the database and quit.  This option may be useful in a cron script. 

-quit save and -quit nosave 
      Specify that the startup file (usually ~/.tkman) should be updated (save) or not (nosave) when quitting by the Quit button. 

-v 
      Show the current version of TkMan and exit immediately thereafter. 

-M path-list
 or -M+ path-list
 or -+M path-list 
      As with man, change the search path for manual pages to the given colon-separated list of directory subtrees.  -M+ appends and -+M prepends these directories to the current list. 

-now 
      Start up TkMan without checking to see if the database is out of date. 

--help Display a list of options. 
       


Key bindings

Key bindings related to the text display box are kept in the sb array in ~/.tkman (for more information on Tcl's arrays, refer to the array(n) man page.  In editing the sb(key,...) keyboard bindings, modifiers MUST be listed in the following order: M (for meta), C (control), A (alt).  DO NOT USE SHIFT.  It is not a general modifier: Some keyboards require shift for different characters, resulting in incompatibilities in bindings.  For instance, set sb(key,M-less) pagestart is a valid binding on keyboards worldwide, whereas set sb(key,MS-less) is not.  For this reason, the status of the shift key is supressed in matching for bindings.  To make a binding without a modifier key, precede the character by `-', as in set sb(key,-space) pagedown. 


tkmandesc

Like xman, TkMan gives you directory-by-directory control over named volume contents.  Unlike and superior to xman, however, each individual user controls directory-to-volume placement, rather than facing a single specification for each directory tree that must be observed by all. 

By default a matrix is created by taking the product of directories in the MANPATH crossed with volume names, with the yield of each volume containing all the corresponding subdirectories in the MANPATH.  By adding Tcl commands to your ~/.tkman (see above), you may add new volume names and add, move, copy and delete directories to/from/among directories. 

The interface to this functionality takes the form of Tcl commands, so you may need to learn at least pidgin Tcl--particularly the commands that deal with Tcl lists  (including lappend(n), linsert(n), lrange(n), lreplace(n)) and string matching (string(n), match subcommand)--to use this facility to its fullest.  tkmandesc commands are used to handle the nonstandard format of SGI's manual page directories, and the irix_bindings.tcl in the contrib directory is a good source of examples in the use of tkmandesc commands. 

Directory titles and abbrevations are kept in lists.  Abbreviations MUST be unique (capital letters are distinct from lower case), but need not correspond to actual directories.  In fact, volume letters specified here supercede the defaults in identifying a volume in man page searches. 


COMMANDS

The following commands are appended to the file ~/.tkman (see Customizing TkMan, above). 

To recreate a cross product of current section lists:
manDescDefaults
 This cross product is made implicitly before other tkmandesc commands. Almost always this is what one expects.  If it is not, one may supress the cross product by setting the variable manx(defaults) to a non-null, non-zero value before other tkmandesc commands are invoked. 

To add "pseudo" sections to the current volume name list, at various positions including at end of the list, in alphabetical order, or before or after a specific volume:
manDescAddSects list of (letter, title pairs)
 or manDescAddSects list of (letter, title) pairs sort
 or manDescAddSects list of (letter, title) pairs before sect-letter
 or manDescAddSects list of (letter, title) pairs after sect-letter
 In manual page searches that produce multiple matches, the page found in the earlier volume is the one shown by default. 

To move/copy/delete/add directories:
manDescMove from-list to-list dir-patterns-list
manDescCopy from-list to-list dir-patterns-list
manDescDelete from-list dir-patterns-list
manDescAdd to-list dir-list 

The dir-patterns-list uses the same meta characters as man page searching (see above).  It is matched against MANPATH directories with volume subdirectory appended, as in /usr/man/man3, where /usr/man is a component of the MANPATH and man3 is a volume subdirectory. from-list and to-list are Tcl lists of the unique volume abbreviations (like 1 or 3X); * is an abbreviation for all volumes. 

Adding directories with manDescAdd also makes them available to Glimpse for its indexing. 

Warning: Moving directories from their natural home slightly impairs searching speed when following a reference within a man page.  For instance, say you've moved man pages for X Windows subroutines from their natural home in volume 3 to their own volume called `X'.  Following a reference in XButtonEvent to XAnyEvent(3X11) first searches volume 3; not finding it, TkMan searches all volumes and finally finds it in volume X.  With no hint to look in volume 3 (as given by the 3X11 suffix), the full volume search would have begun straight away.  (Had you clicked in the volume listing for volume X or specified the man page as XButtonEvent.X, volume X would have been searched first, successfully.) 

To help debug tkmandesc scripts, invoke manDescShow to dump to stdout the current correspondence of directories to volumes names. 


EXAMPLES

(1) To collect together all man pages in default volumes 2 and 3 in all directories into a volume called "Programmer Subroutines", add these lines to the tail of ~/.tkman:
manDescAddSects {{p "Programmer Subroutines"}}
manDescMove {2 3} p * 

To place the new section at the same position in the volume pulldown list as volumes 2 and 3:
manDescAddSects {{p "Programmer Subroutines"}} after 2
manDescMove {2 3} p * 

To move only a selected set of directories:
manDescAddSects {{p "Programmer Subroutines"}}
manDescMove * p {/usr/man/man2 /usr/local/man/man3} 

(2) To have a separate volume with all of your and a friend's personal man pages, keeping a duplicate in their default locations:
manDescAddSects {{t "Man Pages de Tom"} {b "Betty Page(s)"}}
manDescCopy *phelps* t *
manDescCopy *page* t * 

(3) To collect the X windows man pages into two sections of their own, one for programmer subroutines and another for the others:
manDescAddSects {{x "X Windows"}} after 1
manDescAddSects {{X "X Subroutines"}} after 3
manDescMove * x *X11*
manDescMove x X *3 

(4) If you never use the programmer subroutines, why not save time and memory by not reading them into the database?
manDescDelete * {*[2348]} (braces prevent Tcl from trying to execute [2348] as a command) 

Alternatively but not equivalently:
manDescDelete {2 3 4 8} * 


tkmandesc vs. xman and SGI

TkMan's tkmandesc capability is patterned after xman's mandesc files.  By placing a mandesc file at the root of a man page directory tree, one may create pseudo volumes and move and copy subdirectories into them.  Silicon Graphics has modified xman so that simply by creating a subdirectory in a regular man subdirectory one creates a new volume.  This is evil.  It violates the individual user's rights to arrange the directory-volume mapping as he pleases, as the mandesc file or subdirectory that spontaneously creates a volume is must be observed by all who read that directory.  By contrast, TkMan places the directory-to-volume mapping control in an individual's own ~/.tkman file. This gives the individual complete control and inflicts no pogrom on others who share man page directories.  Therefore, mandesc files are not supported in any way by TkMan. 

One may still share custom setups, however, by sharing the relevant lines of ~/.tkman.  In fact, a tkmandesc version of the standard SGI man page directory setup is included in the contrib directory of the TkMan distribution.  For assistance with SGI-specific directory manipulation, contact Paul Raines (raines@slac.stanford.edu). 


Platform-specific Support

I estimate that fully 75% of my time writing TkMan has been spent not in adding new features but in supporting all the many, seemingly gratuitous differences in the various flavors of UNIX.  Amazingly, each is different from every other.  TkMan confronts variations in man page organization, that is, directory structure.  The same percentage holds for RosettaMan, which deals with variations in the formatting of the pages themselves, things like what character sequence indicates italics and what do page headers and footers look like.  The result of all this work is that you can do a simple installation of TkMan and it will embrace the specifics of your system's manual page installation. 

Here's the classical organization.  The MANPATH environment variable gives a colon-separated list of directory paths, each of which usually but not necessarily ends in a subdirectory named `man'. In each of these directories, the file `whatis' has a line per man page giving its name and a single line description taken from each page's NAME section.  Subdirectories named man[1-9oln] hold the [tn]roff source, and corresponding subdirectories named cat[1-9oln] cache formatted pages.  Within subdirectories, each page given as name.section-number, for example "ls.1".  The page source should always be available; formatted versions are purely optional, and strictly used as a performance enhancement, saving formatting time at runtime.  (Pages that exist in formatted versions only are known as "stray cats".)  Man pages may be compressed, with the type of compression given by a suffix on the file.  Compression can be particularly successful on formatted pages, which contain long strings of spaces. 

Here are all the ways that I can recall that various flavors of UNIX have "improved" the classical organization.  Each is supported by TkMan.  Clearly TkMan can do all that it does without reliance on any extension beyond the classical organization, so how important were these extensions? 

SunOS 
   + Just great! 

Solaris 
   + Renaming of `whatis' to `windex', which has an extra field 
   + Nonstandard directory names, e.g., `man1s'. 

Ultrix 
   + Just great (nonstandard tabs in formatted man pages handled by RosettaMan). 

OSF/1 aka Digital UNIX 
   + Just great ("missing" headers and footers in formatted pages handled by RosettaMan). 

HP/UX 
   + Compressed page files listed without .Z, which is on its enclosing directory 
   + Concatenates all whatis information into /usr/lib/whatis 

SCO 
   + /etc/default/man configuration file 

FreeBSD 

Linux 
   + /etc/man.config configuration file 
   + FSSTND 

BSDI 
   + Concatenation of all `whatis' files into a single /usr/share/man/whatis.db 
   + Formatted pages given suffix ".0" 
   + /etc/man.conf configuration file 

IBM AIX 
   + Have to convert help files from opaque InfoExplorer format to standard /usr/man format. 
   + Have to prevent man pages from being parsed, since they are just simple ASCII files,  only vaguely resembling man pages 

SGI Irix - absolute worst by far 
   + Only pre-formatted pages in /usr/catman 
   + Consequently, doesn't have [tn]roff 
   + Man sub-subdirectories magically appear as own volumes, with names hidden in their hacked version of xman 
   + Stray cats by default (installs formatted pages only) 
   + Page files named without section but with .z 


RosettaMan

TkMan uses RosettaMan to translate and reformat man pages (see man(5)). RosettaMan (called rman in its executable form)  takes man pages from most of the popular flavors of UNIX and transforms them into any of a number of text source formats.  Since its inception RosettaMan accepted formatted pages, and now with version 3.0 interprets [tn]roff source for superior translations. RosettaMan accepts man pages from SunOS, Sun Solaris, Hewlett-Packard HP-UX, AT&T System V, OSF/1 aka Digital UNIX, DEC Ultrix, SGI IRIX, Linux, FreeBSD, SCO.  It can produce ASCII-only, section headers-only, TkMan, [tn]roff (source), Ensemble, SGML, HTML, MIME, LaTeX, LaTeX2e, RTF, Perl 5 POD.   A modular architecture permits easy addition of additional output formats.  The latest version of RosettaMan is available from  ftp://ftp.cs.berkeley.edu/ucb/people/phelps/tcltk/rman.tar.Z. 


Author

Tom Phelps
 developed at the
 University of California, Berkeley
 Computer Science Division 

phelps@ACM.org 


More Information

 My article "TkMan: A Man Born Again" appears in The X Resource, issue 10, pages 33--46.  Here are the section titles: Introduction, Availability, The User Interface, Navigating among Man Pages, Inspecting Individual Man Pages, Customization, Logical Volumes with tkmandesc, Persistency, The RosettaMan Filter, Extensions, Problems, Future Work, Acknowledgements, Bibliography. 

Two Years with TkMan, a retrospective paper that uses TkMan as an example for various techniques for writing faster and more robust Tcl/Tk programs, was named Best Paper of the 1995 Tcl/Tk Workshop. 

A Berkeley Computer Science Division technical report (CSD-94-802) that is a version of the X Resource article before it was butchered by the editors and the latter paper are available from my World Wide Web page at http://http.cs.berkeley.edu/~phelps/. 


License

TkMan
 Copyright (C) 1993-1996  Thomas A. Phelps  (phelps@ACM.org)
 All Rights Reserved. 

PERMISSION IS GRANTED TO DISTRIBUTE THIS SOFTWARE FREELY, WITH THE EXCEPTION THAT ONE MAY NOT CHARGE FOR IT OR INCLUDE IT WITH SOFTWARE WHICH IS SOLD.  Permission to use, copy, modify, and distribute this software and its documentation for educational, research, internal corporate and non-profit purposes, without fee, and without a written agreement is hereby granted for all cases that do not conflict with the restriction in the first sentence of this paragraph, provided that the above copyright notice, this paragraph, and the following three paragraphs appear in all copies. 

Permission to incorporate this software into commercial products may  be obtained from the Office of Technology Licensing, 2150 Shattuck  Avenue, Suite 510, Berkeley, CA  94704.  

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS. 

Help page last revised on $Date: 1996/11/07 23:11:49 $
}
foreach qq {{h1 1.0 1.38} {sc 14.61 14.64} {tt 14.68 14.87} {tt 14.95 14.119} {sc 16.0 16.150} {tt 18.315 18.323} {tt 18.362 18.367} {h1 21.0 21.12} {i 24.15 24.31} {manref 26.72 26.75} {manref 26.80 26.84} {manref 26.479 26.485} {manref 26.490 26.497} {tt 26.836 26.840} {h1 43.0 43.11} {h2 45.0 45.19} {tt 47.139 47.145} {tt 47.159 47.162} {tt 47.233 47.234} {i 47.234 47.235} {tt 47.239 47.240} {i 47.240 47.241} {tt 47.241 47.242} {i 47.250 47.251} {tt 47.353 47.354} {tt 47.386 47.387} {tt 47.452 47.453} {tt 47.457 47.458} {manref 47.516 47.521} {manref 47.559 47.569} {manref 47.734 47.740} {manref 47.786 47.790} {tt 47.1003 47.1006} {tt 47.1025 47.1028} {i 47.1029 47.1036} {i 47.1037 47.1041} {sc 49.71 49.78} {tt 49.197 49.200} {tt 49.202 49.205} {tt 49.207 49.210} {tt 49.214 49.218} {sc 49.284 49.291} {tt 49.340 49.346} {manref 49.363 49.366} {tt 49.415 49.419} {tt 49.449 49.459} {tt 49.504 49.531} {sc 49.622 49.629} {tt 49.795 49.798} {tt 51.0 51.7} {tt 51.65 51.72} {tt 51.113 51.120} {tt 51.138 51.142} {tt 51.147 51.151} {tt 51.266 51.282} {tt 51.390 51.391} {tt 51.455 51.462} {tt 53.45 53.52} {tt 53.643 53.650} {tt 53.668 53.679} {tt 53.681 53.687} {tt 53.692 53.695} {tt 53.766 53.773} {tt 53.910 53.922} {tt 53.940 53.948} {tt 53.1100 53.1107} {tt 53.1129 53.1132} {tt 53.1165 53.1168} {tt 53.1176 53.1178} {tt 53.1211 53.1214} {manref 53.1229 53.1236} {tt 53.1302 53.1309} {tt 53.1561 53.1568} {tt 55.4 55.9} {sc 55.87 55.94} {tt 55.367 55.372} {tt 55.442 55.449} {tt 55.850 55.853} {tt 59.74 59.81} {tt 59.193 59.202} {tt 59.255 59.262} {tt 59.336 59.337} {tt 59.355 59.356} {tt 59.391 59.392} {tt 61.55 61.60} {tt 61.268 61.269} {tt 61.277 61.287} {tt 61.333 61.334} {tt 61.358 61.375} {tt 61.381 61.407} {tt 61.442 61.443} {tt 61.635 61.636} {tt 61.638 61.640} {tt 61.642 61.643} {tt 61.648 61.649} {tt 61.764 61.770} {tt 61.886 61.890} {h2 64.0 64.25} {manref 66.136 66.142} {manref 66.201 66.207} {tt 68.156 68.164} {sc 68.248 68.256} {tt 68.266 68.271} {tt 70.212 70.222} {tt 70.401 70.402} {tt 70.411 70.421} {tt 70.520 70.521} {tt 70.620 70.621} {tt 70.724 70.731} {tt 74.136 74.139} {tt 74.162 74.165} {tt 74.177 74.179} {tt 74.212 74.215} {tt 74.220 74.223} {tt 74.267 74.270} {tt 74.275 74.278} {tt 74.331 74.334} {tt 74.355 74.358} {tt 74.586 74.593} {tt 74.664 74.667} {tt 74.741 74.744} {tt 76.0 76.3} {tt 76.214 76.217} {tt 76.317 76.320} {tt 76.361 76.364} {tt 76.379 76.382} {tt 76.407 76.413} {tt 76.417 76.420} {tt 76.564 76.567} {manref 76.686 76.692} {tt 76.727 76.733} {tt 76.758 76.761} {tt 76.850 76.853} {tt 78.4 78.7} {tt 78.129 78.138} {h2 81.0 81.14} {tt 83.4 83.15} {tt 83.90 83.94} {tt 83.175 83.185} {tt 83.542 83.550} {sc 83.702 83.707} {tt 83.866 83.875} {tt 83.1212 83.1230} {tt 85.8 85.12} {tt 85.177 85.183} {sc 85.472 85.480} {tt 85.491 85.497} {sc 87.313 87.320} {sc 87.379 87.386} {tt 87.395 87.403} {tt 87.600 87.616} {tt 87.738 87.762} {tt 89.20 89.24} {tt 89.184 89.210} {tt 89.212 89.230} {tt 91.42 91.46} {tt 91.194 91.198} {tt 91.327 91.331} {tt 91.348 91.359} {h2 94.0 94.11} {tt 96.4 96.18} {tt 96.33 96.44} {tt 96.305 96.310} {tt 96.378 96.380} {tt 96.429 96.435} {tt 96.538 96.546} {tt 98.190 98.199} {tt 98.325 98.337} {tt 98.499 98.506} {tt 98.595 98.605} {tt 102.223 102.230} {i 102.230 102.231} {tt 102.262 102.269} {i 102.269 102.270} {tt 102.618 102.625} {tt 102.736 102.746} {tt 104.167 104.191} {tt 104.202 104.211} {tt 106.40 106.45} {tt 106.93 106.98} {tt 106.114 106.146} {tt 106.181 106.186} {tt 106.320 106.333} {tt 108.94 108.127} {i 110.97 110.100} {tt 110.236 110.244} {tt 110.255 110.262} {tt 110.384 110.392} {tt 110.393 110.401} {i 110.468 110.469} {i 110.482 110.483} {h1 115.0 115.17} {tt 119.149 119.153} {tt 123.152 123.160} {tt 123.219 123.224} {tt 123.301 123.309} {tt 123.366 123.370} {tt 123.426 123.434} {tt 123.678 123.686} {tt 125.71 125.72} {tt 127.4 127.12} {b 127.143 127.159} {tt 127.173 127.184} {tt 127.235 127.249} {tt 127.296 127.310} {i 127.408 127.411} {i 127.435 127.438} {tt 128.0 128.59} {tt 130.91 130.99} {tt 130.111 130.138} {b 132.81 132.85} {b 132.115 132.123} {tt 133.0 133.20} {tt 134.0 134.25} {manref 137.35 137.40} {manref 137.79 137.86} {manref 137.170 137.177} {manref 137.210 137.217} {h2 142.0 142.20} {sc 144.32 144.37} {sc 144.182 144.187} {tt 144.355 144.366} {tt 146.0 146.7} {i 146.7 146.12} {tt 147.12 147.12} {i 147.12 147.17} {tt 149.0 149.10} {i 149.10 149.18} {tt 150.179 150.183} {tt 152.0 152.8} {tt 152.13 152.23} {tt 155.0 155.10} {i 155.10 155.14} {tt 156.10 156.10} {i 156.10 156.14} {tt 158.0 158.12} {i 158.12 158.23} {tt 158.28 158.38} {i 158.38 158.49} {tt 161.0 161.26} {tt 162.44 162.63} {tt 164.0 164.6} {tt 164.10 164.18} {tt 167.0 167.9} {i 167.9 167.17} {tt 168.10 168.10} {i 168.10 168.18} {tt 168.31 168.39} {tt 170.0 170.10} {i 170.10 170.18} {tt 171.10 171.10} {i 171.10 171.18} {tt 171.31 171.47} {tt 173.0 173.15} {tt 176.0 176.10} {tt 176.15 176.27} {tt 177.45 177.53} {tt 177.74 177.78} {tt 177.88 177.94} {tt 177.117 177.121} {tt 179.0 179.2} {tt 182.0 182.3} {i 182.3 182.12} {tt 183.4 183.8} {i 183.8 183.17} {tt 184.4 184.8} {i 184.8 184.17} {tt 185.14 185.17} {tt 185.117 185.120} {tt 185.133 185.136} {tt 187.0 187.4} {tt 190.0 190.6} {h2 194.0 194.12} {tt 196.61 196.63} {tt 196.73 196.81} {manref 196.134 196.142} {tt 196.169 196.180} {tt 196.249 196.250} {tt 196.263 196.264} {tt 196.276 196.277} {tt 196.449 196.477} {tt 196.529 196.548} {tt 196.721 196.748} {h2 199.0 199.9} {tt 201.5 201.9} {tt 201.110 201.114} {sc 203.75 203.82} {sc 203.195 203.202} {tt 203.236 203.244} {manref 205.177 205.187} {manref 205.189 205.199} {manref 205.201 205.210} {manref 205.212 205.223} {manref 205.246 205.255} {tt 205.257 205.262} {tt 205.417 205.434} {tt 205.442 205.449} {h3 210.0 210.8} {b 212.27 212.35} {tt 212.48 212.56} {tt 215.0 215.15} {tt 216.185 216.199} {tt 219.0 219.16} {i 219.16 219.45} {tt 220.4 220.20} {i 220.20 220.49} {tt 221.4 221.20} {i 221.20 221.49} {i 221.57 221.68} {tt 222.4 222.20} {i 222.20 222.49} {i 222.56 222.67} {tt 226.0 226.12} {i 226.12 226.21} {i 226.22 226.29} {i 226.30 226.47} {tt 227.0 227.12} {i 227.12 227.21} {i 227.22 227.29} {i 227.30 227.47} {tt 228.0 228.14} {i 228.14 228.23} {i 228.24 228.41} {tt 229.0 229.11} {i 229.11 229.18} {i 229.19 229.27} {i 231.4 231.21} {sc 231.110 231.117} {tt 231.171 231.184} {tt 231.192 231.200} {sc 231.223 231.230} {tt 231.235 231.239} {i 231.266 231.275} {i 231.280 231.287} {tt 231.343 231.344} {tt 231.348 231.350} {tt 231.353 231.354} {tt 233.24 233.34} {tt 235.293 235.305} {tt 235.309 235.324} {tt 235.478 235.482} {tt 235.629 235.643} {tt 237.40 237.51} {h3 240.0 240.8} {tt 242.162 242.170} {tt 243.0 243.46} {tt 244.0 244.21} {tt 247.0 247.54} {tt 248.0 248.21} {tt 251.0 251.46} {tt 252.0 252.51} {tt 255.0 255.60} {tt 256.0 256.24} {tt 257.0 257.22} {tt 260.0 260.41} {tt 261.0 261.45} {tt 262.0 262.21} {tt 263.0 263.18} {tt 266.0 266.25} {tt 269.0 269.25} {h3 272.0 272.26} {tt 274.48 274.52} {tt 274.244 274.248} {tt 274.673 274.681} {tt 276.77 276.85} {tt 276.181 276.188} {tt 276.305 276.329} {h1 279.0 279.25} {i 281.225 281.230} {i 283.528 283.532} {i 283.533 283.547} {i 326.16 326.26} {h1 330.0 330.10} {i 332.11 332.21} {manref 332.63 332.69} {i 332.72 332.82} {manref 332.91 332.95} {i 332.380 332.390} {tt 332.806 332.866} {h1 335.0 335.6} {tt 342.0 342.14} {h1 345.0 345.16} {i 347.49 347.63} {i 349.0 349.20} {i 351.92 351.102} {tt 351.216 351.252} {h1 354.0 354.7} {sc 360.0 360.150} {sc 364.0 364.289} {sc 366.0 366.359} } {
	eval $t tag add $qq
}

foreach qq {{introduction1 21.0} {using1 43.0} {locating2 45.0} {working2 64.0} {other2 81.0} {preferences2 94.0} {customizing1 115.0} {command2 142.0} {key2 194.0} {tkmandesc2 199.0} {platspec1 279.0} {rosettaman1 330.0} {author1 335.0} {more1 345.0} {license1 354.0} } {
	eval $t mark set $qq
}

