/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/rpc/sources/RCS/ui_rpcP.ph,v $
  SHORTNAME      : ui_rpcP.ph
  SNNS VERSION   : 4.1

  PURPOSE        : private header for ui_rpc.ph
  NOTES          :

  AUTHOR         : Sven Doering
  DATE           : 

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.6 $
  LAST CHANGE    : $Date: 1995/11/16 07:27:50 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/

#ifndef _UI_RPCP_DEFINED_
#define _UI_RPCP_DEFINED_

/* begin global definition section */

#ifndef INADDR_LOOPBACK
#define INADDR_LOOPBACK  (u_long)0x7F000001
#endif
#ifndef IN_SET_LOOPBACK_ADDR
#define IN_SET_LOOPBACK_ADDR(a)	{(a)->sin_addr.s_addr=htonl(INADDR_LOOPBACK);\
				 (a)->sin_family = AF_INET;}
#endif


/* Errors */
#define RPCERROR -1
#define RPCERROR_HOSTNOTFOUND -2


#define MAX_HOST_ENTRIES        100
#define MAX_HOST_LEN            60
#define MAX_PATH_LEN            60
#define MAX_PARAMETER_LEN       60
#define MAX_HOST_PANEL_SHOW     350
#define MAX_HOST_LEN_SHOW       50
#define MAX_PATH_LEN_SHOW       50
#define MAX_PARAMETER_LEN_SHOW  50
#define SWITCH_TO_LOCAL_ALL     5
#define SWITCH_TO_LOCAL_SINGLE  10
#define MAXWAITTIME             300
#define TIMEOUTSHORT            5

typedef struct {
        int     kernelid;
	u_int   pid;
        int     xguiid;
	char 	*hostname;
	char 	*domainname;
	char 	hostaddr[16];
	long    kernelno;
	char	*listentry;
	CLIENT  *cl;
	bool_t  hasKernelConfig;
	par_config *kernel_config; 
	/* For the control Panel */
	int     SubPatPanel; /* == -1 sup pattern panel so far never created
				==  0 not poped up right now
				==  1 poped up right now */
}hostentry;

/* 
 *The global RPC handle 
 */
struct timeval longtimeout;
struct timeval oldtimeout;
CLIENT *clienthandle;
char *akthostname;
/* is also declared in ui_rpcP.ph points to host[0].kernel_config */
par_config *kernel_config_ptr;

u_long kernelnummer = 0;
u_long callbacknummer = 0;
u_long prognummer = 0;
hostentry host[MAX_HOST_ENTRIES+1];
char *hostnames[MAX_HOST_ENTRIES+1];
hostentry server[MAX_HOST_ENTRIES+1];
char *servernames[MAX_HOST_ENTRIES+1];
uint anzEntries = 0;
int aktlistpos = -1;
uint anzHostEntries = 0;
int akthost = -1;
int aktserver = -1;
long minbroadcast = 0L;
long maxbroadcast =0L;
int uid;
bool rpc_sendUpdateNet=TRUE;
char str_idle[] = "idle";
char str_learning[] = "learning";
char itemsNames[MAX_HOST_PANEL_SHOW];

uint coopMaster = -1;
bool_t coopModified = FALSE;
uint anzCoopEntries = 0;
parallel_kernel coopKernels[MAXPARAKERNELS+1];

int *ui_kernel_callback(callback_info *c_info, struct svc_req *cl);
void ui_MakeHostList(void);
void ui_MakeServerList(void);
int ui_AppendServer(char *serv);
int ui_AppendHost(char *serv,char *doamin,char *addr,long kernelno,u_int pid,int xguiid, par_config *kernel_conf);
void ui_DeleteHost(u_int pos);
int ui_RPCswitchtoHost(int Hostnum,bool saveConfig);
char * ui_RPCmakeListEntry(int Hostnum,char *listentry);
char * ui_RPCchangeListEntry(int Hostnum);
void ui_RPCchangeControlPanel(void);
void ui_RPCchangeControlPanelValues(int fromHost,int toHost,bool saveConfig);
par_config *ui_RPCcreateKernelConfigEntry(void);
void ui_RPCsetSetupValues(void);
void ui_RPCstoreSetupValues(void);
int ui_CheckKernelID(int id);
int ui_RPCCallGET_SNNS_KERNEL(struct sockaddr_in *addr,long vers,char *serv);

/* end global definition section */

/* begin private definition section */

static int globalkernelid = 1;   /* The next new Kernelid */


/* end private definition section */
#endif /* UI_RPCP */



















































