#! /bin/sh

#
# mkppddir: create ppd.dir information files for later use.
#
# Copyright (C) 1996, Yves Arrouye <Yves.Arrouye@imag.fr>
#

me=`basename $0`

usage() {
    >&2 echo "usage: $me [ --version ] [ -f, --force ] [ --rename ] [ --pcrename ] [ directory ... ]"
    exit 1
}

for i
do
    case "$i" in
	--version)
	    echo `basename $me .sh` "(poor man's)" version 1.0.1, \
		by Yves Arrouye "<Yves.Arrouye@marin.fdn.fr>"
	    ;;
	-f|--force)
	    ;;
	--rename)
	    rename=full
	   ;;
	--pcrename)
	    rename=pc
	    ;;
	-*)
	    usage
	    ;;
	*)
	    dirs="$dirs $i"
	    ;;
    esac
    shift
done

pcname() {
    unset _name
    : ${_name:=`grep '^\*PCFileName:' "$1" | sed 's/.*"\(.*\)".*/\1/'`}
    : ${_name:=`basename "$1" "$2"`}
    _name="`echo $_name | sed 's/^\(........\).*/\1/'`"
    basename $_name | tr '[A-Z]' '[a-z]'
    unset _name
}

printername() {
    unset _name
    : ${_name:=`grep '^\*NickName:' "$1" | sed 's/.*"[ 	]*\(.*[^ ]\)[ 	]*".*/\1/'`}
    : ${_name:=`grep '^\*ModelName:' "$1" | sed 's/.*"[ 	]*\(.*[^ ]\)[ 	]*".*/\1/'`}
    : ${_name:=`grep '^\*Product:' "$1" | sed 's/.*([ 	]*\(.*[^ ]\)[ 	]*).*/\1/'`}
    : ${_name:=`grep '^\*ShortNickName:' "$1" | sed 's/.*"[ 	]*\(.*[^ ]\)[ 	]*".*/\1/'`}
    : ${_name:=`basename "$1"`}
    echo $_name
    unset _name
}

ppdname() {
    echo "$1" | sed -e 's,[ .],_,g' -e 's,/,%,g'
}

printerppdname() {
    _what=`printername "$1"`
    ppdname "$_what"
    unset _what
}

where="`pwd`"

: ${dirs:=.}

for d in $dirs
do
    cd $d
    if ! touch ppd.dir
    then
	>&2 echo "$me: cannot create directory in \`$d'"
    else
        rm -f ppd.dir
	ppdfiles=`2>/dev/null ls *.ppd *.PPD`
        for p in $ppdfiles
        do
	    pcname=`pcname "$p"`
	    fullname=`printerppdname "$p"`

	    if [ "$rename" = 'full' ]
	    then
		if [ "$p" != "$fullname".ppd ]
		then
		if 2>/dev/null mv "$p" "$fullname".ppd
		then
		    p="$fullname".ppd
		else
		    >&2 echo $me: cannot rename "\`$d/$p'" to "\`$d/$fullname.ppd'"
		fi
		else
		    p="$fullname".ppd
		fi
	    fi

	    if [ "$rename" = 'pc' ]
	    then
		if [ "$p" != "$pcname".ppd ]
		then
		if 2>/dev/null mv "$p" "$pcname".ppd
		then
		    p="$pcname".ppd
		else
		    >&2 echo $me: cannot rename "\`$d/$p'" to "\`$d/$pcname.ppd'"
		fi
		else
		    p="$pcname".ppd
		fi
	    fi

	    echo "$pcname" "$fullname" "$p" >>ppd.dir
        done
    fi
    cd "$where"
done

