val gif_anim_load : bool ref

module ImageData :
  sig
    type t = Tkanim.imageType
    val gamma : float ref
    val jpeg_converter : string ref
    val verbose : bool ref

    val load :
      Document.handle -> Document.document_id list -> string -> 
	                                                Tkanim.imageType
    val cache_access : Url.t -> Document.document_id -> Tkanim.imageType
    val error :
      Url.t -> (Document.document_id * (Tkanim.imageType -> unit)) list -> unit
    val error_msg : Www.request * string -> unit
    val remove_reference : Document.document_id -> unit
    val dump: unit -> unit
  end

module ImageScheduler : Scheduler.S with
    type shared_data = ImageData.t

val get : Document.document_id -> Hyper.link -> (ImageData.t -> unit) -> unit
