open Htmlfmt
open Embed

val attempt_tables : bool ref
val verbose : bool ref

(* Interaction with other parts of the navigator interface *)
class virtual extracontext (unit) =
  virtual set_title : string -> unit
  virtual add_link : string -> Hyper.link -> unit
end


class virtual imgloader (unit) =
  virtual add_image : embobject -> unit	 (* add one image *)
  virtual flush_images : unit	         (* flush when document is loaded *)
  virtual load_images : unit		 (* manual flush *)
end


class virtual machine (unit) =
  virtual formatter : formatter
  virtual imgmanager : imgloader
  virtual tcontext : extracontext
  virtual base : string
  virtual ctx : Viewers.context
  virtual add_tag :
    string -> (formatter -> Html.tag -> unit) -> (formatter -> unit) -> unit
  virtual remove_tag : string -> unit
  virtual push_action : (string -> unit) -> unit
  virtual pop_action : unit
  virtual push_formatter : formatter -> unit
  virtual pop_formatter : unit
  virtual send : Html.token -> unit
end


val add_hook: (machine -> unit) -> unit

module Make 
 (G : GfxHTML) ( I : ImgDisplay) (F: FormDisplay) (T: TableDisplay) : sig

(* Do we need to export FormLogic and TableLogic so that extensions
   can access them ?
 *)

val create :
  (Document.document_id * Viewers.context * extracontext * formatter) ->
    machine

end
