#include "cthugha.h"
#include "sound.h"
#include "display.h"

/* Wave-display-functions */
void wave_dotHS();	void wave_dotHM();	void wave_dotHL();	
void wave_dotVS();	void wave_dotVM();	void wave_dotVL();
void wave_lineHS();	void wave_lineHM();	void wave_lineHL();
void wave_lineVS();	void wave_lineVM();	void wave_lineVL();
void wave_spikeS();	void wave_spikeL();	void wave_spikeH();

void wave_buff9();	void wave_buff10();
void wave_buff11();	void wave_buff12();	void wave_buff13();
void wave_buff14();	void wave_buff15();	void wave_buff16();
void wave_pete0();	void wave_pete1();	void wave_pete2();
void wave_fract1();	void wave_fract2();	void wave_test();
void wave_aaron();

opt_data waves[] = {
    { wave_dotHS,	1,	"DotHS", 	"Dots Hor. Short" },
    { wave_dotHM,	1,	"DotHM", 	"Dots Hor. Medium" },
    { wave_dotHL,	1,	"DotHL", 	"Dots Hor. Long" },

    { wave_dotVS,	1,	"DotVS", 	"Dots Ver. Short" },
    { wave_dotVM,	1,	"DotVM", 	"Dots Ver. Medium" },
    { wave_dotVL,	1,	"DotVL", 	"Dots Ver. Long" },

    { wave_lineHS,	1,	"LineHS", 	"Lines Hor. Short" },
    { wave_lineHM,	1,	"LineHM", 	"Lines Hor. Medium" },
    { wave_lineHL,	1,	"LineHL", 	"Lines Hor. Long" },

    { wave_lineVS,	1,	"LineVS", 	"Lines Ver. Short" },
    { wave_lineVM,	1,	"LineVM", 	"Lines Ver. Medium" },
    { wave_lineVL,	1,	"LineVL", 	"Lines Ver. Long" },

    { wave_spikeS,	1,	"SpikeS", 	"Spikes Short" },
    { wave_spikeL,	1,	"SpikeL", 	"Spikes Long" },
    { wave_spikeH,	1,	"SpikeH", 	"Spikes Hollow" },

    { wave_buff9,	1,	"Walking",	"Walking"},
    { wave_buff10,	1,	"Falling",	"Falling"},
    { wave_buff11,	1,	"Lissa",	"Lissa"},
    { wave_buff14,	1,	"LineX",	"Line X"},
    { wave_buff15, 	1,	"Light1", 	"Lightning 1"},
    { wave_buff16, 	1,	"Light2", 	"Lightning 2"},
    { wave_pete0,	1,	"Pete0",	"FireFlies"},
    { wave_pete1,	1,	"Pete1",	"Pete"},
    { wave_pete2,	1,	"Pete2",	"Dot VS sine"},
    { wave_fract1,	1,	"Fract1",	"Zippy 1"},
    { wave_fract2,	1,	"Fract2",	"Zippy 2"},
    { wave_test,	1,	"Test",		"Test"},
    { wave_aaron,	1,	"Aaron",	"Rings of Fire"}
};
int nr_waves = sizeof(waves) / sizeof(opt_data);

/*****************************************************************************/

extern int Bsine[MAX_BUFF_WIDTH];

/*
 * some helping macros and functions
 */

#define addr(x,y)	((x) + (y)*BUFF_WIDTH)
#define BOTTOM		(BUFF_HEIGHT -1)
#define MID_Y		(BUFF_HEIGHT>>1)
#define MID_X		(BUFF_WIDTH>>1)
#define LOW_LINE	(BUFF_HEIGHT - BUFF_HEIGHT/10)

#define	tcolor(x)	tables[ active_table][(x)]
#define putat(x,y,val)	active_buffer[ addr( (x) , (y) ) ] = val

void do_vwave(int ystart, int yend, int x, char val) {
    int ys, ye;
    char * pos;

    if ( ystart > yend)	
	ys = yend, ye = ystart;
    else
	ys = ystart, ye = yend;		
		
    if ( ys <  0)		ys = 0;
    if ( ys >= BUFF_HEIGHT)	ys = BUFF_HEIGHT - 1;
    if ( ye <  0)		ye = 0;
    if ( ye >= BUFF_HEIGHT)	ye = BUFF_HEIGHT - 1;
		
    pos = active_buffer + addr(x,ys);
    for(; ys <= ye; ys ++) {
	*pos = val;
	pos += BUFF_WIDTH;
    }
}

void do_hwave(int xstart, int xend, int y, char val) {
    int xs, xe;
    char * pos;

    if ( xstart > xend)	
	xs = xend, xe = xstart;
    else
	xs = xstart, xe = xend;		

    while ( (xs < 0) && (xe < 0) )
	xs += BUFF_WIDTH, xe += BUFF_WIDTH;
    while ( (xs >= BUFF_WIDTH) && (xe >= BUFF_WIDTH))
	xs -= BUFF_WIDTH, xe -= BUFF_WIDTH;
		
    if ( xs <  0)		xs = 0;
    if ( xs >= BUFF_WIDTH)	xs = BUFF_WIDTH - 1;
    if ( xe <  0)		xe = 0;
    if ( xe >= BUFF_WIDTH)	xe = BUFF_WIDTH - 1;

    pos = active_buffer + addr(xs, y);
    for(; xs <= xe; xs ++) {
	*pos = val;
	pos ++;
    }
}

/*****************************************************************************
 *
 * Some functions require a minimum resolutions. They will be disabled if 
 * the buffer is too small. If such a wave-function get selected it will
 * automatically change to the next wave-function.
 * 
 *****************************************************************************/


/***************************************************************************** 
 * Dot horizontal functions 
 *****************************************************************************/

void wave_dotHS() {	/* dot horizontal small */
    if( BUFF_HEIGHT > ((BUFF_HEIGHT/10)+64) ) {
	int x, tmp;
	
	for(x=0; x < BUFF_WIDTH; x++) {
	    tmp = sound_data[x][0];
	    putat( x>>1, LOW_LINE-32 - (tmp >> 2), tcolor(tmp+128) );
	    tmp = sound_data[x][1];
	    putat( (x+BUFF_WIDTH)>>1, LOW_LINE-32-(tmp >> 2), tcolor(tmp+128));
	}
    } else {
	change_display_wave(CHANGE_NEXT);
    }
}

void wave_dotHM() {		/* dot horizontal medium */
    if( BUFF_HEIGHT > (BUFF_HEIGHT/10+128) ) {
	int x; int tmp;

	for(x=0; x < BUFF_WIDTH; x++) {
	    tmp = sound_data[x][0];
	    putat( x>>1, LOW_LINE-64 - (tmp >> 1), tcolor(tmp+128) );
	    tmp = sound_data[x][1];
	    putat( (x+BUFF_WIDTH)>>1, LOW_LINE-64 - (tmp>>1), tcolor(tmp+128));
	}
    } else {
	change_display_wave(CHANGE_NEXT);
    }
}

void wave_dotHL() {		/* dot horizontal long */
    if( BUFF_HEIGHT > (BUFF_HEIGHT/10+256) ) {
	int x; int tmp;

	for(x=0; x < BUFF_WIDTH; x++) {
	    tmp = sound_data[x][0];
	    putat( x>>1, LOW_LINE-128 - tmp, tcolor(tmp+128) );
	    tmp = sound_data[x][1];
	    putat( (x+BUFF_WIDTH)>>1, LOW_LINE-128 - tmp, tcolor(tmp+128));
	}
    } else {
	change_display_wave(CHANGE_NEXT);
    }
}

/***************************************************************************** 
 * Dot vertical functions 
 *****************************************************************************/

void wave_dotVS() {	/* dot vertical short */
    if( BUFF_WIDTH > 128 ) {
	int tmp,x;
	
	for( x =0; x < BOTTOM; x++) {
	    tmp = sound_data[x][0] + 128;
	    putat(MID_X - (tmp >> 2), x, tcolor(tmp));
	    tmp = sound_data[x][1] + 128;
	    putat(MID_X + (tmp >> 2), x, tcolor(tmp));
	}
    } else {
	change_display_wave(CHANGE_NEXT);
    }
}

void wave_dotVM() {		/* dot vertical medium */
    if( BUFF_WIDTH > 256 ) {
	int tmp,x;
	
	for( x =0; x < BOTTOM; x++) {
	    tmp = sound_data[x][0] + 128;
	    putat(MID_X - (tmp >> 1), x, tcolor(tmp) );
	    tmp = sound_data[x][1] + 128;
	    putat(MID_X + (tmp >> 1), x, tcolor(tmp) );
	}
    } else {
	change_display_wave(CHANGE_NEXT);
    }
}

void wave_dotVL() {	/* dot vertical long */
    if( BUFF_WIDTH > 512 ) {
	int tmp,x;
	
	for( x =0; x < BOTTOM; x++) {
	    tmp = sound_data[x][0] + 128;
	    putat(MID_X - tmp, x, tcolor(tmp) );
	    tmp = sound_data[x][1] + 128;
	    putat(MID_X + tmp, x, tcolor(tmp) );
	}
    } else {
	change_display_wave(CHANGE_NEXT);
    }
}


/****************************************************************************
 * Line horizontal functions
 ****************************************************************************/

void wave_lineHS() {	/* Line horizontal small */
    int x,y, tmp;
    static int last=0;
	
    for(y=0; y < 2; y ++) 
	for(x=0; x < BUFF_WIDTH; x++) {
	    tmp = sound_data[x][y];
	    do_vwave( MID_Y-(tmp>>2), MID_Y-(last>>2), 
		     y ? ((x+BUFF_WIDTH)>>1) : (x>>1), tcolor(tmp+128));
	    last = tmp;
	}
}

void wave_lineHM() {	/* Line horizontal medium */
    int x,y, tmp;
    static int last=0;
	
    for(y=0; y < 2; y ++) 
	for(x=0; x < BUFF_WIDTH; x++) {
	    tmp = sound_data[x][y];
	    do_vwave( MID_Y-(tmp>>1), MID_Y-(last>>1), 
		     y ? ((x+BUFF_WIDTH)>>1) : (x>>1), tcolor(tmp+128));
	    last = tmp;
	}
}

void wave_lineHL() {	/* Line horizontal long */
    int x,y, tmp;
    static int last = 0;
	
    for(y=0; y < 2; y ++) 
	for(x=0; x < BUFF_WIDTH; x++) {
	    tmp = sound_data[x][y];
	    do_vwave( MID_Y-tmp, MID_Y-last, 
		     y ? ((x+BUFF_WIDTH)>>1) : (x>>1), tcolor(tmp+128));
	    last = tmp;
	}
}

/****************************************************************************
 * Line vertical functions
 ****************************************************************************/

void wave_lineVS() {	/* Line veritcal short */
    int tmp, x, last1=128, last2=128;
	
    for(x=0; x < BOTTOM; x++) {
	tmp = sound_data[x][0] + 128;
	do_hwave( MID_X - (tmp>>2), MID_X - (last1 >> 2), x, tcolor(tmp));
	last1 = tmp;
	
	tmp = sound_data[x][1] + 128;
	do_hwave( MID_X + (tmp>>2), MID_X + (last2 >> 2), x, tcolor(tmp));
	last2 = tmp;
    }
}

void wave_lineVM() {	/* Line vertical medium */
    int tmp, x, last1=128, last2=128;
	
    for(x=0; x < BOTTOM; x++) {
	tmp = sound_data[x][0] + 128;
	do_hwave( MID_X - (tmp >> 1), MID_X - (last1 >> 1), x, tcolor(tmp));
	last1 = tmp;
		
	tmp = sound_data[x][1] + 128;
	do_hwave( MID_X + (tmp >> 1), MID_X + (last2 >> 1), x, tcolor(tmp));
	last2 = tmp;
    }
}

void wave_lineVL() {	/* Line vertical long */
    int tmp, x, last1=128, last2=128;
	
    for(x=0; x < BOTTOM; x++) {
	tmp = sound_data[x][0] + 128;
	do_hwave( MID_X - tmp, MID_X - last1, x, tcolor(tmp));
	last1 = tmp;
		
	tmp = sound_data[x][1] + 128;
	do_hwave( MID_X + tmp, MID_X + last2, x, tcolor(tmp));
	last2 = tmp;
    }
}
	

/****************************************************************************
 * Spikes functions
 ****************************************************************************/

void wave_spikeS() {	/* Spike small */
    if( BUFF_HEIGHT > 64 ) {
	int x, tmp, i;

	for(x=0; x < BUFF_WIDTH; x++) {
	    tmp = abs(sound_data[x][0]) >> 1;
	    for(i=0; i < tmp; i++)
		putat(x>>1,BOTTOM-i, tcolor(i));
	    tmp = abs(sound_data[x][1]) >> 1;
	    for(i=0; i < tmp; i++)
		putat((x+BUFF_WIDTH) >> 1,BOTTOM-i, tcolor(i) );
	}
    } else {
	change_display_wave(CHANGE_NEXT);
    }
}

void wave_spikeL() {	/* Spike long */
    if( BUFF_HEIGHT > 128 ) {
	int x, tmp, i;

	for(x=0; x < BUFF_WIDTH; x++) {
	    tmp = abs(sound_data[x][0]);
	    for(i=0; i < tmp; i++)
		putat(x>>1,BOTTOM-i, tcolor(i) );
	    tmp = abs(sound_data[x][1]);
	    for(i=0; i < tmp; i++)
		putat((x+BUFF_WIDTH) >> 1,BOTTOM-i, tcolor(i));
	}
    } else {
	change_display_wave(CHANGE_NEXT);
    }
}

void wave_spikeH() {	/* Spike hollow */
    int tmp, x,y, last=0;
	
    for(y=0; y < 2; y++) {
	for(x=0; x < BUFF_WIDTH; x++) {
	    tmp = abs( sound_data[x][y] );
	    do_vwave(BOTTOM-tmp, BOTTOM-last,
		     y ? ((x+BUFF_WIDTH) >> 1): (x >> 1), tcolor(tmp) );
	    last = tmp;
	}
    }
}


/*****************************************************************************
 * other wave-functions
 *****************************************************************************/


void wave_buff9() {		/* Walking */
    int tmp, x, last1=128, last2=128;
    static int col = 128;
	
    col = (col+1) % BUFF_WIDTH;
	
    for( x=0; x < BOTTOM; x++) {
	tmp = sound_data[x][0] + 128;
	do_hwave( col-(tmp>>2), col-(last1>>2), x, tcolor(tmp) );
	last1 = tmp;
		
	tmp = sound_data[x][1] + 128;
	do_hwave( col+(tmp>>2), col+(last2>>2), x, tcolor(tmp) );
	last2 = tmp;
    }
}
void wave_buff10() {		/* Falling */
    int i;
    static int row=0;
	
    row = (row+1) % BOTTOM;
    for(i=0; i < MID_X;i++) {
	putat( i,       row+1, tcolor(sound_data[i][0]+128) );
	putat( i+MID_X, row+1, tcolor(sound_data[i][1]+128) );
	putat( i,       row,   tcolor(sound_data[i+160][0]+128) );
	putat( i+MID_X, row,   tcolor(sound_data[i+160][0]+128) );
    }
}

void wave_buff11() {		/* Lissa */
    int tmp, x, tmp2;
	
    for(x=0; x < BUFF_WIDTH; x++) {
	tmp = sound_data[x][0]+128;
	tmp2= sound_data[x][1]+128;
		
	putat( (tmp2+32)%BUFF_WIDTH, (tmp+200-28)%BOTTOM, tcolor( tmp) );
    }
}

void wave_buff14() {		/* Line X */
    int tmp, x, last = 128;
	
    for(x=0; x < BOTTOM; x++) {
	tmp = sound_data[x][0] + 128;				
	do_hwave( MID_X-(tmp >> 2), MID_X-(last >> 2),x, tcolor(tmp));
	last = tmp;
    }
    for(x=0; x < BOTTOM; x++) {
	tmp = sound_data[x][1] + 128;
	do_hwave( MID_X-40+(tmp >> 2), MID_X-40+(last >> 2),x,tcolor(tmp));
	last = tmp;
    }
}

void wave_buff15() {		/* Lightning 1 */
    int tmp,x,last=BUFF_WIDTH/3;
	
    for(x=0; x < BOTTOM; x++) {
	
	tmp = (sound_data[x][0] >> 4) + last;
		
	if ( tmp >= BUFF_WIDTH)
	    tmp = BUFF_WIDTH-1;
	if ( tmp < 0)
	    tmp = 0;
			
	do_hwave(tmp,last,x,255);
	last = tmp;
    }
	
    last = 2*BUFF_WIDTH/3;
    for(x=0; x < BOTTOM; x++) {
	
	tmp = (sound_data[x][1] >> 4) + last;
		
	if ( tmp >= BUFF_WIDTH)
	    tmp = BUFF_WIDTH-1;
	if ( tmp < 0)
	    tmp = 0;
			
	do_hwave(tmp,last,x,255);
	last = tmp;
    }
}
void wave_buff16() {		/* Lightning 2 */
    int tmp,x,last=BUFF_WIDTH/3;
	
    for(x=0; x < BOTTOM; x++) {
	
	tmp = (sound_data[x][0] >> 5) + last;
		
	if ( tmp >= BUFF_WIDTH)
	    tmp = BUFF_WIDTH-1;
	if ( tmp < 0)
	    tmp = 0;
			
	do_hwave(tmp,last,x,255);
	last = tmp;
    }
	
    last = 2*BUFF_WIDTH/3; 
    for(x=0; x < BOTTOM; x++) {
	
	tmp = (sound_data[x][1] >> 5) + last;
		
	if ( tmp >= BUFF_WIDTH)
	    tmp = BUFF_WIDTH-1;
	if ( tmp < 0)
	    tmp = 0;
			
	do_hwave(tmp,last,x,255);
	last = tmp;
    }
}

void wave_pete0() {		/* FireFlies */
    int temp,temp2,x; 
    static int xoff0=160,yoff0=100; 
    static int xoff1=160,yoff1=100; 
 
    xoff0 += (sound_data[0][0]+128)%9-4; 
    yoff0 += (sound_data[1][0]+128)%9-4; 
 
    xoff1 += (sound_data[0][1]+128)%9-4; 
    yoff1 += (sound_data[1][1]+128)%9-4; 
 
    while (xoff0<0) 
	xoff0+=BUFF_WIDTH; 
    while (yoff0<0) 
	yoff0+=BOTTOM; 
 
    while (xoff1<0) 
	xoff1+=BUFF_WIDTH; 
    while (yoff1<0) 
	yoff1+=BOTTOM; 
 
    xoff0=xoff0%BUFF_WIDTH; 
    xoff1=xoff1%BUFF_WIDTH; 
 
    yoff0=yoff0%BUFF_HEIGHT; 
    yoff1=yoff1%BUFF_HEIGHT; 
 
    for (x=0; x<BUFF_WIDTH; x++) { 
	temp=sound_data[x][0]+128; 
	temp2=sound_data[(x+80)%BUFF_WIDTH][0]+128; 
 
	putat( 
	    ((temp2>>2)+xoff0)%BUFF_WIDTH,
	    ((temp>>2)+yoff0)%BOTTOM, tcolor(temp)); 
 
	temp=sound_data[x][1]+128; 
	temp2=sound_data[(x+80)%BUFF_WIDTH][1]+128; 
 
	putat(
	    ((temp2>>2)+xoff1)%BUFF_WIDTH,
	    ((temp>>2)+yoff1)%BOTTOM, tcolor(temp)); 
    } 
}

void wave_pete1() {
    int tmp, x,left=0, right=0;

    if( BUFF_HEIGHT > 128) {
	
	for(x=0; x < BUFF_WIDTH; x++) {
	    left += abs(sound_data[x][0]);
	    right += abs(sound_data[x][1]);
	}
	
	left = left / MID_X;
	right = right / MID_X;
	
	left = min(left, BOTTOM);
	right = min(right, BOTTOM);
	
	for(x=0; x < MID_X; x++) {
	    tmp = sound_data[x][0];
	    putat( x, BOTTOM-(abs(left * Bsine[x]) >> 8), tcolor(tmp));
	}		
	for(x= MID_X; x < BUFF_WIDTH; x++) {
	    tmp = sound_data[x][1];
	    putat( x, BOTTOM-(abs(right * Bsine[x]) >> 8), tcolor(tmp));
	}		
    } else {
	change_display_wave(CHANGE_NEXT);
    }
}

void wave_pete2() {		/* Dot VS sine */
    if( BUFF_HEIGHT > 64 ) {
	int tmp,x;
	
	for( x =0; x < BUFF_HEIGHT; x++) {
	    tmp = sound_data[x][0] + 128;
	    putat(MID_X - (tmp >> 2), x, tcolor(sine[tmp]) );
	    tmp = sound_data[x][1] + 128;
	    putat(MID_X + (tmp >> 2), x, tcolor(sine[tmp]) );
	}
    } else {
	change_display_wave(CHANGE_NEXT);
    }
}

void wave_fract1() {		/* Zippy 1*/
    int temp,x; 
    static int xoff0=0,yoff0=0; 
    static int xoff1=0,yoff1=0; 
 
    temp=sound_data[0][0]+128; 
    for (x=0; x<BUFF_WIDTH-2; x+=2) { 
	xoff0 += (sound_data[x][0]+128-temp)>>1; 
	temp=sound_data[x][0]+128; 
  
	while (xoff0<0) 
	    xoff0=BUFF_WIDTH-1; 
 
	xoff0=xoff0%BUFF_WIDTH; 
 
	putat(xoff0, yoff0, tcolor(temp));
 
	yoff0 += (sound_data[x+1][0]+128-temp)>>1; 
	temp=sound_data[x+1][0]+128; 
 
	while (yoff0<0) 
	    yoff0=BUFF_HEIGHT-1; 
 
	yoff0=yoff0%BUFF_HEIGHT; 
 
	putat(xoff0, yoff0, tcolor(temp));
    } 
 
    temp=sound_data[0][1]+128; 
    for (x=0; x<BUFF_WIDTH-2; x+=2) { 
	xoff1 += (sound_data[x][1]+128-temp)>>1; 
	temp=sound_data[x][1]+128; 
 
	if (xoff1<0) 
	    xoff1=BUFF_WIDTH-1; 
 
	xoff1=xoff1%BUFF_WIDTH; 

	putat(xoff1, yoff1, tcolor(temp)); 
 
	yoff1 -= (sound_data[x+1][1]+128-temp)>>1; 
	temp=sound_data[x+1][1]+128; 
 
	if (yoff1<0) 
	    yoff1=BUFF_HEIGHT-1; 
 
	yoff1=yoff1%BUFF_HEIGHT; 

	putat(xoff1, yoff1, tcolor(temp) ); 
    } 
}

void wave_fract2(void) {	/* Zippy 2 */ 
    int temp,x; 
    static int xoff0=0,yoff0=0; 
    static int xoff1=0,yoff1=0; 
 
    temp=sound_data[0][0]; 
    for (x=0; x<BUFF_WIDTH-2; x+=2) { 
	xoff0 += (sound_data[x][0]-temp); 
	temp=sound_data[x][0]; 
 
 
	if (xoff0<0) 
	    xoff0=BUFF_WIDTH-1; 
 
	xoff0=xoff0%BUFF_WIDTH; 
 
	putat(xoff0, yoff0, tcolor(temp));
		 
	yoff0 += (sound_data[x+1][0]-temp); 
	temp=sound_data[x+1][0]; 
 
	if (yoff0<0) 
	    yoff0=BUFF_HEIGHT-1; 
 
	yoff0=yoff0%BUFF_HEIGHT; 
 
	putat(xoff0, yoff0, tcolor(temp));
    } 
 
    temp=sound_data[0][1]; 
    for (x=0; x<BUFF_WIDTH-2; x+=2) { 
	xoff1 += (sound_data[x][1]-temp); 
	temp=sound_data[x][1]; 
 
 
	if (xoff1<0) 
	    xoff1=BUFF_WIDTH-1; 
 
	xoff1=xoff1%BUFF_WIDTH; 
 
	putat(xoff1, yoff1, tcolor(temp));
 
	yoff1 -= (sound_data[x+1][1]-temp); 
	temp=sound_data[x+1][1]; 
 
	if (yoff1<0) 
	    yoff1=BUFF_HEIGHT-1; 
 
	yoff1=yoff1%BUFF_HEIGHT; 
 
	putat(xoff1, yoff1, tcolor(temp) );
    } 
} 
 
void wave_test() {		/* Test */
    int temp,x,left=0,right=0; 

    if ( BUFF_HEIGHT > 128) {
 
	for (x=0; x<BUFF_WIDTH; x++) { 
	    left += abs(sound_data[x][0]); 
	    right += abs(sound_data[x][1]); 
	} 
	
	left = left / (128); 
	right = right / (128); 
	
	left=min(left,199); 
	right=min(right,199); 
 
	for (x=0; x<MID_X; x++) { 
	    temp=sound_data[x][0]+128; 
	    putat( x, BOTTOM-(abs((left)*Bsine[x])>>8), tcolor(temp));
	} 
	for	(x=MID_X; x<BUFF_WIDTH; x++) { 
	    temp=sound_data[x][1]+128; 
	    putat( x, BOTTOM-(abs((right)*Bsine[x])>>8), tcolor(temp));
	} 
    } else {
	change_display_wave(CHANGE_NEXT);
    }
} 

/* 
 * From root@hangon.onramp.net Sun Jun 18 04:42:22 1995
 * some changes by Deischinger Harald
 *
 * the rings have a radius of 64.
 */
void wave_aaron() {
    if( (BUFF_HEIGHT > 128) && (BUFF_WIDTH > 256) ) {
	static int x=40,y=0;
	int tmp,i;

	for( i=0;i<BUFF_WIDTH;i++ ) {
	    if(y>=320) y-=320;
	    if(x>=320) x-=320;
	    tmp = sound_data[x][0] + 128;

	    putat(((BUFF_WIDTH-256)/2)+64+128+((sine[x]*tmp)>>9),
		  ((BOTTOM    -256)/2)   +128+((sine[y]*tmp)>>9), 
		  tmp );
	    tmp = sound_data[x][1] + 128;

	    putat(((BUFF_WIDTH-256)/2)-64+128-((sine[x]*tmp)>>9),
		  ((BOTTOM    -256)/2)   +128-((sine[y]*tmp)>>9), 
		  tmp );
	    x++;
	    y++;
	}
    } else {
	change_display_wave(CHANGE_NEXT);
    }
} 






