#include "cthugha.h"
#include "options.h"

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <getopt.h>
#include <dirent.h>
#include <string.h>
#include <ctype.h>

#include "sound.h"
#include "display.h"
#include "action.h"
#include "translate.h"
#include "information.h"
#include "display.h"
#include "sound.h"
#include "cd_player.h"
#include "keys.h"
#include "net_sound.h"

char extra_lib_path[256] = "";			/* extra path to search for
						   pcx, tab, map and ini */
int double_load = 0;				/* allow double loading */

#ifndef CTH_SERVER

int options_save = 0;			/* save options (and buffer) at end */

opt_data opt_null = {NULL, 0, "none", "" };

opt_data * opt_change(int to, opt_data * in, int in_size, void * old) {
    int i;
    int nouse;

    /* check for empty set */
    if ( in_size == 0)
	return &opt_null;
	
    /* check, of there is any option we can use */
    nouse = 1;
    for(i=0; i < in_size; i++)
	if ( in[i].use )
	    i = in_size,
	    nouse = 0;

    /* if non in use, return first */
    if ( nouse)
	return &(in[0]);
	
    switch(to) {
    case CHANGE_RANDOM:
	do {
	    to = rand() % in_size;
	} while( ! in[to].use );
	break;
    case CHANGE_NEXT:
    	if ( old == NULL)		/* if no old exists use first as old */
	    old = in[0].data;
    		
	for(i=0; i < in_size; i++)
	    if( in[i].data == old ) {
		to = i;
		do {
		    to = (to+1) % in_size;
		} while( ! in[to].use);
	    }
	break;
    case CHANGE_PREV:
	if ( old == NULL)
	    old = in[0].data;

	for(i=in_size-1; i >= 0; i--)
	    if( in[i].data == old) {
		to = i;
		do {
		    to = (to > 0) ? to - 1 : in_size - 1;
		} while( ! in[to].use);
	    }
	break;
    default:
	if ( to < 0)			to = 0;
	if ( to >= in_size)		to = in_size -1;
	while( ! in[to].use) 
	    to = (to+1) % in_size;
    }
#ifdef DEBUG
    printf("opt_change: %s -- %s\n", in[to].name, in[to].description);
#endif
    return &(in[to]);
}

/*
 * change option, allowing "general form"
 */
opt_data * opt_change2(char * to, opt_data * in, int in_size, void * old) {
    int nr;
    char * pos;
	
    /* do nothing if to is empty */
    if ( *to == '\0' ) 
	return (old==NULL) ? opt_change(CHANGE_RANDOM, in, in_size, old) : old;

    /* first try to read as number */
    nr = strtol(to, &pos, 0);
    if ( pos == to )
	/* not a number, so try as name */
	nr = opt_number_str(to, in, in_size);

    return opt_change(nr, in, in_size, old);
}


opt_data * opt_get(void * what, opt_data * in, int in_size) {
    int i;
    for( i = 0; i < in_size; i++)
	if ( in[i].data == what)
	    return &(in[i]);
	
    return &opt_null;
}
int opt_number(void * what, opt_data * in, int in_size) {
    int i;
    for( i = 0; i < in_size; i++)
	if ( in[i].data == what)
	    return i;
	
    return CHANGE_RANDOM;
}
#endif
int opt_number_str(const char * name, opt_data * in, int in_size) {
    int i;
    for( i = 0; i < in_size; i++)
	if ( strcasecmp(in[i].name, name) == 0)
	    return i;

    printfv("Unknown option name %c%s%c\n", 34,name,34);
	
    return CHANGE_RANDOM;
}
int opt_defined(const char * name, opt_data * in, int in_size) {
    int i;
    for( i=0; i < in_size; i++)
	if ( strcmp(in[i].name, name) == 0)
	    return 1;
    return 0;
}
#ifndef CTH_server

/****************************************************************************/


int val_change(int to, int min, int max, int old) {
	
    switch(to) {
    case CHANGE_RANDOM:
	if ( max < min)
	    return min;
	return rand() % (1+max-min) + min;
    case CHANGE_NEXT:
	return ( old >= max) ? min: old + 1; 
    case CHANGE_PREV:
	return ( old <= 0) ? max : old - 1;
    default:
	if ( to < min)		to = min;
	if ( to > max)		to = max;
	return to;
    }
}

/*****************************************************************************/
void load_quiet_strings(char * fname) {

    FILE * file;
    char * s;
	
    if ( (fname == NULL) || (*fname == '\0'))
	return;
	
    if( (file = fopen(fname, "r")) == NULL) {
	printfee("Can't open quiet-strings-file %s", fname);
	return;
    }

    nr_silence_strings = 0;		
    do {
	/* read a line */
	s = fgets(silence_strings[nr_silence_strings], 255, file);	
	if ( s != NULL)
	    nr_silence_strings ++;
    } while ( (nr_silence_strings < MAX_SILENCE_STRINGS) && (s != NULL) );

    /* check if file was empty */
    if ( nr_silence_strings == 0) {
	nr_silence_strings = 1;
	strcpy( silence_strings[0], "Where is the musc?");
    }
}

/*****************************************************************************/

/*
 * general load-function
 */
int load(char * search_path[], char * extra_path, char * extension, 
	 int (* load_function)(FILE *, char *)) {
    int path;
    DIR * directory;
    FILE * file;	
    struct dirent * entry;
    char total_name[255];
    char extra_path_dir[512];

    int has_extension() {
	char * pos = strstr( entry->d_name, extension);
	if ( pos == NULL)
	    return 0;
	if ( (pos[strlen(extension)]=='\0') || (pos[strlen(extension)]=='.') ) 
	    return 1;
	return 0;
    }
    int is_compressed() {
	int l = strlen( entry->d_name);
	if ( l < 3)
	    return 0;
	if ((entry->d_name[l-3] == '.') && 
	    (entry->d_name[l-2] == 'g') && 
	    (entry->d_name[l-1] == 'z') )
	    return 1;
	return 0;
    }
    void load_dir(char * dir) {
	int compressed;

	if ( (directory = opendir( dir )) != NULL) {
	    while( (entry = readdir(directory))	 != NULL) {

		if ( ! has_extension() ) 
		    continue;

		/* create real filename */
		strncpy( total_name, dir, 255);
		strncat( total_name, entry->d_name, 255);

		compressed = is_compressed();

		if ( compressed ) {	  
		    /* open with 'gzip' - as pipe */
		    char cmd[512];

		    printfv("  uncompressing and ");

		    sprintf(cmd, "gzip -cd %s", total_name);

		    file = popen( cmd, "r");		
		    
		} else {
		    /* normal open - as file */
		    file = fopen( total_name, "r");
		}

		printfv("  loading: %s", total_name);
		
		/* now do the loading */
		if ( file != NULL)  {
		    /* remove rest of name */
		    *strstr(entry->d_name, extension) = '\0';
		    /* file was openen successfully  - now read it */
		    if ( (*load_function)( file, entry->d_name) == 0)
			printfv("  ... OK\n");

		    if ( compressed) 
			pclose(file);	/* close pipe */
		    else
			fclose(file);	/* close file */

		} else {		/* file/pipe could not be opened */
		    printfv("  ... x\n");
		}
	    }
	    closedir(directory);
	}
    }
	    
    /* load normal search path */
    path = 0;
    while( search_path[path][0] != '\0') {
	load_dir( search_path[path] );
	path ++;
    }
    /* load from extra path */
    if ( extra_lib_path[0] != '\0') {
	strcpy( extra_path_dir, extra_lib_path);
	strncat( extra_path_dir, extra_path, 512);
	load_dir( extra_path_dir);
    }
    
    return 0;
}

/*****************************************************************************/		
#endif /* CTH_server */

int do_param(int c, int value, char * str) {
    switch(c) {
    case 0:
	return 0;
    case '2':					/* Stereo */
	sound_stereo = 1;	break;
    case '1':					/* Mono */
	sound_stereo = 0;	break;

    case 'v':					/* Sample-Speed */
	sound_sample_rate = value;	
	break;

    case 'V':					/* Record Volume */
	sound_volume_rec = value;
	sound_volume_rec |= sound_volume_rec << 8;
	break;

    case 'L':					/* Line as input */
	sound_volume_line = value;
	sound_volume_line |= sound_volume_line << 8;
	if ( sound_volume_line) 
	    sound_source |= SNDSRC_LINE;	
	else
	    sound_source &= ~SNDSRC_LINE; 
	break;
    case 'M':					/* Mic as input */
	sound_volume_mic = value;
	sound_volume_mic |= sound_volume_mic << 8;
	if ( sound_volume_mic) 
	    sound_source |= SNDSRC_MIC;	
	else
	    sound_source &= ~SNDSRC_MIC; 
	break;
    case 'C':					/* CD as input */
	sound_volume_cd = value;
	sound_volume_cd |= sound_volume_cd << 8;
	if ( sound_volume_cd)
	    sound_source |= SNDSRC_CD;	
	else
	    sound_source &= ~SNDSRC_CD; 
	break;
    case 'c':					/* with cd starting at track */
	sound_source |= SNDSRC_CD;
	cd_first_track = value;
	break;
    case 'x':					/* debug mode */
	sound_source = SNDSRC_DEBUG;
	break;

#ifndef CTH_server
    case 'f':					/* Set start flame */
	strcpy(flame_first, str);	break;
    case 'w':					/* Set start wave */
	strcpy(wave_first, str);	break;
    case 'p':					/* Set first palette */
	strcpy(palette_first, str);	break;
    case 'd':					/* Set first display */
	strcpy(screen_first, str);	break;
    case 't':					/* Set first translate */
	strcpy(translate_first, str);	break;
    case 'P':					/* Set first PCX */
	strcpy(pcx_first, str);		break;
    case 'a':					/* Set first table */
	table_first = value;		break;
    case 'm':					/* Set first massage */
	massage_first = value;		break;

    case 'l':					/* Lock changes */
	action_lock = 1;		break;

    case 'i':					/* no internal palettes */
	display_internal_pal = 0;	break;
    case 'e':					/* no external palettes */
	display_external_pal = 0;	break;

    case 'F':					/* no FFT */
	sound_use_fft = 0;		break;
	
    case 'T':					/* Time to change */
	sound_wait_min = value; 	break;
    case 'R':					/* Add. Random time */
	sound_wait_random = value;	break;
    case 'Q':					/* Quiet Time */
	sound_wait_quiet = value;	break;

    case 'r':					/* sync-mode */
	display_syncwait = 1;		break;

    case 'b':					/* set peak-level for beat */
	sound_peaklevel = value;	break;
    case 'B':					/* set nr of beats to change */
	sound_wait_beat = value;	break;

    case 'q':					/* alternative quiet-strings */
	load_quiet_strings(str);	break;

    case 'X':					/* disable PCX */
	display_use_pcx = 0;		break;

    case 'N': {					/* Read from remote machine */
	char * p;
	sound_source = SNDSRC_SOCK;
	if( (p = strchr(str, ':')) != NULL ) {
	    *p = '\0';
	    SRV_PORT = atoi(p+1);
	}
	strncpy(dsp_file, str, 255);
	break;
    }
    case 'D':					/* display-mode */
	if( strchr(str, 'x') == NULL) {
	    /* use a predfined size */
	    display_mode = value;
	} else {
	    /* use a special size (only useful with X11) */
	    display_mode = -1;
	    screen_width = value;
	    screen_height = atoi(strchr(str, 'x')+1);
	}
	break;

    case 'S':					/* buffer-size */
	if( strchr(str, 'x') == NULL) {
	    /* use a predfined size */
	    if( value < 0)			
		value = 0;
	    if( value >= nr_buffer_sizes)	
		value = nr_buffer_sizes;
	    BUFF_WIDTH = buffer_sizes[value][0];
	    BUFF_HEIGHT = buffer_sizes[value][1];
	} else {
	    /* use a special size */
	    BUFF_WIDTH = value;
	    BUFF_HEIGHT = atoi(strchr(str, 'x')+1);
	    if( BUFF_WIDTH < 64)		
		BUFF_WIDTH = 64;
	    if( BUFF_HEIGHT < 64)		
		BUFF_HEIGHT = 64;
	    if( BUFF_WIDTH > MAX_BUFF_WIDTH)	
		BUFF_WIDTH = MAX_BUFF_WIDTH;
	    if( BUFF_HEIGHT > MAX_BUFF_WIDTH)	
		BUFF_HEIGHT = MAX_BUFF_WIDTH;
	}
	break;

    case -1:					/* prt-file */
	strncpy(display_prt_file, str, 255);
	break;

    case 'E':					/* extra lib path */
	strncpy(extra_lib_path, str, 255);
	strncat(extra_lib_path, "/", 255);
	break;

    case -2:					/* silence time */
	sound_quiet_change = value;		/* for change at small pause */
	break;

    case -3:					/* tile */
	display_tile_x = display_tile_y = 1;
	break;
    case -4:					/* no-tile */
	display_tile_x = display_tile_y = 0;
	break;

    case -6:	CLT_PORT = value; break;	/* port (for client) */
#else /* CTH_server */

    case 'W':					/* time to wait when server */
	srv_wait_time = value;
	break;
#endif
#ifndef CTH_saverX11
    case -5:	REQ_PORT = value; break;	/* port (for server) */
#endif	

    default:					/* error or help */
	usage();
	return 1;
    }
    return 0;
}

/* 
   Process programm-params 
*/
int get_params(int argc, char * argv[]) {	
    int c;

    /* options accepted after ini-files are visited */
    static struct option long_options[] = {
	{ "help",  	0, 0,'?'},
	{ "verbose", 	0, &cthugha_verbose,1},
	{ "no-verbose",	0, &cthugha_verbose,0},
	{ "line",	1, 0,'L'},
	{ "mic",	1, 0,'M'},
	{ "cd",		1, 0,'C'},
	{ "volume",	1, 0,'V'},
	{ "track",	1, 0,'c'},
	{ "rate",	1, 0,'v'},
	{ "cd-stop",	0, &cd_stop_on_exit, 1},
	{ "no-cd-stop",	0, &cd_stop_on_exit, 0},
	{ "no-sound",	0, &sound_source, SNDSRC_DEBUG},
	{ "stereo",	0, &sound_stereo, 1},
	{ "no-stereo",	0, &sound_stereo, 0},
	{ "mono",	0, &sound_stereo, 0},
	{ "no-mono",	0, &sound_stereo, 1},
	{ "cd-random",	0, &cd_randomplay, 1},
	{ "no-cd-random", 0, &cd_randomplay, 0},
	{ "cd-no-random", 0, &cd_randomplay, 0},
	{ "cd-loop",	0, &cd_loop, 1},
	{ "no-cd-loop", 0, &cd_loop, 0},
	{ "cd-no-loop", 0, &cd_loop, 0},
	{ "cd-eject",	0, &cd_eject_on_end, 1},
	{ "no-cd-eject", 0, &cd_eject_on_end, 0},
	{ "cd-no-eject", 0, &cd_eject_on_end, 0},
	{ "cd-autoplay", 0, &cd_first_track, 1},
	{ "cd-no-autoplay", 0, &cd_first_track, -1},
	{ "no-cd-autoplay", 0, &cd_first_track, -1},
	{ "snd-sync",	0, &sound_sync, 1},
	{ "no-snd-sync",0, &sound_sync, 0},
#ifndef CTH_saverX11
	{ "srv-port",	1, 0,-5},
#endif
#ifndef CTH_server
	{ "sync",	0, &display_syncwait, 1},
	{ "no-sync",	0, &display_syncwait, 0},
	{ "pause", 	0, &cthugha_pause,1},		
	{ "no-pause", 	0, &cthugha_pause,0},
	{ "flame",	1, 0,'f'},
	{ "wave",	1, 0,'w'},                      
	{ "translation",1, 0,'t'},
	{ "palette",	1, 0,'p'},
	{ "display",	1, 0,'d'},
	{ "lock",	0, &action_lock, 1},
	{ "no-lock",	0, &action_lock ,0},
	{ "use-pcx",	0, &display_use_pcx, 1},
	{ "no-use-pcx",	0, &display_use_pcx, 0},
	{ "trans",	0, &use_translations, 1},
	{ "no-trans", 	0, &use_translations, 0},
	{ "fft",	0, &sound_use_fft,	1},
	{ "no-fft",	0, &sound_use_fft,	0},
	{ "ipal",	0, &display_internal_pal, 1},
	{ "no-ipal",	0, &display_internal_pal, 0},
	{ "epal",	0, &display_external_pal, 1},
	{ "no-epal",	0, &display_external_pal, 0},
	{ "time",	1, 0,'T'},
	{ "random",	1, 0,'R'},
	{ "quiet-time",	1, 0,'Q'},
	{ "beat-nr",	1, 0,'B'},
	{ "beat-level",	1, 0,'b'},
	{ "quiet-file",	1, 0,'q'},
	{ "disp-mode",	1, 0,'D'},
	{ "tile-x", 	0, &display_tile_x, 1},
	{ "tile-y", 	0, &display_tile_y, 1},
	{ "no-tile-x",	0, &display_tile_x, 0},
	{ "no-tile-y",	0, &display_tile_y, 0},
	{ "network",	1, 0,'N'},
	{ "esc",	0, &key_esc, 1},
	{ "no-esc",	0, &key_esc, 0},
#ifdef CTH_console
	{ "disp-direct",0, &display_direct, 1},
	{ "no-disp-direct", 0, &display_direct, 0},
#endif
	{ "buff-size",	1, 0,'S'},
	{ "tile",	0, 0,-3},
	{ "no-tile",	0, 0,-4},
	{ "pcx",	1, 0,'X'},
	{ "save",	0, &options_save, 1},
	{ "no-save",	0, &options_save, 0},
	{ "prt-file",	1, 0,-1},
	{ "table",	1, 0,'a'},
	{ "massage",	1, 0,'m'},
	{ "no-pcx",	0, &display_use_pcx, 0},
#ifdef CTH_X11
	{ "mit-shm",	0, &display_mit_shm, 1},
	{ "no-mit-shm",	0, &display_mit_shm, 0},
	{ "on-root",	0, &display_on_root, 1},
	{ "no-on-root", 0, &display_on_root, 0},
	{ "in-window",  0, &display_on_root, 0},
	{ "no-in-window", 0, &display_on_root, 1},
	{ "private-cmap", 0, &display_private_cmap, 1},
	{ "no-private-cmap", 0, &display_private_cmap, 0},
#endif
	{ "silence-time", 1, 0,-2},
	{ "stretch",	0, &trans_stretch, 1},
	{ "no-stretch",	0, &trans_stretch, 0},
	{ "little",	0, &change_little, 1},
	{ "no-little",	0, &change_little, 0},
	{ "clt-port",	1, 0,-6},
	{ "dbl-load",	0, &double_load, 1},
	{ "no-dbl-load",0, &double_load, 0},
#ifndef CTH_saverX11
	{ "server",	0, &server, 1},
	{ "no-server",	0, &server, 0},
#endif
#endif
#ifdef CTH_server
	{ "srv-wait",	1, 0,'W'},
#endif
	{ "path",	1, 0,'E'},
	{ 0,0,0,0}
    };
    int option_index = 0;

    /* options checked before ini-files are loaded */
    static struct option long_options_preini[] = {
	{ "path",	1, 0,'E'},
	{ "verbose", 	0, &cthugha_verbose,1},
	{ "no-verbose",	0, &cthugha_verbose,0},
	{ 0,0,0,0}
    };
    
    int optindsave=optind;
    char * argv_tmp[ argc ];			/* copy of argv to work with */

    /* 
     * check for options read before loading ini files 
     */
    opterr = 0;					/* don't print error msgs */
    for(c=0; c < argc; c++)			/* save argv */
    	argv_tmp[c] = argv[c];

    while((c = getopt_long(argc, argv_tmp, "E:", 
			   long_options_preini, &option_index)) != -1) {
	if ( do_param((c=='?')?0:c, optarg ? atoi(optarg) : 0, optarg) )
	    return 1;
    }
	    
    /* 
     * now read from ini-files 
     */
    read_ini();	
		
    /*
     * get common command line options after loading ini files 
     */
    opterr = 1;					/* print error msgs */
    option_index = 0; optind = optindsave;	/* start again at first opt */

    while((c=getopt_long(argc, argv, 
    			 "21v:V:L:M:C:c:xrP:E:?E:"
			 #ifndef CTH_server
			 "f:w:d:p:t:b:B:q:T:R:N:D:S:a:m:XlieQ:F"
			 #else
			 "W:"
			 #endif
			 ,long_options, &option_index)) != -1 ) {

	if( do_param(c, optarg ? atoi(optarg) : 0, optarg) )
	    return 1;
    }

    return 0;
}

#ifndef CTH_server
/* 
 *  Some informational messages 
 */
int options_information() {

    if ( ! cthugha_verbose)
	return 0;
		
    if ( action_lock)
	printf("Starting in LOCKED mode.\n");
    if ( cthugha_verbose)
	printf("Verbose-mode.\n");
    if ( display_syncwait)
	printf("Waiting for sync on display.\n");
    if ( ! display_use_pcx) 
	printf("PCX-Support disabled.\n");
    printf("Buffer size: %dx%d.\n", BUFF_WIDTH, BUFF_HEIGHT);
		
    printf("\n");
			
    return 0;		
}

/*
 * Set first options in use
 */
int init_startup() {

    printfv("setting startup...\n");

    /* set palette */
    active_palette = opt_change2(palette_first, palettes, nr_palettes,
				NULL)->data;;

    /* set screen-function */
    update_screen = opt_change2(screen_first, screens, nr_screens, NULL)->data;

    /* use first pcx if specified */
    if( pcx_first[0] != '\0' ) { 
        /* select first pcx-file */
        active_pcx = opt_change2(pcx_first, pcxs, nr_pcx, NULL)->data;
        if ( active_pcx != NULL) {
	    show_pcx(1,0);		/* display the select pcx to active*/
	    memcpy(passive_buffer, active_buffer, BUFF_SIZE); /* and passive b. */
	    active_palette =		/* and set corresponding palette */
  	        opt_change(pcx_palettes[ opt_number(active_pcx, pcxs, nr_pcx)],
		           palettes,nr_palettes,active_palette)->data;
	}
    } else {
    	change_pcx(CHANGE_NEXT);
    }


    /* select first wave */
    display_wave = opt_change2(wave_first, waves, nr_waves, NULL)->data;

    /* set first translation */
    active_translation = opt_change2(translate_first, translations, 
				     nr_translations, NULL)->data;

    /* set first flame-function */
    flame = opt_change2(flame_first, flames, nr_flames, flame)->data;

    /* set first table */
    change_table(table_first);

    /* set first massage */
    change_massage_style(massage_first);

    return 0;
}

/*
 * save startup-section if --save was given
 */
int exit_startup() {
    if ( options_save) {
	write_ini_startup();
	save_buffer();
    }
    return 0;
}

#endif /* CTH_server */

