/*
    CTHUGHA-L
	
    Linux-Version of CTHUGHA
	
    This Version is done by
	Harald Deischinger  		   k3096e5@c210.edvz.uni-linz.ac.at
		
	Am Edhuegel 46
	4115  Kleinzell
	AUSTRIA		

		
"It gives credence to the phrase 'I can see music'...There is no real 
 way to describe the patterns except as weird". 
 - Australian PC Review Oct '94 

"Cthugha displays your sound card's CD, line or mic-input, then processes 
it into a hypnotic, swirling, 256-color confection for your eyes".
 - WIRED 3.03 (p. 156: Music to Your Eyes)
------------------------------------------------------------------------------
*/

#include "cthugha.h"
#include "action.h"				/* display_sound() */
#include "keys.h"
#include "display.h"
#include "translate.h"
#include <sys/time.h>

int main(int argc, char * argv[])  {
    int key;

    if( init_cthugha(argc, argv) )
	return 1;

    if( init_graph_mode() ) 
	return exit_cthugha(-1);

#if 0
    {	/* TEST */
	struct timeval tv1, tv2;
	display_sound();
	display_sound();

	gettimeofday(&tv1,NULL);
	for(key=0; key < 100; key ++) {
	    done_translation = 0;
	    flame();
	    translate();
	}
	gettimeofday(&tv2,NULL);
	printf("diff: %f\n", (double)(tv2.tv_sec-tv1.tv_sec) +
	    (tv2.tv_usec-tv1.tv_usec)/1000000.0 );
    }
#else
    /* Main-Loop */
    do {
	display_sound();

	while( (key = getkey()) != Z_NOKEY) 
	    main_key_switch(key);

    } while( cthugha_finish == 0);
#endif

    return exit_cthugha(0);			/* clean up */
}














