#include "cthugha.h"
#include "sound.h"
#include "options.h"
#include "net_sound.h"
#include "keys.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <sys/soundcard.h>
#include <math.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#undef COLORS
#include <ncurses.h>


int sound_sock;					/* used for broadcast */
int request_socket;				/* use to recv. requests */

struct sockaddr_in client_addrs[MAX_CLIENTS];
int nr_clients = 0;

int srv_wait_time = 100;			/* time to wait after send */
int server = 0;					/* server active */

int remove_client(long addr, short port);

/*
 * create socket to transmit the sound
 */
int init_sound_socket() {

    if( (sound_sock = socket(PF_INET, SOCK_DGRAM, 0)) < 0) {
	printfee("Can not open socket");
	return 1;
    }
    fcntl( sound_sock, F_SETFL, O_NONBLOCK);
		
    return 0;
}
/*
 * close the socket for transmission of the sound
 */
int exit_sound_socket() {
    close(sound_sock);
    return 0;
}

/*
 * create a socket to receive requests from clients
 */
int init_request_socket() {
    struct sockaddr_in s_addr;

    /* create request-socket */
    if( (request_socket = socket(PF_INET, SOCK_STREAM, 0)) < 0) {
	printfee("Can not open request socket");
	return 1;
    }
    /* bind */
    s_addr.sin_family = AF_INET;
    s_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    s_addr.sin_port = htons(REQ_PORT);
    if( bind(request_socket, (struct sockaddr*)&s_addr, sizeof(s_addr)) < 0) {
	printfee("Can not bind to request socket.");
	close(request_socket);
	return 1;
    }
    /* change to non-blocking */
    fcntl( request_socket, F_SETFL, O_NONBLOCK); 

    /* listen */
    if ( listen(request_socket, 1) < 0) {
	printfee("Can not listen.\n");
	close(request_socket);
	return 1;
    }
    return 0;
}

/*
 * close the socket to receive requests
 */
int exit_request_socket() {
    shutdown(request_socket, 2);
    close(request_socket);
    return 0;
}

/*
 * Broadcast the sound_data to all clients
 */
int broadcast_sound() {
    int i;

    for(i=0; i < nr_clients; i++) {

	if( sendto(sound_sock, &(sound_data[0][0]), 2*BUFF_WIDTH, 0,
		   (struct sockaddr*)&client_addrs[i], 
		   sizeof(struct sockaddr_in)) <= 0) {
	    if ( errno != 111)
		printfee("Can not write to client.")
	    else
		fprintf(stderr, "x");
	    return 0;
	}
    }
    return 0;
}


/*
 * include a new client in the list
 */
int add_client(long addr, short port) {
    struct sockaddr_in s_addr;

    printfv("adding %lx:%d\n", addr, port);

    s_addr.sin_family = AF_INET;
    s_addr.sin_port = htons(port); 
    s_addr.sin_addr.s_addr = addr;

    /* remove old entry */
    remove_client(addr,port);

    /* check for full memory */
    if ( nr_clients >= MAX_CLIENTS)
	return 1;

    /* append new entry to list */
    memcpy( &(client_addrs[nr_clients]), &s_addr, sizeof(struct sockaddr_in));

    nr_clients ++;

    return 0;
}

/*
 *remove a client from the list
 */
int remove_client(long addr, short port) {
    struct sockaddr_in s_addr;
    int i;

    printfv("removing %lx:%d\n", addr, port);

    s_addr.sin_family = AF_INET;
    s_addr.sin_port = htons(port); 
    s_addr.sin_addr.s_addr = addr;

    for(i=0; i < nr_clients; i++) {
	if( (s_addr.sin_port == client_addrs[i].sin_port) &&
	    (s_addr.sin_addr.s_addr == client_addrs[i].sin_addr.s_addr)) {
	    printfv("Removing %lx:%d at position %d\n", addr,port,i);
	    memcpy( &(client_addrs[i]), &(client_addrs[i+1]), 
		   sizeof(struct sockaddr_in) * (nr_clients - i));
	    nr_clients --;
	}
    }

    return 0;
}

/*
 * print a list of all clients
 */
int print_clients() {
    int i;

    for(i=0; i < nr_clients; i++)
	printw("Client %d: %lx:%d\n", 
	       i, client_addrs[i].sin_addr.s_addr, 
	       client_addrs[i].sin_port);


    return 0;
}


/*
 * initialize the sound server
 */
int init_server() {

    /* prepare socket for boradcast */
    if ( init_sound_socket() ) {
	return 1;
    }

    /* prepare socket to receive requests */
    if ( init_request_socket() ) {
	exit_sound_socket();
	return 1;
    }

    return 0;
}
/* 
 * close down the sound server
 */
int exit_server() {

    exit_sound_socket();
    exit_request_socket();

    return 0;
}

/*
 * accept new connection (check for new requests)
 */
int server_accept() {
    int  nr_read;
    char data[512];
    int client_port;
    long client_addr;
    struct sockaddr_in s_addr;
    int size;
    int acc_socket;

    if ( (acc_socket = accept(request_socket, 
			      (struct sockaddr*)&s_addr, &size) ) >= 0) {
	
	nr_read = recv(acc_socket, data, 64, 0);
	
	printfv("\nreceived %d bytes: %s", nr_read, data);
	
	if( sscanf(data, "connect %ld %d", 
		   &client_addr, &client_port) > 0)
	    add_client( client_addr, client_port );
	
	if( sscanf(data, "disconnect %ld %d", 
		   &client_addr,  &client_port) >0)
	    remove_client( client_addr, client_port );
	
	close(acc_socket);
    } else
	if ( errno != EWOULDBLOCK)
	    printfe("Can not accept.");
    return 0;
}

