/*
 * dnode1.c - PTX node functions for lsof
 *
 * This module must be separate to keep separate the multiple kernel inode
 * structure definitions.
 */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1996 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dnode1.c,v 1.1 96/03/19 10:48:22 abe Exp Locker: abe $";
#endif


#include "lsof.h"

#if	defined(HAS_CDFS)

#define	_INKERNEL
#include <sys/cdfsinode.h>
#undef	_INKERNEL


/*
 * read_cdnode() - read CD file system inode information
 */

int
read_cdnode(v, vfs, dev)
	struct vnode *v;		/* containing vnode */
	struct l_vfs *vfs;		/* local vfs structure */
	dev_t *dev;			/* device number receiver */
{
	struct cd_inode i;
	struct vnode dv;

	if (!v->v_data || kread((KA_T)v->v_data, (char *)&i, sizeof(i)))
		return(1);
/*
 * Read the underlying "dev" vnode.  Its v_rdev contains the device number
 * for CDFS files.
 */
	if (i.i_vnode.v_devvp
	&&  kread((KA_T)i.i_vnode.v_devvp, (char *)&dv, sizeof(dv)) == 0) {
		*dev = dv.v_rdev;
		Lf->dev_def = 1;
	}
/*
 * Record inode number.
 */
	Lf->inode = (unsigned long)i.iso_extent;
	Lf->inp_ty = 1;
/*
 * Record size.
 */
	if (!Foffset) {
		Lf->sz = (unsigned long)i.i_size;
		Lf->sz_def = 1;
	}
	return(0);
}
#endif	/* defined(HAS_CDFS) */
