.\" -*- nroff -*-
.TH PDMENU 1 "March 23 1997" "1.1.4" "Commands"
.SH NAME
pdmenu \- simple full screen menu program
.SH SYNOPSIS
.B pdmenu [\-h] [\-c] [\-n] [\fImenufile\fP ...]
.SH DESCRIPTION
.I pdmenu 
is a simple menu program that displays a menu from which the 
user can pick programs to run. Submenus are supported.
.PP
When you run 
.I pdmenu
, you will be presented with a menu. Simply use the arrow
keys to move to the program you want to run, and press Enter to run the
program. When the program ends, you will be returned to the menu.
.PP
If you are running pdmenu at the linux console, and gpm is running, you can
move the mouse and click to navigate through the menus.
.PP
Some menu items are actually submenus, and will take you to another menu.
Others may cause a text edit window to be displayed, where you can enter
parameters for a command before running it. Still others may run a command,
and display the output in a window.
.SH KEYS
Here are all keys you need to get around in \fIpdmenu\fP:
.IP "[up arrow], 8, -"
Move up one line in the menu.
.IP "[down arrow], 2, +"
Move down one line.
.IP "[page up], [ctrl-u]"
Move up an entire screen.
.IP "[page down], [space], [ctrl-v]"
Move down an entire screen.
.IP "[home]"
Move to the first entry of the menu.
.IP "[end]"
Move to the last entry of the menu.
.IP "q"
Exit the current menu, or exit
.I pdmenu 
if used on the first menu. Does not
work in the text edit windows. (This will not work if there is also a hotkey 
set up for \*(L'q\*(R', the hotkey takes precedence.)
.IP "ESC"
Close the currently active window, and return to the perious window.
.IP "[ctrl-c]"
Exit 
.I pdmenu
immediately.
.IP "[ctrl-r]"
Force a redraw of the screen.
.IP "[enter]"
Launch the selected menu item. In a text edit window, closes the window.
.IP "[backspace]"
Performs a destructive backspace in a text edit window. 
.IP "hotkeys"
Some letters of a menu item may be highlighted. These are hotkeys; simply
press the highlighted letter to select the next menu item with that hotkey.
.SH OPTIONS
.IP "-h, --help"
Display usage summary and exit.
.IP "-c, --color"
Use color. By default, 
.I pdmenu 
will display in black and white mode. If your 
terminal supports color, use this switch.
.IP "-q, --quit"
By default, at the opening menu, 'q' will exit \fIpdmenu\fP.
If the \-q switch is
specified, this will not be the case. This is useful if you want to prevent 
the user from ever exiting \fIpdmenu\fP.
.SP
This also disables control-c and the right mouse button from exiting
\fIpdmenu\fP.
.IP "menufile ..."
Specify a menu definition file or files to use. If you specify multiple
files, they will all be loaded in together.
.SH NOTES
To use the mouse to cut and paste as usual, hold down on the shift key when
you use the mouse.
.SH FILES
.I /etc/pdmenurc
.RS
Default config file. See
.BR pdmenurc (5)
for details.
.RE
.I ~/.pdmenurc
.RS
If this exists, it overrides /etc/pdmenurc. See
.BR pdmenurc (5)
for details.
.SH ENVIRONMENT
.IP COLORTERM
Set this variable to make
.I pdmenu 
to use color by default.
.SH DISTRIBUTION
Redistribution is subject to the GNU public license.
.SH BUGS
No important bugs are known at this time.
.SH AUTHOR 
Joey Hess, <joey@kite.ml.org>.
.SH "SEE ALSO"
.BR pdmenurc (5)
