#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>
#include "GraphicToolbox.h"
#include "GNUstepGUI/GSDrawFunctions.h"

@interface NSScroller (theme)
- (BOOL) isHorizontal;
@end

@implementation NSScroller (theme)
- (BOOL) isHorizontal
{
	return _isHorizontal;
}

- (void) drawKnobSlot
{
  static NSRect rect;
  static NSRect rect2;
  if (_cacheValid == NO)
    {
      rect = [self rectForPart: NSScrollerKnobSlot];
    }
	rect2 = rect;
	//FIXME: that should be done directly in rectForPart !
	if (_isHorizontal)
	{
		rect2.origin.y -= 1;
		rect2.size.height += 2;
	}
	else
	{
		rect2.origin.x -= 1;
		rect2.size.width += 2;
	}
[[_window backgroundColor] set];
NSRectFill (rect2);

  NSBezierPath* path = [NSBezierPath bezierPath];
  [path appendBezierPathWithRoundedRectangle: rect withRadius: 8.0];
  [[NSColor colorWithCalibratedRed: 0.94 green: 0.94 blue: 0.94 alpha: 1.0] set];
	NSColor* start = [NSColor colorWithCalibratedRed: 0.8 green: 0.8 blue: 0.8 alpha: 1.0];
	NSColor* end   = [NSColor colorWithCalibratedRed: 1.0 green: 1.0 blue: 1.0 alpha: 1.0];
	//NSGraphicsContext *ctxt = GSCurrentContext();
	//DPSgsave (ctxt);
	//[path addClip];
	if (_isHorizontal)
	{
		[GSDrawFunctions drawVerticalGradient: start to: end frame: rect];
	}
	else
	{
		[GSDrawFunctions drawHorizontalGradient: end to: start frame: rect];
	}
	//DPSgrestore (ctxt);
	NSArray* size;
	NSData* gradient;
//  [path fill];
}

- (void) drawKnob
{
	NSRect knob = [self rectForPart: NSScrollerKnob];
//[[_window backgroundColor] set];
//	NSRectFill (knob);
	//if (_isHorizontal)
/*
	{
		knob.origin.y += 1;
		knob.size.height -= 2;
	}
	//else
	{
		knob.origin.x += 1;
		knob.size.width -= 2;
	}
*/	
	NSButtonCell* kCell = [NSButtonCell new];
	[kCell setButtonType: NSMomentaryChangeButton];
	[kCell setImage: [NSImage imageNamed: @"common_Dimple"]];
	[kCell setImagePosition: NSImageOnly];
  	[kCell drawWithFrame: knob inView: self];
}

- (void) drawRect: (NSRect)rect
{
	//[[NSColor redColor] set];
	//NSRectFill (rect);
  static NSRect rectForPartIncrementLine;
  static NSRect rectForPartDecrementLine;
  static NSRect rectForPartKnobSlot;
  
  if (_cacheValid == NO)
    {
      rectForPartIncrementLine = [self rectForPart: NSScrollerIncrementLine];
      rectForPartDecrementLine = [self rectForPart: NSScrollerDecrementLine];
      rectForPartKnobSlot = [self rectForPart: NSScrollerKnobSlot];
	rectForPartKnobSlot = rect;
    }

//  [[_window backgroundColor] set];
//  NSRectFill (rect);

 // if (NSIntersectsRect (rect, rectForPartKnobSlot) == YES)
    {
      [self drawKnobSlot];
      [self drawKnob];
    }

  if (NSIntersectsRect (rect, rectForPartDecrementLine) == YES)
    {
      [self drawArrow: NSScrollerDecrementArrow highlight: NO];
    }
  if (NSIntersectsRect (rect, rectForPartIncrementLine) == YES)
    {
      [self drawArrow: NSScrollerIncrementArrow highlight: NO];
    }
}


@end
