import java.io.*;
import java.security.Security;
import javax.net.ssl.*;
import org.metastatic.jessie.provider.Jessie;
import org.metastatic.jessie.PrivateCredentials;

class testserver
{
  public static void main(String[] argv) throws Throwable
  {
    //Security.setProperty("jessie.keypool.dh.group", "2");
    Security.setProperty("jessie.entropy.source", "/dev/urandom");
    Security.addProvider(new Jessie());
    Security.addProvider(new gnu.crypto.jce.GnuCrypto());
    PrivateCredentials cred = new PrivateCredentials();
    cred.add(
      new FileInputStream(argv[0]), new FileInputStream(argv[1]));
    KeyManagerFactory kmf = KeyManagerFactory.getInstance("JessieX509");
    kmf.init(cred);
    SSLContext ctx = SSLContext.getInstance("SSLv3", "Jessie");
    ctx.init(kmf.getKeyManagers(), null, null);
    SSLServerSocket server =
      (SSLServerSocket) ctx.getServerSocketFactory().createServerSocket(4433);
    while (true)
      {
        try
          {
            System.err.println("accepting on port 4433");
            SSLSocket s = (SSLSocket) server.accept();
            System.err.println(s);
            s.startHandshake();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
            PrintStream out2 = new PrintStream(bout);
            BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream()));
            String line;
            out2.println("Your HTTPS request was:");
            while ((line = in.readLine()) != null)
              {
                if (line.length() == 0) break;
                System.out.println(line);
                out2.println(line);
              }
            out2.println();
            out2.print("This is a sample SSL server running on ");
            out2.println(System.getProperty("java.vendor") + " " + System.getProperty("java.vm.name") + "/" + System.getProperty("java.vm.version"));
            out2.println("with JESSIE version " + Jessie.VERSION);
            out2.println();
            out2.println("my server socket is " + server);
            out2.println("my local socket is " + s);
            out2.println();
            SSLSession session = s.getSession();
            out2.println("session information:");
            out2.print("        id: ");
            byte[] id = session.getId();
            for (int i = 0; i < id.length; i++)
              out2.print(id[i] + " ");
            out2.println();
            out2.println("     suite: " + session.getCipherSuite());
            out2.println("  protocol: " + session.getProtocol());
            out2.println("   created: " + new java.util.Date(session.getCreationTime()));
            out2.println("  accessed: " + new java.util.Date(session.getLastAccessedTime()));
            out2.println(" peer host: " + session.getPeerHost());
            out2.println("  my certs:");
            for (int i = 0; i < session.getLocalCertificates().length; i++)
              out2.println(session.getLocalCertificates()[i]);
            out2.flush();
            PrintStream out = new PrintStream(s.getOutputStream());
            out.print("HTTP/1.1 200 Ok\r\n");
            out.print("Server: Jessie/" + Jessie.VERSION + "\r\n");
            out.print("Content-Type: text/plain\r\n");
            out.print("Connection: Close\r\n");
            out.print("Content-length: " + bout.size() + "\r\n");
            out.print("\r\n");
            bout.writeTo(out);
            out.flush();
            s.close();
          }
        catch (IOException x)
          {
            x.printStackTrace();
          }
      }
  }
}
