/* $Id: mod_accounting.h,v 1.5 2002/03/05 12:42:08 tellini Exp $ */

/*
 * 	Copyright (c) 2001-2002 Simone Tellini
 *
 * 	Permission is hereby granted, free of charge, to any person obtaining 
 * 	a copy of this software and associated documentation files (the "Software"), 
 * 	to deal in the Software without restriction, including without limitation 
 * 	the rights to use, copy, modify, merge, publish, distribute, sublicense, 
 *	and/or sell copies of the Software, and to permit persons to whom the 
 * 	Software is furnished to do so, subject to the following conditions:
 *
 * 	The above copyright notice and this permission notice shall be included 
 * 	in all copies or substantial portions of the Software.
 *
 *	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 * 	OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * 	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 * 	THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * 	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * 	FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * 	DEALINGS IN THE SOFTWARE.
 */

#ifndef MOD_ACCOUNTING_H
#define MOD_ACCOUNTING_H

#include <time.h>

#include "httpd.h"
#include "http_config.h"
#include "http_log.h"
#include "http_core.h"


typedef struct _ignored_host 
{
	struct _ignored_host	*Next;
	short					Type;
	unsigned int			IP;

	union {							// just for elegance's sake :)
		unsigned int		Mask;
		unsigned int		IP2;
	} Args;

} ignored_host;

enum { IGN_MASK, IGN_RANGE };


typedef struct 
{
	char			*QueryFmt;
	char			*DBName;
	char			*DBHost;
	char			*DBPort;
	char			*DBUser;
	char			*DBPwd;
	int				DBDriver;
	char			*DBHandle;
	long			Sent;
	long			Received;
	time_t			LastUpdate;
	unsigned int	UpdateTimeSpan; // how many seconds to wait between 2 queries
	char			ServerName[ 512 ];
	ignored_host	*Ignore;
} accounting_state;


#define ERRLEVEL	(APLOG_ERR|APLOG_NOERRNO)
#define DEBUGLEVEL	(APLOG_INFO|APLOG_NOERRNO)

// SQL Drivers

#ifdef NEED_POSTGRES
extern int PgSetup( accounting_state *cfg );
extern int PgQuery( accounting_state *cfg, server_rec *server, pool *p, char *query );
extern void PgClose( accounting_state *cfg );
#endif

#ifdef NEED_MYSQL
extern int MySetup( accounting_state *cfg );
extern int MyQuery( accounting_state *cfg, server_rec *server, pool *p, char *query );
extern void MyClose( accounting_state *cfg );
#endif

#endif /* MOD_ACCOUNTING_H */
