//
// testopt.cpp
// Simple regression testing for libcppopt
//
// Copyright 2001 Zed C. Pobre
// Licensed to the public under the terms of the GNU GPL
//

#include <iostream>
#include <string>
#include <cppopt.h>

int main(int argc, char **argv)
{
    using namespace std;
    using namespace cppopt;

    cppopt::Options options;
    cppopt::Options options1;
    cppopt::Options options2;
    string stringtest1 = " 	preopt1		preopt2  -a1  --long all one option -b 2 -- end of string ";
/*
    int testargc;
    char **testargv = 
    {
    	"preopt1",
	"preopt2",
	"preopt3 	preopt4",
	"-a1",
	"--long1",
	"long1arg",
	"--long2",
	"long2arg all one argument",
	"-b",
	"2",
	"-c",
	"--",
	"end",
	"of",
	"string"
    };
*/
    int retval = 0;

    if(argc > 1)
    {
	options = parse(argc,argv);
	options.listall();
	if(options.haspreopt()) cout << "Has preopts" << endl;
	else cout << "Has no preopts" << endl;
	if(options.haspreopt("qwer")) cout << "Has preopt 'qwer'" << endl;
	else cout << "Has no preopt 'qwer'" << endl;
	if(options.hasshortopt()) cout << "Has shortopts" << endl;
	else cout << "Has no shortopts" << endl;
	if(options.hasshortopt('w')) cout << "Has shortopt 'w'" << endl;
	else cout << "Has no shortopt 'w'" << endl;
	if(options.haslongopt()) cout << "Has longopts" << endl;
	else cout << "Has no longopts" << endl;
	if(options.haslongopt("qwer")) cout << "Has longopt '--qwer'" << endl;
	else cout << "Has no longopt '--qwer'" << endl;
	if(options.hastarget()) cout << "Has targets" << endl;
	else cout << "Has no targets" << endl;
	if(options.hastarget("qwer")) cout << "Has target 'qwer'" << endl;
	else cout << "Has no target 'qwer'" << endl;
	if(options.haspostopt()) cout << "Has postopts" << endl;
	else cout << "Has no postopts" << endl;
    }

    cout << "==================================================" << endl;
    cout << "Testing parse(stringtest1):" << endl;
    cout << "stringtest1 = \"" << stringtest1 << "\"" << endl;
    options1 = parse(stringtest1);
    if(options1.haspreopt()) cout << "haspreopt(): PASS" << endl;
    else 
    {
	cout << "haspreopt(): FAIL" << endl;
	retval = 1;
    }
    if(options1.haspreopt("preopt1")) cout << "haspreopt(\"preopt1\"): PASS" << endl;
    else
    {
	cout << "haspreopt(\"preopt1\"): FAIL" << endl;
	retval = 1;
    }
    if(options1.haspreopt("preopt2")) cout << "haspreopt(\"preopt2\"): PASS" << endl;
    else
    {
	cout << "haspreopt(\"preopt2\"): FAIL" << endl;
	retval = 1;
    }

    if(!options1.haspreopt("notapreopt")) cout << "haspreopt(\"notapreopt\"): PASS" << endl;
    else
    {
	cout << "haspreopt(\"notapreopt\"): FAIL" << endl;
	retval = 1;
    }

    if(options1.hasshortopt()) cout << "hasshortopt(): PASS" << endl;
    else
    {
	cout << "hasshortopt(): FAIL" << endl;
	retval = 1;
    }

    if(options1.hasshortopt('a')) cout << "hasshortopt(\'a\'): PASS" << endl;
    else
    {
	cout << "hasshortopt(\'a\'): FAIL" << endl;
	retval = 1;
    }

    if(options1.hasshortopt('1')) cout << "hasshortopt(\'1\'): PASS" << endl;
    else
    {
	cout << "hasshortopt(\'1\'): FAIL" << endl;
	retval = 1;
    }

    if(!options1.hasshortopt('z')) cout << "hasshortopt(\'z\'): PASS" << endl;
    else
    {
	cout << "hasshortopt(\'z\'): FAIL" << endl;
	retval = 1;
    }

    if(options1.haslongopt ()) cout << "haslongopt(): PASS" << endl;
    else
    {
	cout << "haslongopt(): FAIL" << endl;
	retval = 1;
    }

    if(options1.haslongopt ("long")) cout << "haslongopt(\"long\"): PASS" << endl;
    else
    {
	cout << "haslongopt(\"long\"): FAIL" << endl;
	retval = 1;
    }

    if(!options1.haslongopt ("notalongopt"))
	cout << "haslongopt(\"notalongopt\"): PASS" << endl;
    else
    {
	cout << "haslongopt(\"notalongopt\"): FAIL" << endl;
	retval = 1;
    }

    cout << endl;
    options1.listall();
    return retval;
}
