// This file may be redistributed and modified only under the terms of
// the GNU Lesser General Public License (See COPYING for details).
// Copyright 2000-2001 Stefanus Du Toit and Alistair Riddoch.
// Automatically generated using gen_cc.py.

#include <Atlas/Objects/Entity/RootEntity.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Entity { 

RootEntity::RootEntity()
     : Root("", "root_entity"), attr_stamp_contains(0.0)
{
    setObjtype(std::string("object"));
    Element::ListType pos;
    pos.push_back(0.0);
    pos.push_back(0.0);
    pos.push_back(0.0);
    setPos(pos);
    Element::ListType velocity;
    velocity.push_back(0.0);
    velocity.push_back(0.0);
    velocity.push_back(0.0);
    setVelocity(velocity);
}

RootEntity::RootEntity(const char * id, const char * parent)
     : Root(id, parent), attr_stamp_contains(0.0)
{
    setObjtype(std::string("object"));
    Element::ListType pos;
    pos.push_back(0.0);
    pos.push_back(0.0);
    pos.push_back(0.0);
    setPos(pos);
    Element::ListType velocity;
    velocity.push_back(0.0);
    velocity.push_back(0.0);
    velocity.push_back(0.0);
    setVelocity(velocity);
}

RootEntity::~RootEntity()
{
}

RootEntity RootEntity::Class()
{
    RootEntity value("root_entity", "root");

    value.setObjtype(std::string("class"));
    
    return value;
}

bool RootEntity::hasAttr(const std::string& name) const
{
    if (name == "loc") return true;
    if (name == "pos") return true;
    if (name == "velocity") return true;
    if (name == "contains") return true;
    if (name == "stamp_contains") return true;
    return Root::hasAttr(name);
}

Element RootEntity::getAttr(const std::string& name) const
    throw (NoSuchAttrException)
{
    if (name == "loc") return attr_loc;
    if (name == "pos") return attr_pos;
    if (name == "velocity") return attr_velocity;
    if (name == "contains") return attr_contains;
    if (name == "stamp_contains") return attr_stamp_contains;
    return Root::getAttr(name);
}

void RootEntity::setAttr(const std::string& name, const Element& attr)
{
    if (name == "loc") { setLoc(attr.asString()); return; }
    if (name == "pos") { setPos(attr.asList()); return; }
    if (name == "velocity") { setVelocity(attr.asList()); return; }
    if (name == "contains") { setContains(attr.asList()); return; }
    if (name == "stamp_contains") { setStampContains(attr.asFloat()); return; }
    Root::setAttr(name, attr);
}

void RootEntity::removeAttr(const std::string& name)
{
    if (name == "loc") return;
    if (name == "pos") return;
    if (name == "velocity") return;
    if (name == "contains") return;
    if (name == "stamp_contains") return;
    Root::removeAttr(name);
}

void RootEntity::sendLoc(Atlas::Bridge* b) const
{
    if (!attr_loc.empty()) {
        b->mapItem("loc", attr_loc);
    }
}

void RootEntity::sendPos(Atlas::Bridge* b) const
{
    if (!attr_pos.empty()) {
        Atlas::Message::Encoder e(b);
        e.mapItem("pos", attr_pos);
    }
}

void RootEntity::sendVelocity(Atlas::Bridge* b) const
{
    if (!attr_velocity.empty()) {
        Atlas::Message::Encoder e(b);
        e.mapItem("velocity", attr_velocity);
    }
}

void RootEntity::sendContains(Atlas::Bridge* b) const
{
    if (!attr_contains.empty()) {
        Atlas::Message::Encoder e(b);
        e.mapItem("contains", attr_contains);
    }
}

void RootEntity::sendStampContains(Atlas::Bridge* b) const
{
    if (attr_stamp_contains != 0.0) {
        b->mapItem("stamp_contains", attr_stamp_contains);
    }
}

void RootEntity::sendContents(Bridge* b) const
{
    sendLoc(b);
    sendPos(b);
    sendVelocity(b);
    sendContains(b);
    sendStampContains(b);
    Root::sendContents(b);
}

Element RootEntity::asObject() const
{
    Element::MapType m = Root::asObject().asMap();
    m["loc"] = Element(attr_loc);
    m["pos"] = Element(attr_pos);
    m["velocity"] = Element(attr_velocity);
    m["contains"] = Element(attr_contains);
    m["stamp_contains"] = Element(attr_stamp_contains);
    return Element(m);
}

Element::MapType RootEntity::asMap() const
{
    Element::MapType m = Root::asObject().asMap();
    m["loc"] = Element(attr_loc);
    m["pos"] = Element(attr_pos);
    m["velocity"] = Element(attr_velocity);
    m["contains"] = Element(attr_contains);
    m["stamp_contains"] = Element(attr_stamp_contains);
    return m;
}

} } } // namespace Atlas::Objects::Entity

#include <Atlas/Objects/Entity/AdminEntity.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Entity { 

AdminEntity::AdminEntity()
     : RootEntity("", "admin_entity")
{
}

AdminEntity::AdminEntity(const char * id, const char * parent)
     : RootEntity(id, parent)
{
}

AdminEntity::~AdminEntity()
{
}

AdminEntity AdminEntity::Class()
{
    AdminEntity value("admin_entity", "root_entity");

    value.setObjtype(std::string("class"));
    
    return value;
}

} } } // namespace Atlas::Objects::Entity

#include <Atlas/Objects/Entity/Account.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Entity { 

Account::Account()
     : AdminEntity("", "account")
{
}

Account::Account(const char * id, const char * parent)
     : AdminEntity(id, parent)
{
}

Account::~Account()
{
}

Account Account::Class()
{
    Account value("account", "admin_entity");

    value.setObjtype(std::string("class"));
    
    return value;
}

bool Account::hasAttr(const std::string& name) const
{
    if (name == "password") return true;
    return AdminEntity::hasAttr(name);
}

Element Account::getAttr(const std::string& name) const
    throw (NoSuchAttrException)
{
    if (name == "password") return attr_password;
    return AdminEntity::getAttr(name);
}

void Account::setAttr(const std::string& name, const Element& attr)
{
    if (name == "password") { setPassword(attr.asString()); return; }
    AdminEntity::setAttr(name, attr);
}

void Account::removeAttr(const std::string& name)
{
    if (name == "password") return;
    AdminEntity::removeAttr(name);
}

void Account::sendPassword(Atlas::Bridge* b) const
{
    if (!attr_password.empty()) {
        b->mapItem("password", attr_password);
    }
}

void Account::sendContents(Bridge* b) const
{
    sendPassword(b);
    AdminEntity::sendContents(b);
}

Element Account::asObject() const
{
    Element::MapType m = AdminEntity::asObject().asMap();
    m["password"] = Element(attr_password);
    return Element(m);
}

Element::MapType Account::asMap() const
{
    Element::MapType m = AdminEntity::asObject().asMap();
    m["password"] = Element(attr_password);
    return m;
}

} } } // namespace Atlas::Objects::Entity

#include <Atlas/Objects/Entity/Player.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Entity { 

Player::Player()
     : Account("", "player")
{
}

Player::Player(const char * id, const char * parent)
     : Account(id, parent)
{
}

Player::~Player()
{
}

Player Player::Class()
{
    Player value("player", "account");

    value.setObjtype(std::string("class"));
    
    return value;
}

bool Player::hasAttr(const std::string& name) const
{
    if (name == "characters") return true;
    return Account::hasAttr(name);
}

Element Player::getAttr(const std::string& name) const
    throw (NoSuchAttrException)
{
    if (name == "characters") return attr_characters;
    return Account::getAttr(name);
}

void Player::setAttr(const std::string& name, const Element& attr)
{
    if (name == "characters") { setCharacters(attr.asList()); return; }
    Account::setAttr(name, attr);
}

void Player::removeAttr(const std::string& name)
{
    if (name == "characters") return;
    Account::removeAttr(name);
}

void Player::sendCharacters(Atlas::Bridge* b) const
{
    if (!attr_characters.empty()) {
        Atlas::Message::Encoder e(b);
        e.mapItem("characters", attr_characters);
    }
}

void Player::sendContents(Bridge* b) const
{
    sendCharacters(b);
    Account::sendContents(b);
}

Element Player::asObject() const
{
    Element::MapType m = Account::asObject().asMap();
    m["characters"] = Element(attr_characters);
    return Element(m);
}

Element::MapType Player::asMap() const
{
    Element::MapType m = Account::asObject().asMap();
    m["characters"] = Element(attr_characters);
    return m;
}

} } } // namespace Atlas::Objects::Entity

#include <Atlas/Objects/Entity/Admin.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Entity { 

Admin::Admin()
     : Account("", "admin")
{
}

Admin::Admin(const char * id, const char * parent)
     : Account(id, parent)
{
}

Admin::~Admin()
{
}

Admin Admin::Class()
{
    Admin value("admin", "account");

    value.setObjtype(std::string("class"));
    
    return value;
}

} } } // namespace Atlas::Objects::Entity

#include <Atlas/Objects/Entity/Game.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Entity { 

Game::Game()
     : AdminEntity("", "game")
{
}

Game::Game(const char * id, const char * parent)
     : AdminEntity(id, parent)
{
}

Game::~Game()
{
}

Game Game::Class()
{
    Game value("game", "admin_entity");

    value.setObjtype(std::string("class"));
    
    return value;
}

} } } // namespace Atlas::Objects::Entity

#include <Atlas/Objects/Entity/GameEntity.h>

using Atlas::Message::Element;

namespace Atlas { namespace Objects { namespace Entity { 

GameEntity::GameEntity()
     : RootEntity("", "game_entity")
{
}

GameEntity::GameEntity(const char * id, const char * parent)
     : RootEntity(id, parent)
{
}

GameEntity::~GameEntity()
{
}

GameEntity GameEntity::Class()
{
    GameEntity value("game_entity", "root_entity");

    value.setObjtype(std::string("class"));
    
    return value;
}

} } } // namespace Atlas::Objects::Entity

