.\" $Id: dhcp-fwd.man,v 1.6 2004/06/16 10:51:02 ensc Exp $
.\" Copyright (C) 2002 Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de>
.\"  
.\" Permission is granted to make and distribute verbatim copies of
.\" this manual provided the copyright notice and this permission notice
.\" are preserved on all copies.
.\"  
.\" Permission is granted to process this file through TeX and print the
.\" results, provided the printed document carries copying permission
.\" notice identical to this one except for the removal of this paragraph
.\" (this paragraph not being relevant to the printed manual).
.\"  
.\" Permission is granted to copy and distribute modified versions of this
.\" manual under the conditions for verbatim copying, provided that the
.\" entire resulting derived work is distributed under the terms of a 
.\" permission notice identical to this one.
.\"  
.\" Permission is granted to copy and distribute translations of this manual
.\" into another language, under the above conditions for modified versions,
.\" except that this permission notice may be stated in a translation
.\" approved by the Free Software Foundation
.\"  
.TH dhcp-fwd 1 "June 14 2002" "@PACKAGE@ 0.6"
.\"
.\" ====================
.\"
.SH NAME
.PP
dhcp-fwd \- starts the DHCP forwarding agent
.\"
.\" ====================
.\"
.SH SYNOPSIS
.B  dhcp-fwd
.RB [ \-n ]
.RB [ \-d ]
.RB [ \-v ]
.RB [ \-h ]
.RB [ \-c
.IR config_file ]
.\"
.\" ====================
.\"
.SH DESCRIPTION
.B dhcp-fwd
starts a DHCP forwarding agents which relays DHCP messages between
subnets with different sublayer broadcast domains.

When called without arguments, it reads its configuration from
.BR @sysconfdir@/dhcp-fwd.cfg
and forks itself into background. An alternative configfile
can be given by the
.BR \-c
option; the forking can be prevented with the
.BR \-n
switch. There exists a
.BR \-d
option which is indented for debugging purposes and prevents forking
too. Currently it is just an alias for
.BR \-n .

Although the program must be started as root, it will drop its
privileges and go into a chroot-jail after finishing the
initialization.
.\"
.\" ====================
.\"
.SH OPTIONS
.TP
.B \-n
Prevents daemon from going into background after initialization. This
option may be useful when using advanced init-concepts like minit
(http://www.fefe.de/minit/).
.TP
.B \-d
Turns on debugging mode and prevents forking; currently it is just an
alias for \fB\-n\fR.
.TP
.B \-c \fI config_file
Specifies the configfile to use; the default is
.BR @sysconfdir@/dhcp-fwd.cfg .
.TP
.B \-v
Shows version
.TP
.B \-h
Shows help
.\"
.\" ====================
.\"
.SH "CONFIGURATION FILE"
The default location of the configfile is determined at
compilation-time and can be overridden by using the
.BR \-c
option. When an option needs a boolean parameter, the keywords true,
false, 0, 1, yes and no are possible values.

Within the configfile the following options MUST be set:
.\"
.TP
.B user \fIusername|uid
The program
.B setuid()\fR's
to the given user after finishing its initialization. The parameter
must be an alphanumeric username or a numeric uid.
.\"
.TP
.B group \fIgroupname|gid
The program
.B setgid()\fR's
to the given group after finishing its initialization. The parameter
must be an alphanumeric groupname or a numeric gid.
.\"
.TP
.B chroot \fIpath
The program goes into this directory and calls there
.B chroot()
after finishing its initialization.
.TP
.B pidfile \fIfilename
The file where the pid of the daemon will be written into.
.\"
.\" ----
.\"
.PP
Beside the mandatory options above, the following options are
possible:
.TP
.B ulimit \fIresource limit
Sets a maximum \fIlimit\fR for the given \fIresource\fR by calling
\fBsetrlimit()\fR appropriately. Possible values for \fIresource\fR
are
.B stack\fR,
.B data\fR,
.B core\fR,
.B rss\fR,
.B nproc\fR,
.B nofile\fR,
.B memlock\fR,
.B as
and (if supported by your OS)
.B locks\fR.
For the meaning of this values see setrlimit(2).

\fIlimit\fR may be plain unsigned number, a number followed by 'k'
(*1000), 'K' (*1024), 'm' (*1000k), 'M' (*1024K) or '-1' to
remove the limit for this resource.
.TP
.B logfile \fIfilename
Specifies the file where messages will be stored. This file is located
relatively to the directory where dhcp-fwd was started and \fBnot\fR
to the directory given at the \fIchroot\fR option.
.\"
.\" ----
.\"
.TP
.B if \fIifname has_clients has_servers allow_bcast
Declares an interface and sets parameter of the network topology. When
an interfacename is used in one of the other options, it must have
been declared by
.B if
already.

.I ifname
is the name of the interface as being used e.g. by
.B ifconfig
also (e.g. eth0).

.I has_clients \fRand \fIhas_servers
tell if messages from clients or servers can be expected on this interface.
.B BOOTREQUEST\fRs are assumed to be client- and
.B BOOTREPLY\fRs are assumed to be server-messages. Unexpected packages will
be dropped away.

.I allow_bcast
is/was an experimentell features and will be disappear probably. When not
set, the interface will not send packages to IP-broadcast addresses. This
affects messages to clients only; when specifying a bcast-server, this
option will be ignored.
.\"
.TP
.B name \fIifname agent-id
specifies the RFC 3046 agent-id for the given interface. When not used
explicitly, the interfacename will be assumed as the agent-id.
.\"
.TP
.B ip \fIifname ip
assigns the
.I ip
to be used in the \fIgiaddr \fRfield. By default to IP of the
interface will be assumed but when having multiple IPs for one
interface this option may be usefully.

.B Attention:
.\"
This IP will not be used in the IP-layer; this means
that the UDP packet sent to the server will contain the IP assigned by
the system. To setup \fBthis\fR address, usual SNAT rulesets in a local
packetfilter are recommended.
.\"
.TP
.B server \fItype info
Defines the DHCP server to be used. The following types are supported:
.RS
.TP
.B server ip \fIaddress\fR [\fIinterface\fR]
\fIaddress\fR is a dotted IP-address and the optional \fIinterface\fR
the name of an interface. Please note that mixing declarations without
an \fIinterface\fR parameter and such ones with this parameter will
fail.
.TP
.B server bcast \fIinterface
the DHCP server with be assumed at interface \fIinterface\fR and
contacted with broadcast messages.
.RE

For an example see the contrib/dhcp-fwd.conf file in the
source-tarball.
.\"
.\" ====================
.\"
.SH FILES
.TP
.B @sysconfdir@/dhcp-fwd.conf
configuration file
.TP
.B @sbindir@/dhcp-fwd
executable
.\"
.\" ====================
.\"
.SH "SEE ALSO"
RFC 2131, 2132, 3046
.\"
.\" ====================
.\"
.SH AUTHOR
Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de>
