/*
    Copyright 2005, Broadcom Corporation      
    All Rights Reserved.      
          
    THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY      
    KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM      
    SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS      
    FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.      

    This file was automatically generated by xml2c.pl
*/


#include "upnp_dbg.h"
#include "upnp_osl.h"
#include "upnp.h"
#include "wanppp.h"

/* 

    Below you will find definitions for a number of Action structures.
    The second argument to those structures is a pointer to a function
    that implements that action.  Your job is to define all of the
    actions so that none of them is left unimplemented.

    As a convenience, all generated actions have been predefined to
    invoke the action 'NotImplemented', an action that will print an
    error message whenever it is invoked.  As you define functions for
    each action, be sure to remove that function name from the list of
    'NotImplemented' defines in the list below.
    
    The following are pre-defined action functions that you can use:

    NotImplemented - prints an error message on the console 
                     and returns 0 parameters to the caller.

    DefaultAction  - Returns all 'out' parameters with values
                     taken from the corresponding 'relatedStateVariable'.
                     This function actually covers the behavior of 
                     a surprisingly large number of UPnP actions.

*/

extern int WANPPPConnection_ConfigureConnection(UFILE *uclient, PService psvc, PAction ac, pvar_entry_t args, int nargs);
extern int WANPPPConnection_SetIdleDisconnectTime(UFILE *uclient, PService psvc, PAction ac, pvar_entry_t args, int nargs);
extern int WANPPPConnection_RequestConnection(UFILE *uclient, PService psvc, PAction ac, pvar_entry_t args, int nargs);
extern int WANPPPConnection_ForceTermination(UFILE *uclient, PService psvc, PAction ac, pvar_entry_t args, int nargs);
extern int WANPPPConnection_SetConnectionType(UFILE *uclient, PService psvc, PAction ac, pvar_entry_t args, int nargs);
extern int GetGenericPortMappingEntry(UFILE *, PService , PAction, pvar_entry_t , int );
extern int GetSpecificPortMappingEntry(UFILE *, PService , PAction, pvar_entry_t , int);
extern int AddPortMapping(UFILE *, PService, PAction, pvar_entry_t, int);
extern int DeletePortMapping(UFILE *, PService, PAction, pvar_entry_t, int);

#define GetConnectionTypeInfo DefaultAction
#define GetLinkLayerMaxBitRates DefaultAction
#define GetNATRSIPStatus DefaultAction
#define GetUserName DefaultAction
#define GetPassword DefaultAction
#define GetStatusInfo DefaultAction
#define GetIdleDisconnectTime DefaultAction
#define GetExternalIPAddress DefaultAction

/* VAR_ offsets are include from wanppp.h */


char *WANPPPConnection_PossibleConnectionTypes_allowedValueList[] = { "Unconfigured", "IP_Routed", "DHCP_Spoofed", "PPPOE_Bridged", "PPTP_Relay", "L2TP_Relay", "PPOE_Relay", NULL };
static char *ConnectionStatus_allowedValueList[] = { "Unconfigured", "Connecting", "Authenticating", "Connected", "PendingDisconnect", "Disconnecting", "Disconnected", NULL };
static char *LastConnectionError_allowedValueList[] = { "ERROR_NONE", "ERROR_UNKNOWN", NULL };
static char *PortMappingProtocol_allowedValueList[] = { "TCP", "UDP", NULL };


static VarTemplate StateVariables[] = {
    { "ConnectionType", "IP_Routed", VAR_STRING|VAR_LIST,  (allowedValue) { WANPPPConnection_PossibleConnectionTypes_allowedValueList }  },
    { "PossibleConnectionTypes", "", VAR_EVENTED|VAR_STRING|VAR_LIST,  (allowedValue) { WANPPPConnection_PossibleConnectionTypes_allowedValueList } },
    { "ConnectionStatus", "Unconfigured", VAR_EVENTED|VAR_STRING|VAR_LIST,  (allowedValue) { ConnectionStatus_allowedValueList } },
    { "Uptime", "", VAR_ULONG },
    { "UpstreamMaxBitRate", "10000000", VAR_ULONG },
    { "DownstreamMaxBitRate", "10000000", VAR_ULONG },
    { "LastConnectionError", "", VAR_STRING|VAR_LIST,  (allowedValue) { LastConnectionError_allowedValueList } },
    { "IdleDisconnectTime", "", VAR_ULONG },
    { "RSIPAvailable", "0", VAR_BOOL },
    { "NATEnabled", "0", VAR_BOOL },
    { "UserName", "", VAR_STRING },
    { "Password", "", VAR_STRING },
    { "ExternalIPAddress", "", VAR_EVENTED|VAR_STRING },
    { "PortMappingNumberOfEntries", "", VAR_EVENTED|VAR_USHORT },
    { "PortMappingEnabled", "", VAR_BOOL },
    { "PortMappingLeaseDuration", "", VAR_ULONG },
    { "RemoteHost", "", VAR_STRING },
    { "ExternalPort", "", VAR_USHORT },
    { "InternalPort", "", VAR_USHORT },
    { "PortMappingProtocol", "", VAR_STRING|VAR_LIST,  (allowedValue) { PortMappingProtocol_allowedValueList } },
    { "InternalClient", "", VAR_STRING },
    { "PortMappingDescription", "", VAR_STRING },

    { NULL }
};


static Action _SetConnectionType = {
    "SetConnectionType", WANPPPConnection_SetConnectionType,
   (Param []) {
       {"NewConnectionType", VAR_ConnectionType, VAR_IN},
       { 0 }
    }
};

static Action _GetConnectionTypeInfo = {
    "GetConnectionTypeInfo", GetConnectionTypeInfo,
   (Param []) {
       {"NewConnectionType", VAR_ConnectionType, VAR_OUT},
       {"NewPossibleConnectionTypes", VAR_PossibleConnectionTypes, VAR_OUT},
       { 0 }
    }
};

static Action _ConfigureConnection = {
    "ConfigureConnection", WANPPPConnection_ConfigureConnection,
   (Param []) {
       {"NewUserName", VAR_UserName, VAR_IN},
       {"NewPassword", VAR_Password, VAR_IN},
       { 0 }
    }
};

static Action _RequestConnection = {
    "RequestConnection", WANPPPConnection_RequestConnection,
   (Param []) {
       { 0 }
    }
};

static Action _ForceTermination = {
    "ForceTermination", WANPPPConnection_ForceTermination,
   (Param []) {
       { 0 }
    }
};

static Action _SetIdleDisconnectTime = {
    "SetIdleDisconnectTime", WANPPPConnection_SetIdleDisconnectTime,
   (Param []) {
       {"NewIdleDisconnectTime", VAR_IdleDisconnectTime, VAR_IN},
       { 0 }
    }
};

static Action _GetStatusInfo = {
    "GetStatusInfo", GetStatusInfo,
   (Param []) {
       {"NewConnectionStatus", VAR_ConnectionStatus, VAR_OUT},
       {"NewLastConnectionError", VAR_LastConnectionError, VAR_OUT},
       {"NewUptime", VAR_Uptime, VAR_OUT},
       { 0 }
    }
};

static Action _GetLinkLayerMaxBitRates = {
    "GetLinkLayerMaxBitRates", GetLinkLayerMaxBitRates,
   (Param []) {
       {"NewUpstreamMaxBitRate", VAR_UpstreamMaxBitRate, VAR_OUT},
       {"NewDownstreamMaxBitRate", VAR_DownstreamMaxBitRate, VAR_OUT},
       { 0 }
    }
};

static Action _GetUserName = {
    "GetUserName", GetUserName,
   (Param []) {
       {"NewUserName", VAR_UserName, VAR_OUT},
       { 0 }
    }
};

static Action _GetPassword = {
    "GetPassword", GetPassword,
   (Param []) {
       {"NewPassword", VAR_Password, VAR_OUT},
       { 0 }
    }
};

static Action _GetIdleDisconnectTime = {
    "GetIdleDisconnectTime", GetIdleDisconnectTime,
   (Param []) {
       {"NewIdleDisconnectTime", VAR_IdleDisconnectTime, VAR_OUT},
       { 0 }
    }
};

static Action _GetNATRSIPStatus = {
    "GetNATRSIPStatus", GetNATRSIPStatus,
   (Param []) {
       {"NewRSIPAvailable", VAR_RSIPAvailable, VAR_OUT},
       {"NewNATEnabled", VAR_NATEnabled, VAR_OUT},
       { 0 }
    }
};

static Action _GetGenericPortMappingEntry = {
    "GetGenericPortMappingEntry", GetGenericPortMappingEntry,
   (Param []) {
       {"NewPortMappingIndex", VAR_PortMappingNumberOfEntries, VAR_IN},
       {"NewRemoteHost", VAR_RemoteHost, VAR_OUT},
       {"NewExternalPort", VAR_ExternalPort, VAR_OUT},
       {"NewProtocol", VAR_PortMappingProtocol, VAR_OUT},
       {"NewInternalPort", VAR_InternalPort, VAR_OUT},
       {"NewInternalClient", VAR_InternalClient, VAR_OUT},
       {"NewEnabled", VAR_PortMappingEnabled, VAR_OUT},
       {"NewPortMappingDescription", VAR_PortMappingDescription, VAR_OUT},
       {"NewLeaseDuration", VAR_PortMappingLeaseDuration, VAR_OUT},
       { 0 }
    }
};

static Action _GetSpecificPortMappingEntry = {
    "GetSpecificPortMappingEntry", GetSpecificPortMappingEntry,
   (Param []) {
       {"NewRemoteHost", VAR_RemoteHost, VAR_IN},
       {"NewExternalPort", VAR_ExternalPort, VAR_IN},
       {"NewProtocol", VAR_PortMappingProtocol, VAR_IN},
       {"NewInternalPort", VAR_InternalPort, VAR_OUT},
       {"NewInternalClient", VAR_InternalClient, VAR_OUT},
       {"NewEnabled", VAR_PortMappingEnabled, VAR_OUT},
       {"NewPortMappingDescription", VAR_PortMappingDescription, VAR_OUT},
       {"NewLeaseDuration", VAR_PortMappingLeaseDuration, VAR_OUT},
       { 0 }
    }
};

static Action _AddPortMapping = {
    "AddPortMapping", AddPortMapping,
   (Param []) {
       {"NewRemoteHost", VAR_RemoteHost, VAR_IN},
       {"NewExternalPort", VAR_ExternalPort, VAR_IN},
       {"NewProtocol", VAR_PortMappingProtocol, VAR_IN},
       {"NewInternalPort", VAR_InternalPort, VAR_IN},
       {"NewInternalClient", VAR_InternalClient, VAR_IN},
       {"NewEnabled", VAR_PortMappingEnabled, VAR_IN},
       {"NewPortMappingDescription", VAR_PortMappingDescription, VAR_IN},
       {"NewLeaseDuration", VAR_PortMappingLeaseDuration, VAR_IN},
       { 0 }
    }
};

static Action _DeletePortMapping = {
    "DeletePortMapping", DeletePortMapping,
   (Param []) {
       {"NewRemoteHost", VAR_RemoteHost, VAR_IN},
       {"NewExternalPort", VAR_ExternalPort, VAR_IN},
       {"NewProtocol", VAR_PortMappingProtocol, VAR_IN},
       { 0 }
    }
};

static Action _GetExternalIPAddress = {
    "GetExternalIPAddress", GetExternalIPAddress,
   (Param []) {
       {"NewExternalIPAddress", VAR_ExternalIPAddress, VAR_OUT},
       { 0 }
    }
};



static PAction Actions[] = {
    &_SetConnectionType,
    &_GetConnectionTypeInfo,
    &_ConfigureConnection,
    &_RequestConnection,
    &_ForceTermination,
    &_SetIdleDisconnectTime,
    &_GetStatusInfo,
    &_GetLinkLayerMaxBitRates,
    &_GetUserName,
    &_GetPassword,
    &_GetIdleDisconnectTime,
    &_GetNATRSIPStatus,
    &_GetGenericPortMappingEntry,
    &_GetSpecificPortMappingEntry,
    &_AddPortMapping,
    &_DeletePortMapping,
    &_GetExternalIPAddress,
    NULL
};

ServiceTemplate Template_WANPPPConnection = {
    "WANPPPConnection:1",	/* name of service */
    NULL,		/* PFSVCINIT service initialization function */
    WANPPPConnection_GetVar,		/* PFGETVAR get service state variable function */
    NULL,		/* SVCXML service XML generation function (not used) */
    ARRAYSIZE(StateVariables)-1, /* number of state variables */
    StateVariables,     /* pointer to list of state variables */
    Actions,             /* pointer to list of actions */
    0,			/* count */
    "urn:upnp-org:serviceId:WANPPPConn",	/* service id */
    NULL		/* schema */
};
