#include <httpd.h>
#include <typedefs.h>
#include <bcmnvram.h>
#include <bcmutils.h>
#include <shutils.h>
#include <code_pattern.h>
#include <cy_conf.h>
#include <utils.h>
#include <syslog.h>
#include <bcmcvar.h> //Added by Daniel(2004-07-29) for EZC
#include <sveasoft.h>

#define sys_restart() kill(1, SIGHUP)
#define sys_reboot() kill(1, SIGTERM)
#define sys_stats(url) eval("stats", (url))
#define ARGV(args...) ((char *[]) { args, NULL })
#define STRUCT_LEN(name)    sizeof(name)/sizeof(name[0])
#define GOZILA_GET(name)	gozila_action ? websGetVar(wp, name, NULL) : nvram_safe_get(name);

#define SWAP(AA,BB)  { \
	char *CC; \
	CC = AA; \
	AA = BB; \
	BB = CC; \
}

/* for dhcp */
#define MAX_LEASES 254

/* for filter */
#define FILTER_IP_NUM 5
#define FILTER_PORT_NUM 5
#define FILTER_MAC_NUM 10
#define FILTER_MAC_PAGE 5
#define BLOCKED_SERVICE_NUM 5

/* for forward */
//#define FORWARDING_NUM 60
#define SPECIAL_FORWARDING_NUM 30
#define UPNP_FORWARDING_NUM 30
//#define PORT_TRIGGER_NUM 50

/* for static route */
#define STATIC_ROUTE_PAGE 20

/* for wireless */
#define WL_FILTER_MAC_PAGE 2
#define WL_FILTER_MAC_NUM 64
//#define WL_FILTER_MAC_COUNT 32

#define MAC_LEN 17
#define TMP_PASSWD "d6nw5v1x2pc7st9m"

#define USE_LAN 1
#define USE_WAN 2

extern int gozila_action;
extern int error_value;
extern int debug_value;
extern int filter_id;
extern int generate_key;
extern int clone_wan_mac;
extern char http_client_ip[20];
extern int lan_ip_changed;

/*
struct variable {
	char *name;
	char *longname;
	void (*validate)(webs_t wp, char *value, struct variable *v);
	char **argv;
	int nullok;
};
*/

struct onload {
        char *name;
        int (*go)(webs_t wp, char *arg);
};

struct lease_t {
	unsigned char chaddr[16];
	u_int32_t yiaddr;
	u_int32_t expires;
	char hostname[64];
};

struct apply_action {
	char *name;
	char *service;
	int sleep_time;
	int action;
        int (*go)(webs_t wp);
};

struct gozila_action {
	char *name;
	char *type;
	char *service;
	int sleep_time;
	int action;
        int (*go)(webs_t wp);
};

enum {SET, GET};

enum {	// return code
	START_FROM = 10,
     };

/* SEG addition for dynamic nvram layout */
extern void Initnvramtab(void); 

/* for index */
extern int ej_show_index_setting(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_compile_date(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_compile_time(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_wl_max_channel(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_wl_domain(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_clone_mac(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_show_wan_domain(int eid, webs_t wp, int argc, char_t **argv);
extern void validate_ntp(webs_t wp, char *value, struct variable *v);
extern void validate_lan_ipaddr(webs_t wp, char *value, struct variable *v);
extern void validate_wan_ipaddr(webs_t wp, char *value, struct variable *v);
extern int clone_mac(webs_t wp);
extern int dhcpfwd(webs_t wp);

/* for status */


extern int ej_show_paypal(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_show_status(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_localtime(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_nvram_status_get(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_nvram_get_len(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_dhcp_remaining_time(int eid, webs_t wp, int argc, char_t **argv);
extern int dhcp_renew(webs_t wp);
extern int dhcp_release(webs_t wp);
extern int stop_ppp(webs_t wp);
extern int ej_show_status_setting(int eid, webs_t wp, int argc, char_t **argv);


/*for dhcp */
extern int ej_dumpleases(int eid, webs_t wp, int argc, char_t **argv);
extern void validate_dhcp(webs_t wp, char *value, struct variable *v);
extern void dhcp_check(webs_t wp, char *value, struct variable *v);
extern int delete_leases(webs_t wp);

/* for log */
extern int ej_dumplog(int eid, webs_t wp, int argc, char_t **argv);
extern int log_onload(webs_t wp);
extern int filtersummary_onload(webs_t wp, char *arg);

/* for upgrade */
extern void do_upgrade_post(char *url, webs_t stream, int len, char *boundary);
extern void do_upgrade_cgi(char *url,  webs_t stream);

extern int sys_restore(char *url, webs_t stream, int *total);
extern void do_restore_post(char *url, webs_t stream, int len, char *boundary);
extern void do_restore_cgi(char *url,  webs_t stream);

extern int macclone_onload(webs_t wp, char *arg);
/* for filter */
extern int ej_filter_init(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_filter_summary_show(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_filter_ip_get(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_filter_port_get(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_filter_dport_get(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_filter_mac_get(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_filter_policy_select(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_filter_policy_get(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_filter_tod_get(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_filter_web_get(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_filter_port_services_get(int eid, webs_t wp, int argc, char_t **argv);
extern void validate_filter_policy(webs_t wp, char *value, struct variable *v);
extern void validate_filter_ip_grp(webs_t wp, char *value, struct variable *v);
extern void validate_filter_mac_grp(webs_t wp, char *value, struct variable *v);
extern void validate_filter_dport_grp(webs_t wp, char *value, struct variable *v);
extern void validate_filter_port(webs_t wp, char *value, struct variable *v);
extern void validate_filter_web(webs_t wp, char *value, struct variable *v);
extern void validate_blocked_service(webs_t wp, char *value, struct variable *v);
extern int filter_onload(webs_t wp);
extern int save_policy(webs_t wp);
extern int summary_delete_policy(webs_t wp);
extern int single_delete_policy(webs_t wp);
extern int save_services_port(webs_t wp);

/* for forward */
extern int ej_show_default_level(int eid,webs_t wp, int argc, char_t **argv);
extern int ej_port_forward_table(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_port_forward_spec(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_show_staticleases(int eid, webs_t wp, int argc, char_t **argv);

extern void validate_forward_proto(webs_t wp, char *value, struct variable *v);
extern void validate_staticleases(webs_t wp, char *value, struct variable *v);
extern void validate_forward_spec(webs_t wp, char *value, struct variable *v);
extern int ej_port_trigger_table(int eid, webs_t wp, int argc, char_t **argv);
extern void validate_port_trigger(webs_t wp, char *value, struct variable *v);
extern int ej_forward_upnp(int eid, webs_t wp, int argc, char_t **argv); //upnp added 
extern void validate_forward_upnp(webs_t wp, char *value, struct variable *v); //upnp added 

/* for dynamic route */
extern int ej_dump_route_table(int eid, webs_t wp, int argc, char_t **argv);
extern void validate_dynamic_route(webs_t wp, char *value, struct variable *v);
extern int dynamic_route_onload(webs_t wp);

/* for static route */
extern int ej_static_route_setting(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_static_route_table(int eid, webs_t wp, int argc, char_t **argv);
extern void validate_static_route(webs_t wp, char *value, struct variable *v);
extern int delete_static_route(webs_t wp);

/* for wireless */
extern void validate_wl_key(webs_t wp, char *value, struct variable *v);
extern void validate_wl_wep(webs_t wp, char *value, struct variable *v);
extern void validate_wl_auth(webs_t wp, char *value, struct variable *v);
extern void validate_d11_channel(webs_t wp, char *value, struct variable *v);
extern int add_active_mac(webs_t wp);
extern int wl_active_onload(webs_t wp, char *arg);
extern int generate_key_64(webs_t wp);
extern int generate_key_128(webs_t wp);
extern int ej_get_wep_value(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_wl_active_mac(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_wl_value(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_show_wpa_setting(int eid, webs_t wp, int argc, char_t **argv);
extern void wl_unit(webs_t wp, char *value, struct variable *v);
extern void validate_wpa_psk(webs_t wp, char *value, struct variable *v);
extern void validate_auth_mode(webs_t wp, char *value, struct variable *v);
extern void validate_security_mode(webs_t wp, char *value, struct variable *v);
extern int ej_wl_ioctl(int eid, webs_t wp, int argc, char_t **argv);
extern void validate_wl_gmode(webs_t wp, char *value, struct variable *v);
extern void validate_wl_net_mode(webs_t wp, char *value, struct variable *v);

/* for nvram save-restore */
extern void nv_file_in(char *url, webs_t stream, int len, char *boundary);
extern void nv_file_out(char *path, webs_t wp);
extern void sr_config_cgi(char *path, webs_t wp);

/* for ddns */
extern int ddns_save_value(webs_t wp);
extern int ddns_update_value(webs_t wp);

/* for nvram save-restore */
extern void nv_file_in(char *url, webs_t stream, int len, char *boundary);
extern void nv_file_out(char *path, webs_t wp);
extern void sr_config_cgi(char *path, webs_t wp);

extern void validate_macmode(webs_t wp, char *value, struct variable *v);
extern void validate_wl_hwaddrs(webs_t wp, char *value, struct variable *v);
extern int ej_wireless_active_table(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_wireless_filter_table(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_show_wl_wep_setting(int eid, webs_t wp, int argc, char_t **argv);
extern void validate_wl_wep_key(webs_t wp, char *value, struct variable *v);

/* for ddns */
extern int ej_show_ddns_status(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_show_ddns_ip(int eid, webs_t wp, int argc, char_t **argv);
//
/* for test */
extern int ej_wl_packet_get(int eid, webs_t wp, int argc, char_t **argv);



extern int ej_dump_ping_log(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_dump_traceroute_log(int eid, webs_t wp, int argc, char_t **argv);
extern int diag_ping_start(webs_t wp);
extern int diag_ping_stop(webs_t wp);
extern int diag_ping_clear(webs_t wp);
extern int diag_traceroute_start(webs_t wp);
extern int diag_traceroute_stop(webs_t wp);
extern int diag_traceroute_clear(webs_t wp);
extern int ping_onload(webs_t wp, char *arg);
extern int traceroute_onload(webs_t wp, char *arg);



/* for all */
extern int ej_onload(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_web_page_name(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_compile_date(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_compile_time(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_model_name(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_firmware_version(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_firmware_title(int eid, webs_t wp, int argc, char_t **argv);

/* Sveasoft additions */

extern void save_wds(webs_t wp,char *value, struct variable *v);
extern void validate_wds(webs_t wp, char *value, struct variable *v);
extern void validate_statics(webs_t wp, char *value, struct variable *v);
extern int ej_get_wdsp2p(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_active_wireless(int eid, webs_t wp, int argc, char_t **argv);
#ifdef HAVE_SKYTRON
extern int ej_active_wireless2(int eid, webs_t wp, int argc, char_t **argv);
#endif
extern int ej_active_wds(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_wds_mac(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_wds_ip(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_wds_netmask(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_wds_gw(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_br1_ip(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_br1_netmask(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_curchannel(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_currate(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_uptime(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_qossvcs(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_qosips(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_qosmacs(int eid, webs_t wp, int argc, char_t **argv);

extern int ej_get_qossvcs2(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_qosips2(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_qosmacs2(int eid, webs_t wp, int argc, char_t **argv);

extern int ej_get_services_options(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_show_control(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_clone_wmac(int eid, webs_t wp, int argc, char_t **argv);
extern int qos_add_svc(webs_t wp);
extern int qos_add_ip(webs_t wp);
extern int qos_add_mac(webs_t wp);
extern int qos_save(webs_t wp);
extern int ping_startup(webs_t wp);
extern int ping_firewall(webs_t wp);
/* end Sveasoft additions */
extern int forward_add(webs_t wp);
extern int forward_remove(webs_t wp);
extern int lease_add(webs_t wp);
extern int lease_remove(webs_t wp);
extern int forwardspec_add(webs_t wp);
extern int forwardspec_remove(webs_t wp);
extern int trigger_add(webs_t wp);
extern int trigger_remove(webs_t wp);

/* lonewolf additions */
extern int ej_port_vlan_table(int eid, webs_t wp);
extern int port_vlan_table_save(webs_t wp);
extern int ej_if_config_table(int eid, webs_t wp);
extern int if_config_table_save(webs_t wp);
extern int alias_delete_ip(webs_t wp);
/* end lonewolf additions */

extern int valid_ipaddr(webs_t wp, char *value, struct variable *v);
extern int valid_range(webs_t wp, char *value, struct variable *v);
extern int valid_hwaddr(webs_t wp, char *value, struct variable *v);
extern int valid_choice(webs_t wp, char *value, struct variable *v);
extern int valid_netmask(webs_t wp, char *value, struct variable *v);
extern int valid_name(webs_t wp, char *value, struct variable *v);
extern int valid_merge_ipaddrs(webs_t wp, char *value, struct variable *v);
extern int valid_wep_key(webs_t wp, char *value, struct variable *v);

extern int get_dns_ip(char *name, int which, int count);
extern int get_single_ip(char *ipaddr, int which);
extern int get_merge_ipaddr(char *name, char *ipaddr);
extern int get_merge_mac(char *name, char *macaddr);
extern char *rfctime(const time_t *timep);
extern int legal_ipaddr(char *value);
extern int legal_hwaddr(char *value);
extern int legal_netmask(char *value);
extern int legal_ip_netmask(char *sip, char *smask, char *dip);
extern int find_pattern(const char *data, size_t dlen,
                        const char *pattern, size_t plen,
                        char term, 
                        unsigned int *numoff,
                        unsigned int *numlen);

extern int find_match_pattern(char *name, size_t mlen,
                        const char *data,
                        const char *pattern,
                        char *def);

extern int find_each(char *name, int len,
	          char *data,
	          char *token,
	          int which,
	          char *def);

/* 
 * set type to 1 to replace ' ' with "&nbsp;" and ':' with "&semi;"
 * set type to 2 to replace "&nbsp;" with ' ' and "&semi;" with ':'
 */
extern int filter_name(char *old_name, char *new_name, size_t size, int type);

/* check the value for a digit (0 through 9) 
 * set flag to 0 to ignore zero-length values
 */
extern int ISDIGIT(char *value, int flag);

/* checks  whether  value  is  a  7-bit unsigned char value that fits into the ASCII character set 
 * set flag to 0 to ignore zero-length values
 */
extern int ISASCII(char *value, int flag);

extern void do_setup_wizard(char *url, webs_t stream);

extern int ej_show_logo(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_show_sysinfo(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_show_miscinfo(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_backup_name(int eid, webs_t wp, int argc, char_t **argv);

extern struct servent * my_getservbyport(int port, const char *proto);
extern int get_single_mac(char *macaddr, int which);

extern int StopContinueTx(char *value);
extern int StartContinueTx(char *value);
extern int Check_TSSI(char *value);
extern int Get_TSSI(char *value);
extern int Enable_TSSI(char *value);

extern void LOG(int level, const char *fmt,...);

extern char *num_to_protocol(int num);
extern int protocol_to_num(char *proto);
extern  void do_backup(char *path, webs_t stream);

extern int ej_per_port_option(int eid, webs_t wp, int argc, char_t **argv);
extern void validate_port_qos(webs_t wp, char *value, struct variable *v);
extern int ej_qos_sw_default(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_show_meminfo(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_dump_site_survey(int eid, webs_t wp, int argc, char_t **argv);
extern int ej_get_url(int eid, webs_t wp, int argc, char_t **argv);
#ifdef FBNFW
extern int ej_list_fbn(int eid, webs_t wp, int argc, char_t **argv);
#endif
extern int ej_wme_match_op(int eid, webs_t wp, int argc, char_t **argv);
extern void validate_noack(webs_t wp, char *value, struct variable *v);
extern void validate_wl_wme_params(webs_t wp, char *value, struct variable *v);

extern void validate_choice(webs_t wp, char *value, struct variable *v);
