
/*
 *********************************************************
 *   Copyright 2003, CyberTAN  Inc.  All Rights Reserved *
 *********************************************************

 This is UNPUBLISHED PROPRIETARY SOURCE CODE of CyberTAN Inc.
 the contents of this file may not be disclosed to third parties,
 copied or duplicated in any form without the prior written
 permission of CyberTAN Inc.

 This software should be used as a reference only, and it not
 intended for production use!


 THIS SOFTWARE IS OFFERED "AS IS", AND CYBERTAN GRANTS NO WARRANTIES OF ANY
 KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE.  CYBERTAN
 SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE
*/

/*
 * ppp scripts
 *
 * Copyright 2001-2003, Broadcom Corporation
 * All Rights Reserved.
 * 
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.
 *
 * $Id: ppp.c,v 1.2 2005/09/26 11:08:11 seg Exp $
 */

#include <stdio.h>
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <net/route.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <time.h>

#include <bcmnvram.h>
#include <netconf.h>
#include <shutils.h>
#include <rc.h>

#include <code_pattern.h>
#include <cy_conf.h>
#include <utils.h>

#define IFUP (IFF_UP | IFF_RUNNING | IFF_BROADCAST | IFF_MULTICAST)

/*
 * Called when link comes up
 */
int
ipup_main(int argc, char **argv)
{
	FILE *fp;
	char *wan_ifname = safe_getenv("IFNAME");
//	char *wan_proto = nvram_safe_get("wan_proto");
	char *value;
	char buf[256];

	dprintf("%s\n", argv[0]);

	eval("killall", "-9", "listen");

	if(check_action() != ACT_IDLE)
                return -1;

	/* ipup will receive bellow six arguments */
	/* interface-name  tty-device  speed  local-IP-address   remote-IP-address ipparam */
	nvram_set("wan_iface", wan_ifname);
	/* Touch connection file */
	if (!(fp = fopen("/tmp/ppp/link", "a"))) {
		perror("/tmp/ppp/link");
		return errno;
	}
	fprintf(fp, "%s", argv[1]);
	fclose(fp);

	nvram_set("pppd_pppifname",wan_ifname);

	if(nvram_match("wan_proto","pppoe"))
	    nvram_set("pppoe_ifname",wan_ifname);

	if ((value = getenv("IPLOCAL"))) {
		ifconfig(wan_ifname, IFUP,
			 value, "255.255.255.255");
		if(nvram_match("wan_proto","pppoe")){
                        nvram_set("wan_ipaddr_buf", nvram_safe_get("wan_ipaddr"));	//Store last ip address
                        nvram_set("wan_ipaddr", value);
                        nvram_set("wan_netmask", "255.255.255.255");
                }
                else if(nvram_match("wan_proto","pptp")){
                        nvram_set("wan_ipaddr_buf", nvram_safe_get("pptp_get_ip"));	// Store last ip address
                        nvram_set("pptp_get_ip", value);
                }
                else if(nvram_match("wan_proto","l2tp")){
                        nvram_set("wan_ipaddr_buf", nvram_safe_get("l2tp_get_ip"));     // Store last ip address
                        nvram_set("l2tp_get_ip", value);
                }
	}

        if ((value = getenv("IPREMOTE")))
		nvram_set("wan_gateway", value);
	strcpy(buf, "");
	if (getenv("DNS1"))
		sprintf(buf, "%s", getenv("DNS1"));
	if (getenv("DNS2"))
		sprintf(buf + strlen(buf), "%s%s", strlen(buf) ? " " : "", getenv("DNS2"));
	nvram_set("wan_get_dns", buf);
	
        if ((value = getenv("AC_NAME")))
		nvram_set("ppp_get_ac", value);
        if ((value = getenv("SRV_NAME")))
		nvram_set("ppp_get_srv", value);
        if ((value = getenv("MTU")))
		nvram_set("wan_run_mtu", value);

	start_wan_done(wan_ifname);
	#ifdef HAVE_SER
	dprintf("starting sipath ip-up script\n");
	eval("/etc/ppp/ip-up",getenv("IPREMOTE"),getenv("IPLOCAL"));
	#endif
	dprintf("done\n");
	return 0;
}

/*
 * Called when link goes down
 */
int
ipdown_main(int argc, char **argv)
{
	if(check_action() != ACT_IDLE)
                return -1;
	
	stop_ddns();    // Aviod to trigger DOD
        stop_ntp();
	
	unlink("/tmp/ppp/link");	

	if(nvram_match("wan_proto", "l2tp")) {
		/* clear dns from the resolv.conf */
		nvram_set("wan_get_dns","");
		dns_to_resolv();

	//todo
		route_del(nvram_safe_get("wan_ifname"), 0, nvram_safe_get("l2tp_server_ip"), nvram_safe_get("wan_gateway_buf"), "255.255.255.255");
		/* Restore the default gateway for WAN interface */
		nvram_set("wan_gateway", nvram_safe_get("wan_gateway_buf"));

		/* Set default route to gateway if specified */
		route_add(nvram_safe_get("wan_ifname"), 0, "0.0.0.0", nvram_safe_get("wan_gateway"), "0.0.0.0");
	}
	
	nvram_set("pppoe_ifname","");
	nvram_set("pppd_pppifname","");

	// write PPP traffic statistics to nvram if wanted
	if(nvram_match("ppp_traffic", "1")) {
	        char buffer[64];
	    	long long old_in, old_out;
		long long in, out;
		char *pin;
		char *pout;
		time_t stamp;

		old_in = atol(nvram_safe_get("ppp_byte_in"));
		old_out = atol(nvram_safe_get("ppp_byte_out"));
		
		if( (pin=getenv("BYTES_RCVD")) )
		    in = atol(pin);
		else
		    in = 0;
		
		if( (pout=getenv("BYTES_SENT")) )
		    out = atol(pout);
		else
		    out = 0;
		
		in += old_in;
		out += old_out;
		snprintf(buffer, 63, "%lld", in);
		nvram_set("ppp_byte_in", buffer);
		snprintf(buffer, 63, "%lld", out);
		nvram_set("ppp_byte_out", buffer);
		if( (stamp = time(NULL)) < 1087818160 ) // clock is not set properly
		    stamp = 0;
		snprintf(buffer, 63, "%ld", stamp);
		nvram_set("ppp_byte_stamp", buffer);
		nvram_commit();
	}

	if(nvram_match("ppp_demand", "1") && (nvram_match("wan_proto", "pptp") || nvram_match("wan_proto", "l2tp"))){
		eval("killall", "-9", "listen");
		eval("listen", nvram_safe_get("lan_ifname"));
	}	
		
	return 1;
}
