/*
this source is published under no warranty and may be published without any fee
to third parties. 
The use of this source is permitted without any charge for PRIVATE and NON COMERCIAL usage
only unless other rights are granted by the firmware author only.

DD-WRT v23 (c) 2004 - 2005 by Sebastian Gottschall / Blueline AG
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <broadcom.h>
#include <cymac.h>
#include <wlutils.h>
#include <sveasoft.h>

#define ASSOCLIST_TMP	"/tmp/.wl_assoclist"
#define RSSI_TMP	"/tmp/.rssi"
#define ASSOCLIST_CMD	"wl assoclist"
#define RSSI_CMD	"wl rssi"
#define NOISE_CMD	"wl noise"






#ifdef HAVE_SKYTRON
int ej_active_wireless2(int eid, webs_t wp, int argc, char_t **argv)
{
	int  rssi=0, noise=0;
	FILE *fp, *fp2;
	char *mode;
	char mac[30];
	char list[2][30];
	char line[80];
	char cmd[80];

	unlink(ASSOCLIST_TMP);
	unlink(RSSI_TMP);

	mode = nvram_safe_get("wl_mode");
	snprintf(cmd,sizeof(cmd),"%s > %s", ASSOCLIST_CMD, ASSOCLIST_TMP);
	system(cmd);		// get active wireless mac

int connected=0;
	if ((fp = fopen(ASSOCLIST_TMP, "r"))) {
		while( fgets(line, sizeof(line), fp) != NULL ) {
			if(sscanf(line,"%s %s",list[0], mac) != 2)	// assoclist 00:11:22:33:44:55
				continue;

			if(strcmp(list[0],"assoclist"))
				break;

			rssi = 0;
			noise = 0;
			// get rssi value
			if(strcmp(mode, "ap"))
			  snprintf(cmd,sizeof(cmd),"%s > %s", RSSI_CMD, RSSI_TMP);
			else
			  snprintf(cmd,sizeof(cmd),"%s \"%s\" > %s", RSSI_CMD, mac, RSSI_TMP);
			system(cmd);

			// get noise value if not ap mode
			if(strcmp(mode, "ap"))
			  snprintf(cmd,sizeof(cmd),"%s >> %s", NOISE_CMD, RSSI_TMP);

		  	system(cmd);		// get RSSI value for mac

			fp2 = fopen(RSSI_TMP, "r");
			if(fgets(line, sizeof(line), fp2) != NULL){

				// get rssi
				if(sscanf(line,"%s %s %d", list[0], list[1], &rssi) != 3)
			     		continue;

				// get noise for client/wet mode
				if (strcmp(mode, "ap") &&
			    	    fgets(line, sizeof(line), fp2) != NULL &&
			    	    sscanf(line,"%s %s %d", list[0], list[1], &noise) != 3)
			     		continue;

				fclose(fp2);
			}
			#ifdef MASKMAC
			mac[0]='x';
			mac[1]='x';
			mac[3]='x';
			mac[4]='x';
			mac[6]='x';
			mac[7]='x';
			mac[9]='x';
			mac[10]='x';
			#endif
			if( strcmp(mode,"ap") != 0){
			connected=1;
	websWrite(wp,"<tr>\n");
		websWrite(wp,"<td bgcolor=\"#B2B2B2\" valign=\"center\" align=\"right\" width=\"200\" height=\"25\"><font face=\"Arial\" color=\"#000000\" size=\"2\"><b>Verbindungsstatus</b></font></td>\n");
		websWrite(wp,"<td bgcolor=\"#B2B2B2\"></td>\n");
		websWrite(wp,"<td bgcolor=\"#FFFFFF\"></td>\n");
		websWrite(wp,"<td colspan=\"2\" bgcolor=\"#FFFFFF\" valign=\"center\" align=\"left\"><font face=\"Arial\" color=\"#000000\" size=\"2\">Verbunden</font></td>\n");
	websWrite(wp,"</tr>\n");
	websWrite(wp,"<tr>\n");
		websWrite(wp,"<td bgcolor=\"#B2B2B2\" valign=\"center\" align=\"right\" width=\"200\" height=\"25\"><font face=\"Arial\" color=\"#000000\" size=\"2\">Signal</font></td>\n");
		websWrite(wp,"<td bgcolor=\"#B2B2B2\"></td>\n");
		websWrite(wp,"<td bgcolor=\"#FFFFFF\"></td>\n");
		websWrite(wp,"<td colspan=\"2\" bgcolor=\"#FFFFFF\" valign=\"center\" align=\"left\"><font face=\"Arial\" color=\"#000000\" size=\"2\">%d dBm</font></td>\n",rssi);
	websWrite(wp,"</tr>\n");
	websWrite(wp,"<tr>\n");
		websWrite(wp,"<td bgcolor=\"#B2B2B2\" valign=\"center\" align=\"right\" width=\"200\" height=\"25\"><font face=\"Arial\" color=\"#000000\" size=\"2\">Rauschen</font></td>\n");
		websWrite(wp,"<td bgcolor=\"#B2B2B2\"></td>\n");
		websWrite(wp,"<td bgcolor=\"#FFFFFF\"></td>\n");
		websWrite(wp,"<td colspan=\"2\" bgcolor=\"#FFFFFF\" valign=\"center\" align=\"left\"><font face=\"Arial\" color=\"#000000\" size=\"2\">%d dBm</font></td>\n",noise);
	websWrite(wp,"</tr>\n");
 			}
		}
	}

	unlink(ASSOCLIST_TMP);
	unlink(RSSI_TMP);
	if (!connected)
	{
			connected=1;
	websWrite(wp,"<tr>\n");
		websWrite(wp,"<td bgcolor=\"#B2B2B2\" valign=\"center\" align=\"right\" width=\"200\" height=\"25\"><font face=\"Arial\" color=\"#000000\" size=\"2\"><b>Verbindungsstatus</b></font></td>\n");
		websWrite(wp,"<td bgcolor=\"#B2B2B2\"></td>\n");
		websWrite(wp,"<td bgcolor=\"#FFFFFF\"></td>\n");
		websWrite(wp,"<td colspan=\"2\" bgcolor=\"#FFFFFF\" valign=\"center\" align=\"left\"><font face=\"Arial\" color=\"#000000\" size=\"2\">Nicht Verbunden</font></td>\n");
	websWrite(wp,"</tr>\n");

	}

	return 0;
}
#endif


int macro_add(char *a)
{
char *count;
int c;
char buf[20];
count = nvram_safe_get(a);
if (count!=NULL && strlen(count)>0)
    {
    c = atoi(count);
    if (c>-1)
    {
    c++;
    sprintf(buf,"%d",c);
    nvram_set(a,buf);
    }
    }
return 0;
}
int macro_rem(char *a,char *nv)
{
char *count;
int c,i,cnt;
char buf[20];
char *buffer,*b;
cnt=0;
count = nvram_safe_get(a);
if (count!=NULL && strlen(count)>0)
    {
    c = atoi(count);
    if (c>0)
    {
    c--;
    sprintf(buf,"%d",c);
    nvram_set(a,buf);
    buffer=nvram_safe_get(nv);
    if (buffer!=NULL)
    {
    b = malloc(strlen(buffer)+1);
    for (i=0;i<strlen(buffer);i++)
	{
	if (buffer[i]==' ')cnt++;
	if (cnt==c)break;
	b[i]=buffer[i];
	}
	b[i]=0;
	nvram_set(nv,b);
    }
    
    }
    }
return 0;
}
int forward_remove(webs_t wp)
{
return macro_rem("forward_entries","forward_port");
}

int forward_add(webs_t wp)
{
return macro_add("forward_entries");
}

int lease_remove(webs_t wp)
{
return macro_rem("static_leasenum","static_leases");
}

int lease_add(webs_t wp)
{
return macro_add("static_leasenum");
}


int forwardspec_remove(webs_t wp)
{
return macro_rem("forwardspec_entries","forward_spec");
}

int forwardspec_add(webs_t wp)
{
return macro_add("forwardspec_entries");
}

int trigger_remove(webs_t wp)
{
return macro_rem("trigger_entries","port_trigger");
}

int trigger_add(webs_t wp)
{
return macro_add("trigger_entries");
}

int ej_show_paypal(int eid, webs_t wp, int argc, char_t **argv)
{
#ifndef CONFIG_BRANDING
websWrite(wp,"<a href=\"http://www.dd-wrt.com/\">DD-WRT</a>");
websWrite(wp,"<form action=\"https://www.paypal.com/cgi-bin/webscr\" method=\"post\" target=\"_blank\">");
websWrite(wp,"<input type=\"hidden\" name=\"cmd\" value=\"_xclick\">");
websWrite(wp,"<input type=\"hidden\" name=\"business\" value=\"sebastian.gottschall@advis.de\">");
websWrite(wp,"<input type=\"hidden\" name=\"item_name\" value=\"DD-WRT Development Support\">");
websWrite(wp,"<input type=\"hidden\" name=\"no_note\" value=\"1\">");
websWrite(wp,"<input type=\"hidden\" name=\"currency_code\" value=\"EUR\">");
websWrite(wp,"<input type=\"hidden\" name=\"tax\" value=\"0\">");
websWrite(wp,"<input type=\"image\" src=\"images/paypal.gif\" border=\"0\" name=\"submit\" width=\"62\" height=\"31\">");
websWrite(wp,"</form>");
#endif
return 0;
}


void validate_staticleases(webs_t wp, char *value, struct variable *v) 
{
char lease_hwaddr[32]="leasexxx_hwaddr";
char lease_hostname[32]="leasexxx_hostname";
char lease_ip[32]="leasexxx_ip";
char *sln = nvram_safe_get("static_leasenum");
if (sln==NULL || strlen(sln)==0)return 0;
int leasenum = atoi(sln);
if (leasenum==0)return 0;
char *leases;
int i;
leases = (char*)malloc((54*leasenum)+1);
memset(leases,0,(54*leasenum)+1);

for (i=0;i<leasenum;i++)
{
snprintf(lease_hwaddr, 31,"lease%d_hwaddr",i);
strcat(leases,websGetVar(wp,lease_hwaddr, ""));
strcat(leases,"=");
snprintf(lease_hostname, 31,"lease%d_hostname",i);
strcat(leases,websGetVar(wp,lease_hostname, ""));
strcat(leases,"=");
snprintf(lease_ip, 31,"lease%d_ip",i); 
strcat(leases,websGetVar(wp,lease_ip, ""));
strcat(leases," ");
}
nvram_set("static_leases",leases);
nvram_commit();
free(leases);
}

int ej_show_staticleases(int eid, webs_t wp, int argc, char_t **argv)
{
int i;
//cprintf("get static leasenum");

char *sln = nvram_safe_get("static_leasenum");
//cprintf("check null");
if (sln==NULL || strlen(sln)==0)return 0;
//cprintf("atoi");

int leasenum = atoi(sln);
//cprintf("leasenum==0");
if (leasenum==0)return 0;
//cprintf("get leases");
char *nvleases = nvram_safe_get("static_leases");
//cprintf("malloc clone");
char *leases = (char*)malloc(strlen(nvleases)+1);
char *originalpointer = leases; //strsep destroys the pointer by moving it
//cprintf("copy leases");
strcpy(leases,nvleases);
for (i=0;i<leasenum;i++)
{
//cprintf("strsep %s\n", leases);
char *sep = strsep(&leases,"=");
//cprintf("webswrite\n");
websWrite(wp,"<tr><td><input name=\"lease%d_hwaddr\" value=\"%s\" size=\"18\" maxlength=\"18\" class=\"num\" /></td>",i,sep!=NULL?sep:"");
//cprintf("strsep %s\n", leases);
sep = strsep(&leases,"=");
//cprintf("webswrite\n");
websWrite(wp,"<td><input name=\"lease%d_hostname\" value=\"%s\" size=\"16\" maxlength=\"16\" class=\"num\" /></td>",i,sep!=NULL?sep:"");
//cprintf("strsep %s\n", leases);
sep = strsep(&leases," ");
//cprintf("webswrite\n");
websWrite(wp,"<td><input name=\"lease%d_ip\" value=\"%s\" size=\"15\" maxlength=\"15\" class=\"num\" /></td></tr>\n",i,sep!=NULL?sep:"");
}
//cprintf("free\n");
free(originalpointer);
//cprintf("return\n");
return 0;
}


int ej_show_control(int eid, webs_t wp, int argc, char_t **argv)
{
    #ifdef CONFIG_BRANDING
    websWrite(wp,"Control Panel");
    #else
    websWrite(wp,"DD-WRT Control Panel");
    #endif
return 0;
}


#ifndef HAVE_AQOS
int ej_show_default_level(int eid,webs_t wp, int argc, char_t **argv)
{
return 0;
}

#else
int ej_show_default_level(int eid,webs_t wp, int argc, char_t **argv)
{
websWrite(wp,"<fieldset>\n");
websWrite(wp,"<legend>Default Bandwith Level</legend>\n");
websWrite(wp,"<div class=\"setting\">\n");
websWrite(wp,"<div class=\"label\">Bandwith in Kbits</div>\n");
websWrite(wp,"<input type=\"num\" name=\"default_level\" size=\"6\" value=\"%s\" />\n",nvram_safe_get("default_level"));
websWrite(wp,"</div>\n");
websWrite(wp,"</fieldset><br />\n");
return 0;
}
#endif


#ifdef HAVE_MSSID
int ej_show_virtualssid(int eid, webs_t wp, int argc, char_t **argv)
{
char *next;
char var[80];
char *vifs=nvram_safe_get("wl0_vifs");
if (vifs==NULL) return 0;
int count=1;
foreach(var, vifs, next) {
websWrite(wp,"<div class=\"setting\">\n");
websWrite(wp,"<div class=\"label\">Wireless Network Name (SSID)</div>\n");
websWrite(wp,"<input name=\"wl0.%d_ssid\" size=\"20\" maxLength=\"32\" onBlur=\"valid_name(this,'SSID')\" value='<% nvram_get(\"wl0.%d_ssid\"); %>' /></div>\n",count,count);
websWrite(wp,"<div class=\"setting\">\n");
websWrite(wp,"<div class=\"label\">Wireless SSID Broadcast</div>");
websWrite(wp,"<input type=\"radio\" value=\"0\" name=\"wl0.%d_closed\" <% nvram_match(\"wl0.%d_closed\",\"0\",\"checked\"); %>>Enable</input>\n",count,count);
websWrite(wp,"<input type=\"radio\" value=\"1\" name=\"wl0.%d_closed\" <% nvram_match(\"wl0.%d_closed\",\"1\",\"checked\"); %>>Disable</input>\n",count,count);
websWrite(wp,"</div>\n");
websWrite(wp,"<div class=\"setting\">\n");
websWrite(wp,"<div class=\"label\">AP Isolation</div><select name=\"wl0.%d_ap_isolate\">\n",count);
websWrite(wp,"<option value=\"0\" <% nvram_selmatch(\"wl0.%d_ap_isolate\", \"0\", \"selected\"); %>>Off</option>\n",count);
websWrite(wp,"<option value=\"1\" <% nvram_selmatch(\"wl0.%d_ap_isolate\", \"1\", \"selected\"); %>>On</option></select>\n",count);
websWrite(wp,"</div>\n");
count++;
}
websWrite(wp,"<div class=\"setting\">\n");
websWrite(wp,"<div class=\"label\">Virtual Interfaces</div>\n");
if (count<17)websWrite(wp,"<input type=\"button\" value=\"Add\" onClick=vifs_add_submit(this.form) />\n");
if (count>1)websWrite(wp,"<input type=\"button\" value=\"Remove\" onClick=vifs_remove_submit(this.form) /></div>\n");
return 0;
}

int get_vifcount()
{
char *next;
char var[80];
char *vifs=nvram_safe_get("wl0_vifs");
if (vifs==NULL) return 0;
int count=0;
foreach(var, vifs, next) {
count++;
}
return count;
}

int add_vifs(webs_t wp)
{
int count = get_vifcount();
if (count==16)return 0;
char *vifs=nvram_safe_get("wl0_vifs");
if (vifs==NULL)return 0;
char *n = (char*)malloc(strlen(vifs)+8);
sprintf(n,"%s wl0.%d",vifs,count+1);
nvram_set("wl0_vifs",n);
nvram_commit();
free(n);
}

int remove_vifs(webs_t wp)
{
char *next;
char var[80];
int count = get_vifcount()-1;
int o=count;
char *vifs=nvram_safe_get("wl0_vifs");
char *n = (char*)malloc(strlen(vifs));
n[0]=0;
if (vifs==NULL)return 0;
if (count)
{
foreach(var, vifs, next) {
if (o==count)
    strcat(n,var);
else
    {
    strcat(n," ");
    strcat(n,var);
    }     
}
}
nvram_set("wl0_vifs",n);
nvram_commit();
free(n); 
}

#else
int ej_show_virtualssid(int eid, webs_t wp, int argc, char_t **argv)
{
return 0;
}
#endif

