/*
 * NVRAM variable manipulation (Linux user mode half)
 *
 * Copyright 2001-2003, Broadcom Corporation
 * All Rights Reserved.
 *
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.
 *
 * $Id: nvram_linux.c,v 1.9 2003/12/03 10:14:06 honor Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <error.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <malloc.h>
#include <typedefs.h>
#include <bcmnvram.h>
#include <nvram_convert.h>


/* Globals */

int
nvram_init (void *unused)
{
//not needed for generic implementation
  return 0;
}

struct nvrams
{
  char *name;
  char *value;
};

struct nvramdb
{
  int nov;			//number of values;
  struct nvrams *values;
};

struct nvramdb values;


void
writedb (void)
{
  FILE *in;
  in = fopen ("/etc/nvram/nvram.db", "wb");
  if (in == NULL)
    return;
  int c = 0;
  int i;
  for (i = 0; i < values.nov; i++)
    {
      if (values.values[i].name)
	c++;
    }
  putc (c >> 8, in);
  putc (c & 255, in);
  for (i = 0; i < values.nov; i++)
    {
      if (values.values[i].name)
	{
	  int len = strlen (values.values[i].name);
	  putc (len, in);
	  int a;
	  for (a = 0; a < len; a++)
	    putc (values.values[i].name[a], in);

	  len = strlen (values.values[i].value);
	  putc (len >> 8, in);
	  putc (len & 255, in);
	  for (a = 0; a < len; a++)
	    putc (values.values[i].value[a], in);
	}
    }
  fclose (in);

}

void
readdb (void)
{
  FILE *in;
  in = fopen ("/etc/nvram/nvram.db", "rb");
  if (in == NULL)
    {
      values.nov = 0;
      return;			//first time init;
    }
  values.nov = getc (in) << 8;
  values.nov += getc (in);
  values.values =
    (struct nvrams *) malloc (values.nov * sizeof (struct nvrams));
  int i;
  for (i = 0; i < values.nov; i++)
    {
      int len = getc (in);
      values.values[i].name = (char *) malloc (len);
      int a;
      for (a = 0; a < len; a++)
	values.values[i].name[a] = getc (in);
      len = getc (in) << 8;
      len += getc (in);
      values.values[i].value = (char *) malloc (len);
      for (a = 0; a < len; a++)
	values.values[i].value[a] = getc (in);
    }
  fclose (in);
}

void
closedb (void)
{
  int i;
  for (i = 0; i < values.nov; i++)
    {
      free (values.values[i].name);
      free (values.values[i].value);
    }
  free (values.values);
  values.nov = 0;
}


char *
nvram_get (const char *name)
{
  int i;
  readdb ();
  for (i = 0; i < values.nov; i++)
    {
      if (!strcmp (values.values[i].name, name))
	return values.values[i].value;
    }
  closedb ();
  return NULL;
}

int
nvram_getall (char *b, int count)
{
  readdb ();
  char *buf = b;
  memset (buf, 0, NVRAM_SPACE);
  int i;
  for (i = 0; i < values.nov; i++)
    {
      strcat (buf, values.values[i].name);
      strcat (buf, "=");
      strcat (buf, values.values[i].value);
      int len = strlen (buf);
      buf[len] = 0;
      buf += len + 1;
    }
  closedb ();
  return 0;
}

static int
_nvram_set (const char *name, const char *value)
{
  readdb ();
  int i;
  for (i = 0; i < values.nov; i++)
    {
      if (!strcmp (values.values[i].name, name))
	{
	  if (value == NULL)
	    {
	      free (values.values[i].name);
	      free (values.values[i].value);
	      values.values[i].name = NULL;
	      values.values[i].value = NULL;
	    }
	  else
	    {
	      free (values.values[i].value);
	      values.values[i].value = strdup (value);
	      value = NULL;
	    }
	}
    }
  if (value)
    {
      values.values =
	(struct nvrams *) realloc (values.values,
				   values.nov * (sizeof (struct nvrams) + 1));
      values.values[values.nov].name = strdup (name);
      values.values[values.nov].value = strdup (value);
      values.nov++;
    }
  writedb ();
  closedb ();
  return 0;
}

int
nvram_set (const char *name, const char *value)
{
  extern struct nvram_convert nvram_converts[];
  struct nvram_convert *v;
  int ret;

  ret = _nvram_set (name, value);

  for (v = nvram_converts; v->name; v++)
    {
      if (!strcmp (v->name, name))
	{
	  if (strcmp (v->wl0_name, ""))
	    _nvram_set (v->wl0_name, value);
	  if (strcmp (v->d11g_name, ""))
	    _nvram_set (v->d11g_name, value);
	}
    }

  return ret;
}

int
nvram_unset (const char *name)
{
  return _nvram_set (name, NULL);
}

int
nvram_commit (void)
{
  return 0;
}

int
file2nvram (char *filename, char *varname)
{
  FILE *fp;
  int c, count;
  int i = 0, j = 0;
  char mem[10000], buf[30000];

  if (!(fp = fopen (filename, "rb")))
    return 0;

  count = fread (mem, 1, sizeof (mem), fp);
  fclose (fp);
  for (j = 0; j < count; j++)
    {
      if (i > sizeof (buf) - 3)
	break;
      c = mem[j];
      if (c >= 32 && c <= 126 && c != '~')
	{
	  buf[i++] = (unsigned char) c;
	}
      else if (c == 13)
	{
	  buf[i++] = (unsigned char) c;
	}
      else if (c == 0)
	{
	  buf[i++] = '~';
	}
      else if (c == 10)
	{
	  buf[i++] = (unsigned char) c;
	}
      else
	{
	  buf[i++] = '\\';
	  sprintf (buf + i, "%02X", c);
	  i += 2;
	}
    }
  if (i == 0)
    return 0;
  buf[i] = 0;
  //fprintf(stderr,"================ > file2nvram %s = [%s] \n",varname,buf); 
  nvram_set (varname, buf);

}

int
nvram2file (char *varname, char *filename)
{
  FILE *fp;
  int c, tmp;
  int i = 0, j = 0;
  char *buf;
  char mem[10000];

  if (!(fp = fopen (filename, "wb")))
    return 0;

  buf = strdup (nvram_safe_get (varname));
  //fprintf(stderr,"=================> nvram2file %s = [%s] \n",varname,buf);
  while (buf[i] && j < sizeof (mem) - 3)
    {
/*        if (buf[i] == '\\')  {
                i++;
                tmp=buf[i+2];
                buf[i+2]=0;
                sscanf(buf+i,"%02X",&c);
                buf[i+2]=tmp;
                i+=2;
                mem[j]=c;j++;
        } else */
      if (buf[i] == '~')
	{
	  mem[j] = 0;
	  j++;
	  i++;
	}
      else
	{
	  mem[j] = buf[i];
	  j++;
	  i++;
	}
    }
  if (j <= 0)
    return j;
  j = fwrite (mem, 1, j, fp);
  fclose (fp);
  free (buf);
  return j;
}
