The Management screen allows you to change the Router's settings. 

It is strongly recommended that you change the factory default password of the Router, which is admin. All users who try to access the Router's web-based utility or Setup Wizard will be prompted for the Router's password.

On this page you will find most of the configurable items of the dd-wrt router code. 

Router Password
   

The new Password must not exceed 32 characters in length and must not include any spaces. Enter the new Password a second time to confirm it.
AP Watchdog
   

The AP Watchdog enables a timer that will check to see if any clients are connected in the interval seconds given. If no clients are attached, the watchdog assumes the AP needs to be reset. When clients are connected this reset will not occur. The watchdog is intended for situations where the AP becomes unavailable due to interference or internal chip problems.  
Bandwidth Management
   

Bandwidth management prioritizes the traffic on your router. Interactive traffic (telephony, browsing, telnet, etc.) gets priority and bulk traffic (file transfer, p2p) gets low priority. The main goal is to allow both types to live side-by side without unimportant trafic disturbing more critical things. All of this is more or less automatic. 

WAN vs LAN & wLAN: Choose whether Bandwidth Management active on your WAN port or on the local (wired & wireless) network. 

Uplink and Downlink bandwidth: Here you enter the 80% limits of your uplink and dowlink speed. If you have 1000Kbps downlink and 200Kbps uplink the fields should become 800 and 160. 

In some cases the router can not differentiate well between different types of traffic. The settings below serve to fine tune your situation by specifying additional low-priority traffic patterns. 

Low priority source / destination netmasks: if you know specific devices on your network you want to de-prioritize enter their IP-address and netmask here. 
Example: You have a ReplayTV device on IP 192.168.1.45. The entry 192.168.1.45/32
will keep it from monopolizing the connection when you send a movie to a friend. 

Low priority source / destination ports: if you know specific protocol types on your network you want to keep at low priority you enter their port number here. 
Example: You want to make sure your edonkey p2p on port 4242 is low priority you fill in 4242. If you have multiple ports then just add them all on the same line with spaces separating them.  
Boot Wait
   

Boot wait is a feature you will hopefully never need. It introduces a short delay while booting (5s). During this delay you can initiate the download of a new firmware if the one in the flash rom is not broken. Obviously this is only necessary if you can no longer reflash using the web interface because the installed firmware will not boot. See the {DD-WRT documentation} for more information.  
Cron
   

The cron subsystem schedules execution of Linux commands. You'll need to use the command line or startup scripts to actually use this.  
Dhcpd
   

The dhcp system assigns IP addresses to your local devices. While the main configuration is on the setup page you can program some nifty special functions here.

Dhcpd: Disabling here will disable dhcp on this router irrespective of the settings on the Setup screen.

Used domain: You can select here which domain the DHCP clients should get as their local domain. This can be the WAN domain set on the Setup screen or the LAN domain which can be set here. 

LAN Domain: You can define here your local LAN domain which is used as local domain for DNSmasq and DHCP service if chosen above. 

Static allocations: If you want to assign certain hosts a specific address then you can define them here. This is also the way to add hosts with a fixed address to the router's local DNS service (DNS masq).

The format for static allocations is: <IP Address>  <##:##:##:##:##:##>  <Hostname> 
DNS Masq
   

DNSmasq is a local DNS server. It will resolve all host names known to the router from dhcp (dynamic and static) as well as forwarding and caching DNS entries from remote DNS servers. 

Local DNS enables DHCP clients on the LAN to resolve static and dynamic DHCP hostnames.  
Loopback
   

Enable / disable the loopback interface. The loopback interface makes your internal clients appear as if they are external. This is useful for testing things like DynDNS names. The loopback is an option because enabling it will break PPTP and Windows machine browsing by wireless clients.  
802.1x
   

802.1x: A limited 802.1x server needed to fulfill WPA handshake requirements to allow Windows XP clients to work with WPA.  
NTP Client
   

Synchronize the clock of the router with an ntp timeserver.  
PPTP
   

Point-to-Point Tunneling Protocol: A VPN technology by Microsoft and remote access vendors. It is implemented in Windows XP. Configuring this allows you to access you LAN at home remotely. 

Server IP: The IP address of your router 

Client IP: A range of IP addresses for remotely connected machines. This range should not overlap with the dhcp range (Example: 192.168.0.210-220
). 

CHAP-Secrets: A list of userids and passwords for the VPN login, one user per line (Example: joe * joespassword *
). For more details look up the pppd man page.  
Remote Management
   

This feature allows you to manage your Router from a remote location, via the Internet.  To disable this feature, keep the default setting, Disable. To enable this feature, select Enable, and use the specified port (default is 8080) on your PC to remotely manage the Router. You must also change the Router's default password to one of your own, if you haven't already. A unique password will increase security.

 

To remotely manage the Router, enter http://xxx.xxx.xxx.xxx:8080 (the x's represent the Router's Internet IP address, and 8080 represents the specified port) in your web browser's Address field. You will be asked for the Router's password. After successfully entering the password, you will be able to access the Router's web-based utility.

If you check the Use https check box the remote management feature will use https (encryption). In this case you need to specify the url as https://xxx.xxx.xxx.xxx:8080. (note that not all DD-WRT firmwares does support this without rebuilding with SSL support) 

 

Note: If the Remote Management feature is enabled, anyone who knows the Router's Internet IP address and password will be able to alter the Router's settings.
Resetbuttond
   

The resetbuttond monitors the reset button and initiates actions depending on how long you press it. 
Short press: Reset the router (reboot) 
Long press (>5s): Reboot and restore the factory default configuration.  
Routing
   

Routing enables the OSPF and RIP routing daemons if you have set up OSPF or RIP routing in the Setup->Advanced Routing page.  
SSHD
   

Enabling ssh allows you to access the Linux OS of your router with an ssh client (Putty works well on Windows, for example). 

Password login: allow login with the router password (userid is 'root') 

SSHD Port: the port number for sshd (default is 22) 

Authorized Keys: here you paste your public keys to enable key-based login (more secure than a simple password)  
Syslogd
   

Enable syslogd to capture and forward all messages to another system. 

Remote Server IP-address of the server for the syslog messages  
Telnetd
   

Enable a telnet server to connect to the router with telnet. The userid is 'root' and the password is the router password. SSH is a much better choice, though.  
UPnP
   

Universal plug and play: A Microsoft technology for automatic configuration of devices. You need this enabled if you want to connect the X-Box to the internet via your router.  

Check all the values and click Save Settings to save your settings. Click Cancel Changes to cancel your unsaved changes.

