
/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.access_functions.conf,v 1.6 2003/09/11 22:48:49 rstory Exp $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "qos_access.h"
#include "qos_enums.h"
#include "qos_checkfns.h"
#include "unistd.h"

/** returns the first data point within the qosObjectTable table data.

    Set the my_loop_context variable to the first data point structure
    of your choice (from which you can find the next one).  This could
    be anything from the first node in a linked list, to an integer
    pointer containing the beginning of an array variable.

    Set the my_data_context variable to something to be returned to
    you later that will provide you with the data to return in a given
    row.  This could be the same pointer as what my_loop_context is
    set to, or something different.

    The put_index_data variable contains a list of snmp variable
    bindings, one for each index in your table.  Set the values of
    each appropriately according to the data matching the first row
    and return the put_index_data variable at the end of the function.
*/
netsnmp_variable_list *
qosObjectTable_get_first_data_point(void **my_loop_context,
                                    void **my_data_context,
                                    netsnmp_variable_list * put_index_data,
                                    netsnmp_iterator_info *mydata)
{
    extern struct qos_table table;
    netsnmp_variable_list *vptr;

    update_qos_table_data(&table);
    
    *my_loop_context = &table;
    *my_data_context = &(table.data);

    vptr = put_index_data;
    
    snmp_set_var_value(vptr, (u_char *) &(table.data.device_type) /** XXX: qosDeviceIndex data */ ,
//                       sizeof(long)/** XXX: length of qosDeviceType data */ );
                       sizeof(ASN_INTEGER)/** XXX: length of qosDeviceIndex data */ );
    vptr = vptr->next_variable;
    snmp_set_var_value(vptr, (u_char *) &(table.data.device_index) /** XXX: qosDeviceIndex data */ ,
//                       sizeof(long)/** XXX: length of qosDeviceIndex data */ );
                       sizeof(ASN_INTEGER)/** XXX: length of qosDeviceIndex data */ );
    vptr = vptr->next_variable;
    snmp_set_var_value(vptr, (u_char *) &(table.data.majorhandle) /** XXX: qosMajorHandle data */ ,
                       sizeof(ASN_UNSIGNED)/** XXX: length of qosMajorHandle data */ );
//                       sizeof(int)/** XXX: length of qosHandle data */ );
    vptr = vptr->next_variable;
    snmp_set_var_value(vptr, (u_char *) &(table.data.minorhandle) /** XXX: qosMinorHandle data */ ,
                       sizeof(ASN_UNSIGNED)/** XXX: length of qosMinorHandle data */ );
//                       sizeof(int)/** XXX: length of qosHandle data */ );
    vptr = vptr->next_variable;

    return put_index_data;
}

/** functionally the same as qosObjectTable_get_first_data_point, but
   my_loop_context has already been set to a previous value and should
   be updated to the next in the list.  For example, if it was a
   linked list, you might want to cast it to your local data type and
   then return my_loop_context->next.  The my_data_context pointer
   should be set to something you need later and the indexes in
   put_index_data updated again. */
netsnmp_variable_list *
qosObjectTable_get_next_data_point(void **my_loop_context,
                                   void **my_data_context,
                                   netsnmp_variable_list * put_index_data,
                                   netsnmp_iterator_info *mydata)
{
    netsnmp_variable_list *vptr;
    qos_table *table;    

    table = (struct qos_table*)*my_loop_context;

    if(table->next==NULL) {
	return(NULL);
    }

    table = table->next;	
    *my_loop_context = table; 
    *my_data_context = &(table->data);

    vptr = put_index_data;

    snmp_set_var_value(vptr, (u_char *) &((table->data).device_type) /** XXX: qosDeviceType data */ ,
                       sizeof(ASN_INTEGER)/** XXX: length of qosDeviceType data */ );
    vptr = vptr->next_variable;
    snmp_set_var_value(vptr, (u_char *) &((table->data).device_index) /** XXX: qosDeviceIndex data */ ,
                       sizeof(ASN_INTEGER)/** XXX: length of qosDeviceIndex data */ );
    vptr = vptr->next_variable;
    snmp_set_var_value(vptr, (u_char *) &((table->data).majorhandle) /** XXX: qosMajorHandle data */ ,
                       sizeof(ASN_UNSIGNED)/** XXX: length of qosMajorHandle data */ );
    vptr = vptr->next_variable;
    snmp_set_var_value(vptr, (u_char *) &((table->data).minorhandle) /** XXX: qosMinorHandle data */ ,
                       sizeof(ASN_UNSIGNED)/** XXX: length of qosMinorHandle data */ );
    vptr = vptr->next_variable;
    
    return put_index_data;
}

/** Create a data_context for non-existent rows that SETs are performed on.
 *  return a void * pointer which will be passed to subsequent get_XXX
 *  and set_XXX functions for data retrival and modification during
 *  this SET request.
 *
 *  The indexs are encoded (in order) into the index_data pointer if it
 *  would be helpful to use that information.
 */
void           *
qosObjectTable_create_data_context(netsnmp_variable_list * index_data)
{
    return NULL;                /* XXX: you likely want to return a real pointer */
}

/** If the implemented set_* functions don't operate directly on the
   real-live data (which is actually recommended), then this function
   can be used to take a given my_data_context pointer and "commit" it
   to whereever the modified data needs to be put back to.  For
   example, if this was a routing table you could publish the modified
   routes back into the kernel at this point.

   new_or_del will be set to 1 if new, or -1 if it should be deleted
   or 0 if it is just a modification of an existing row.

   If you free the data yourself, make sure to *my_data_context = NULL */
int
qosObjectTable_commit_row(void **my_data_context, int new_or_del)
{
    /** Add any necessary commit code here 
     * return no errors.  And there shouldn't be any!!!  Ever!!!  You
     * should have checked the values long before this. 
     */
    return SNMP_ERR_NOERROR;
}



// functions that return pointers to real data from qos structure (see qos_checkfns.h)

long           *
get_qosDeviceType(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosDeviceType\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(long);
    return(&(data->device_type));
}

long           *
get_qosDeviceIndex(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosDeviceIndex\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(long);
    return(&(data->device_index));
}

/** XXX: return a data pointer to the data for the qosHandle column and set
         ret_len to its proper size in bytes. */
u_long           *
get_qosMajorHandle(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosHandle\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->majorhandle));    
}

u_long           *
get_qosMinorHandle(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosHandle\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->minorhandle));    
}

char *get_qosTextHandle(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosTextHandle\n");
    data=(struct qos_data*)data_context;
    if(data->text_handle==NULL) { return(NULL); }
    *ret_len=sizeof(char)*strlen(data->text_handle);
    return((data->text_handle));
}

char *get_qosTextLeaf(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosTextLeaf\n");
    data=(struct qos_data*)data_context;
    if(data->text_leaf==NULL) { return(NULL); }
    *ret_len=sizeof(char)*strlen(data->text_leaf);
    return((data->text_leaf));
}

u_long           *
get_qosParent(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosParent\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->parent));    
}

char *get_qosTextParent(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosTextParent\n");
    data=(struct qos_data*)data_context;
    if(data->text_parent==NULL) { return(NULL); }
    *ret_len=sizeof(char)*strlen(data->text_parent);
    return((data->text_parent));
}

/** XXX: return a data pointer to the data for the qosDeviceName column and set
         ret_len to its proper size in bytes. */

char *get_qosDeviceName(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosDeviceName\n");
    data=(struct qos_data*)data_context;
    if(data->dev_name==NULL) { return(NULL); }
    *ret_len=sizeof(char)*strlen(data->dev_name);
    return((data->dev_name));
}

/** XXX: return a data pointer to the data for the qosType column and set
         ret_len to its proper size in bytes. */
char *get_qosType(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosType\n");
    data=(struct qos_data*)data_context;
    if(data->type==NULL) { return(NULL); }
    *ret_len=sizeof(char)*strlen(data->type);
    return((data->type));
}

/** XXX: return a data pointer to the data for the qosBytes column and set
         ret_len to its proper size in bytes. */
unsigned long long         *
get_qosBytes(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosBytes\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(unsigned long long);
    return(&(data->qosBytes));
}

/** XXX: return a data pointer to the data for the qosPackets column and set
         ret_len to its proper size in bytes. */
u_long         *
get_qosPackets(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosPackets\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->qosPackets));
}

/** XXX: return a data pointer to the data for the qosDropped column and set
         ret_len to its proper size in bytes. */
u_long         *
get_qosDropped(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosDropped\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->qosDropped));
}

/** XXX: return a data pointer to the data for the qosOverlimit column and set
         ret_len to its proper size in bytes. */
u_long         *
get_qosOverlimit(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosOverlimit\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->qosOverlimit));
}

/** XXX: return a data pointer to the data for the qosBps column and set
         ret_len to its proper size in bytes. */
u_long         *
get_qosBps(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosBps\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->qosBps));
}

/** XXX: return a data pointer to the data for the qosPps column and set
         ret_len to its proper size in bytes. */
u_long         *
get_qosPps(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosPps\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->qosPps));
}

/** XXX: return a data pointer to the data for the qosQlen column and set
         ret_len to its proper size in bytes. */
u_long         *
get_qosQlen(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//   snmp_log(LOG_NOTICE,"get_qosQlen\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->qosQlen));
}

/** XXX: return a data pointer to the data for the qosBacklog column and set
         ret_len to its proper size in bytes. */
u_long         *
get_qosBacklog(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosBacklog\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->qosBacklog));
}

/** XXX: return a data pointer to the data for the redEarly column and set
         ret_len to its proper size in bytes. */
u_long         *
get_redEarly(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_redEarly\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->redEarly));
}

/** XXX: return a data pointer to the data for the redPdrop column and set
         ret_len to its proper size in bytes. */
u_long         *
get_redPdrop(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_redPdrop\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->redPdrop));
}

/** XXX: return a data pointer to the data for the redOther column and set
         ret_len to its proper size in bytes. */
u_long         *
get_redOther(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_redOther\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->redOther));
}

/** XXX: return a data pointer to the data for the redMarked column and set
         ret_len to its proper size in bytes. */
u_long         *
get_redMarked(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_redMarked\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->redMarked));
}

/** XXX: return a data pointer to the data for the htbLends column and set
         ret_len to its proper size in bytes. */
u_long         *
get_htbLends(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_htbLends\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->htbLends));
}

/** XXX: return a data pointer to the data for the htbBorrows column and set
         ret_len to its proper size in bytes. */
u_long         *
get_htbBorrows(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_htbBorrows\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->htbBorrows));
}

/** XXX: return a data pointer to the data for the htbGiants column and set
         ret_len to its proper size in bytes. */
u_long         *
get_htbGiants(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_htbGiants\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->htbGiants));
}

/** XXX: return a data pointer to the data for the htbTokens column and set
         ret_len to its proper size in bytes. */
u_long         *
get_htbTokens(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_htbTokens\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->htbTokens));
}

/** XXX: return a data pointer to the data for the htbCTokens column and set
         ret_len to its proper size in bytes. */
u_long         *
get_htbCTokens(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_htbCTokens\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->htbCTokens));
}

/** XXX: return a data pointer to the data for the htbRate column and set
         ret_len to its proper size in bytes. */
u_long         *
get_htbRate(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_htbRate\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->htbRate));
}

/** XXX: return a data pointer to the data for the htbCeil column and set
         ret_len to its proper size in bytes. */
u_long         *
get_htbCeil(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_htbCeil\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->htbCeil));
}

/** XXX: return a data pointer to the data for the htbPrio column and set
         ret_len to its proper size in bytes. */
u_long         *
get_htbPrio(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_htbPrio\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->htbPrio));
}

/** XXX: return a data pointer to the data for the cbqBorrows column and set
         ret_len to its proper size in bytes. */
u_long         *
get_cbqBorrows(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_cbqBorrows\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->cbqBorrows));
}

/** XXX: return a data pointer to the data for the cbqOveractions column and set
         ret_len to its proper size in bytes. */
u_long         *
get_cbqOveractions(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_cbqOveractions\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->cbqOveractions));
}

/** XXX: return a data pointer to the data for the cbqAvgidle column and set
         ret_len to its proper size in bytes. */
long         *
get_cbqAvgidle(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_cbqAvgidle\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->cbqAvgidle));
}

/** XXX: return a data pointer to the data for the cbqUndertime column and set
         ret_len to its proper size in bytes. */
long         *
get_cbqUndertime(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_cbqUndertime\n");
    data=(struct qos_data*)data_context;
    *ret_len=sizeof(u_long);
    return(&(data->cbqUndertime));
}

char *get_qosInfo(void *data_context, size_t * ret_len)
{
    struct qos_data *data;
//    snmp_log(LOG_NOTICE,"get_qosTextHandle\n");
    data=(struct qos_data*)data_context;
    if(data->text_handle==NULL) { return(NULL); }
    *ret_len=sizeof(char)*strlen(data->info);
    return((data->info));
}

