/*
 * Broadcom Home Gateway Reference Design
 * Broadcom Web Page Configuration Variables
 *
 * Copyright 2004, Broadcom Corporation
 * All Rights Reserved.
 * 
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.
 * $Id: bcmcvar.h,v 1.1.1.1 2004/05/11 08:09:00 honor Exp $
 */

#ifndef _bcmcvar_h
#define _bcmcvar_h

struct variable {
	char *name;
	char *longname;
	void (*validate)(webs_t wp, char *value, struct variable *v);
	char **argv;
	int nullok;
	int ezc_flags;
};

#define POST_BUF_SIZE	10000

#define websBufferInit(wp) webs_buf_offset = 0;
#define websBufferWrite(wp, fmt, args...) webs_buf_offset += sprintf(webs_buf+webs_buf_offset, fmt, ## args);
#define websBufferFlush(wp) {webs_buf[webs_buf_offset] = '\0'; fprintf(wp, webs_buf); fflush(wp); }

#define ARGV(args...) ((char *[]) { args, NULL })
#define XSTR(s) STR(s)
#define STR(s) #s

int variables_arraysize(void);

#endif /* _bcmcvar_h */
