
/*
 *********************************************************
 *   Copyright 2004, CyberTAN  Inc.  All Rights Reserved *
 *********************************************************

 This is UNPUBLISHED PROPRIETARY SOURCE CODE of CyberTAN Inc.
 the contents of this file may not be disclosed to third parties,
 copied or duplicated in any form without the prior written
 permission of CyberTAN Inc.

 This software should be used as a reference only, and it not
 intended for production use!


 THIS SOFTWARE IS OFFERED "AS IS", AND CYBERTAN GRANTS NO WARRANTIES OF ANY
 KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE.  CYBERTAN
 SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE
*/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>

#include <typedefs.h>
#include <bcmnvram.h>
#include <shutils.h>
#include <wlioctl.h>
#include <wlutils.h>

#define sys_restart() kill(1, SIGHUP)
#define SITE_SURVEY_DB	"/tmp/site_survey"
#define SITE_SURVEY_NUM	50

int write_site_survey(void);
int open_site_survey(void);
int write_site_survey(void);

struct site_survey_list {
	uint8		SSID[32];
	unsigned char   BSSID[18];
	uint8		channel;	/* Channel no. */
	int16		RSSI;		/* receive signal strength (in dBm) */
	int8		phy_noise;	/* noise (in dBm) */
	uint16		beacon_period;	/* units are Kusec */
	uint16		capability;	/* Capability information */
	uint		rate_count;	/* # rates in this set */
        uint8           dtim_period;    /* DTIM period */
} site_survey_lists[SITE_SURVEY_NUM];

int
site_survey_main(int argc, char *argv[])
{
	char *name = nvram_safe_get("wl0_ifname");
	unsigned char buf[10000];
	wl_scan_results_t *scan_res = (wl_scan_results_t *)buf;
	wl_bss_info_t *bss_info;
	unsigned char mac[20];
	int i;
	int ret;
	puts("switch radio");
	eval("wl", "radio", "on");
	eval("wl", "ap", "0");
	sleep(2);
	
	bzero(buf, sizeof(buf));
	bzero(site_survey_lists, sizeof(site_survey_lists));
	puts("delete survey db");
	unlink(SITE_SURVEY_DB);
	puts("scanning");
	if (wl_ioctl(name, WLC_SCAN, buf, sizeof(buf)) < 0)
		goto endss;
	sleep(1);
	scan_res->buflen = sizeof(buf);
	puts("scan results");
	ret = wl_ioctl(name, WLC_SCAN_RESULTS, buf, sizeof(buf));
	
	printf("buflen=[%d] version=[%d] count=[%d]\n", scan_res->buflen, scan_res->version, scan_res->count);
	
	if(scan_res->count == 0){
		cprintf("Can't find any wireless device\n");
		goto endss;
	}

	bss_info = &scan_res->bss_info[0];
	puts("create db");
	for(i=0 ; i<scan_res->count ; i++){
		strcpy(site_survey_lists[i].SSID, bss_info->SSID);
		strcpy(site_survey_lists[i].BSSID, ether_etoa(bss_info->BSSID.octet, mac));
		site_survey_lists[i].channel = bss_info->channel;
		site_survey_lists[i].RSSI = bss_info->RSSI;
		site_survey_lists[i].phy_noise = bss_info->phy_noise;
		site_survey_lists[i].beacon_period = bss_info->beacon_period;
		site_survey_lists[i].capability = bss_info->capability;
		site_survey_lists[i].rate_count = bss_info->rateset.count;
		site_survey_lists[i].dtim_period = bss_info->dtim_period;

		bss_info =  (wl_bss_info_t *)((uint32)bss_info + bss_info->length);
	}
	puts("write db");
	write_site_survey();
	open_site_survey();
	for(i=0 ; i<SITE_SURVEY_NUM && site_survey_lists[i].SSID[0] ; i++){
	printf("[%2d] SSID[%20s] BSSID[%s] channel[%2d] rssi[%d] noise[%d] beacon[%d] cap[%x] dtim[%d] rate[%d]\n",
		i,
		site_survey_lists[i].SSID,
		site_survey_lists[i].BSSID,
		site_survey_lists[i].channel,
		site_survey_lists[i].RSSI,
		site_survey_lists[i].phy_noise,
		site_survey_lists[i].beacon_period,
		site_survey_lists[i].capability,
		site_survey_lists[i].dtim_period,
		site_survey_lists[i].rate_count);
	}

endss:
        puts("switch back");
	if(!nvram_match("wl_mode", "sta") && !nvram_match("wl_mode", "wet")) {
		eval("wl", "ap", "1");
		/* stop_services();
		stop_lan();
		eval("wlconf", nvram_safe_get("wl0_ifname"), "up");
		start_lan();
		C_led(1);
		start_services(); */
		C_led(1);
		sys_restart();
	}
	sleep(3);
	C_led(0);
	return 0;
}

int
write_site_survey(void)
{
        FILE *fp;

        if((fp = fopen(SITE_SURVEY_DB, "w"))){
                fwrite(&site_survey_lists[0], sizeof(site_survey_lists), 1, fp);
                fclose(fp);
                return FALSE;
        }
        return TRUE;
}

int
open_site_survey(void)
{
        FILE *fp;
	
	bzero(site_survey_lists, sizeof(site_survey_lists));

        if((fp = fopen(SITE_SURVEY_DB, "r"))){
                fread(&site_survey_lists[0], sizeof(site_survey_lists), 1, fp);
                fclose(fp);
                return TRUE;
        }
        return FALSE;
}
