/*
 *	openssl.h
 *	Release $Name: MATRIXSSL_1_0_BETA $
 *
 *	MatrixSSL OpenSSL compatibility layer. http://www.openssl.org
 *	This layer allows optimized OpenSSL hardware cryptography libraries
 *	to be linked with MatrixSSL.
 *
 *	Copyright (c) PeerSec Networks, 2002-2004. All Rights Reserved.
 *	The latest version of this code is available at http://www.matrixssl.org
 *
 *	This software is open source; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This General Public License does NOT permit incorporating this software 
 *	into proprietary programs.  If you are unable to comply with the GPL, a 
 *	commercial license for this software may be purchased from PeerSec Networks
 *	at http://www.peersec.com
 *	
 *	This program is distributed in WITHOUT ANY WARRANTY; without even the 
 *	implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 *	See the GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *	http://www.gnu.org/copyleft/gpl.html
 */
 /******************************************************************************/

#ifndef _h_OPENSSL_LAYER
#define _h_OPENSSL_LAYER

#ifdef __cplusplus
extern "C" {
#endif

#include <openssl/err.h>
#include <openssl/ssl.h>
#include <openssl/evp.h>
#include <openssl/rand.h>
#include <openssl/hmac.h>

/*
	The layered crypto providers must provide typedefs for the following:
		sslMd5Context_t
		sslSha1Context_t
		sslCipherContext_t
		sslRsaKey_t
*/

//FUTURE - support for more ciphers
typedef struct {
	RC4_KEY		rc4;
} cipherWrapper_t;

typedef cipherWrapper_t	sslCipherContext_t;

typedef MD5_CTX			sslMd5Context_t;
typedef SHA_CTX			sslSha1Context_t;
typedef RSA				sslRsaKey_t;

#ifdef __cplusplus
}
#endif

#endif /* _h_OPENSSL_LAYER */

/******************************************************************************/
