/*
 * nf_conntrack_ftp.h
 *
 * Definitions and Declarations for FTP tracking.
 *
 * Derived from include/linux/netfiter_ipv4/ip_conntrack_ftp.h
 *
 * 16 Dec 2003: Yasuyuki Kozakai @ USAGI <yasuyuki.kozakai@toshiba.co.jp>
 *	- IPv6 support.
 */

#ifndef _NF_CONNTRACK_FTP_H
#define _NF_CONNTRACK_FTP_H
/* FTP tracking. */

#ifdef __KERNEL__

#include <linux/netfilter_ipv4/lockhelp.h>

/* Protects ftp part of conntracks */
DECLARE_LOCK_EXTERN(ip_ftp_lock);

#define FTP_PORT	21

#endif /* __KERNEL__ */

enum nf_ct_ftp_type
{
	/* PORT command from client */
	NF_CT_FTP_PORT,
	/* PASV response from server */
	NF_CT_FTP_PASV,
	/* EPRT command from client */
	NF_CT_FTP_EPRT,
	/* EPSV response from server */
	NF_CT_FTP_EPSV,
};

#define NUM_SEQ_TO_REMEMBER	2
/* This structure exists only once per master */
struct nf_ct_ftp_master {
	/* Valid seq positions for cmd matching after newline */
	u_int32_t seq_aft_nl[NF_CT_DIR_MAX][NUM_SEQ_TO_REMEMBER];
	/* 0 means seq_match_aft_nl not set */
	int seq_aft_nl_num[NF_CT_DIR_MAX];
};

struct nf_conntrack_expect;

/* For NAT to hook in when we find a packet which describes what other
 * connection we should expect. */
extern unsigned int (*nf_nat_ftp_hook)(struct sk_buff **pskb,
				       enum nf_conntrack_info ctinfo,
				       enum nf_ct_ftp_type type,
				       unsigned int matchoff,
				       unsigned int matchlen,
				       struct nf_conntrack_expect *exp,
				       u32 *seq);
#endif /* _NF_CONNTRACK_FTP_H */
