
#include <stdlib.h>
#include <unistd.h>

#include <metadict.h>
#include <metaops.h>	/* For META_AV etc. */

#include <debug.h>


int main()
{
	char *input, *output;
	ssize_t inplen, outlen;
	META *m;
	META_SPC *spc;
	META_AV *avlist, *tail, *av;

	msg_init(-1, 0);

	inplen = 20 + 6 + 6 + 9 + 8 + 6 + 0x16 + 0xe + 6 + 0xb;
	inplen = 42;
	input = 
"\x02\x22\x00\x2a\xd2\x23\xf7\x70\x82\x43\x6d\x23\xd9\x3a\x50\x7b\x9f\x07\xa6\x58\x55\x06\x00\x00\x02\x58\x1c\x06\x00\x00\x03\x84\x1b\x06\x00\x01\x51\x80\x21\x04\x33\x34";

	/*
	input = "\x01\xaa\x00\x6c"
	        "ABCDEFGHIJKLMNOP"
		"\x06\x06\x00\x00\x00\x02"
		"\x07\x06\x00\x00\x00\x02"
	        "\x20\x09TestNas"
	        "\x01\x08Myself"
		"\x04\x06\xc0\xa8\x05\xfe"
		"\x1a\x16" "\x00\x00\x00\x09" "\x01\x08" "TEST 1"
				              "\x01\x08" "TEST 2"
		"\x1a\x0e" "\x00\x00\x00\x09" "\x01\x08" "TEST 3"
	        "\x05\x06\x00\x00\x00\x05"
		"\x02\x0bs3cret\x01\x02\x03";
	    */

	outlen = 16384;
	output = (char *)malloc(outlen);
	if (!output) {
		msg(F_MISC, L_ERR, "main: ERROR: Could not alloc message!\n");
		return 1;
	}

	m = meta_newfromdict("../../raddb");	/* Use as base path */
	if (!m) {
		msg(F_MISC, L_ERR, "main: ERROR: Could not open dictionary!\n");
		return 1;
	}

	spc = meta_getspcbyname(m, "RAD-PKT");
	if (!spc) { 
		msg(F_MISC, L_ERR, "main: ERROR: Space 'RAD-PKT' not found!\n");
		return 1;
	}

	msg_setthresh(F_RECV, L_DEBUG + 1);
	avlist = meta_decode(m, spc, 0, input, inplen, &tail);
	if (!avlist) {
		msg(F_MISC, L_ERR, "main: ERROR: error decoding data!\n");
		return 1;
	}

	for(av = avlist; av; av = av->next) av->flags |= AV_DEL; 

	av = (META_AV *)malloc(sizeof(META_AV));
	if (!av) {
		msg(F_MISC, L_ERR, "main: ERROR: Could not alloc pair!\n");
		return 1;
	}
	memset(av, 0, sizeof(META_AV));
	av->i = meta_getitembyspec(m, "Proxy-State");
	av->l = 3;
	av->p = "hoi";
	meta_addav(&avlist, &tail, 0, 0, av);

	outlen = meta_avtomsg(m, avlist, output, outlen, AVMSG_ASCII
		+ AVMSG_ADDTAB + AVMSG_ADDSPACES + AVMSG_ADDTYPE
		+ AVMSG_ADDIGNORE, 0);
	write(1, output, outlen);
	meta_freeavlist(avlist);
	meta_del(m);
	free(output);

	return 0;
}
