
<!--
*********************************************************
*   Copyright 2003, CyberTAN  Inc.  All Rights Reserved *
*********************************************************

This is UNPUBLISHED PROPRIETARY SOURCE CODE of CyberTAN Inc.
the contents of this file may not be disclosed to third parties,
copied or duplicated in any form without the prior written
permission of CyberTAN Inc.

This software should be used as a reference only, and it not
intended for production use!


THIS SOFTWARE IS OFFERED "AS IS", AND CYBERTAN GRANTS NO WARRANTIES OF ANY
KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE.  CYBERTAN
SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE
-->

<HTML><HEAD><TITLE><% nvram_get("router_name"); %> - Setup</TITLE>
<% no_cache(); %>
<META http-equiv=Content-Type content="text/html; charset=iso-8859-1">
<link rel="stylesheet" type="text/css" href="style.css">
<style fprolloverstyle>
A:hover {color: #00FFFF}
.small A:hover {color: #00FFFF}
</style>
<script src="common.js"></script>
<SCRIPT language=JavaScript>
var EN_DIS2 = '<% nvram_get("mtu_enable"); %>';
var wan_proto = '<% nvram_get("wan_proto"); %>';
var dhcp_win = null;

function valid_mtu(I)
{
	var start = null;
	var end = null;
	if(wan_proto == "pppoe"){
		start = 576;
		end = 1492;
	}
	else if(wan_proto == "pptp" || wan_proto == "l2tp") {
		start = 1200;
                end = 1400;
	}
	else{
		start = 576;
		end = 1500;
	}

	valid_range(I,start,end,"MTU");
}
function SelMTU(num,F)
{
	mtu_enable_disable(F,num);
}
function mtu_enable_disable(F,I)
{
	EN_DIS1 = I;
	if ( I == "0" ){
		choose_disable(F.wan_mtu);
	}
	else{
		choose_enable(F.wan_mtu);
	}
}


function SelWAN(num,F)
{
        F.submit_button.value = "index";
        F.change_action.value = "gozila_cgi";
        F.wan_proto.value=F.wan_proto.options[num].value;
        F.submit();
}

function SelPPP(num,F)
{
        F.submit_button.value = "index";
        F.change_action.value = "gozila_cgi";
        F.mpppoe_enable.value = F.mpppoe_enable.options[num].value;
        F.submit();
}

function to_submit(F)
{
	if(valid_value(F)){
		if(F._daylight_time.checked == false)
			F.daylight_time.value = 0;
		else
			F.daylight_time.value = 1;
 
		F.submit_button.value = "index";
		F.action.value = "Apply";
        	F.submit();
	}
}
function valid_value(F)
{
	if(F.now_proto.value == "pptp" || F.now_proto.value == "static"){

		pptp_dhcp = "";

		// Sveasoft: allow 0.0.0.0 for pptp. We'll let DHCP take care of it.
		if (F.now_proto.value == "pptp" &&
		    F.wan_ipaddr_0.value == "0" && F.wan_ipaddr_1.value == "0" && F.wan_ipaddr_2.value == "0" && F.wan_ipaddr_3.value == "0")
			pptp_dhcp = "skip";

		if(pptp_dhcp != "skip" && !valid_ip(F,"F.wan_ipaddr","IP",ZERO_NO|MASK_NO))
                        return false;

		if(pptp_dhcp != "skip" && !valid_mask(F,"F.wan_netmask",ZERO_NO|BCST_NO))
			return false;

		if(F.now_proto.value == "static"){
			if(!valid_ip(F,"F.wan_gateway","Gateway",ZERO_NO|MASK_NO))
              		  	return false;
		}

		if(pptp_dhcp != "skip" && F.now_proto.value == "pptp"){
			if(!valid_ip(F,"F.pptp_server_ip","Gateway",ZERO_NO|MASK_NO))
                		return false;
			if(!valid_ip_gw(F,"F.wan_ipaddr","F.wan_netmask","F.pptp_server_ip"))
				return false;
		}

	}
	if(F.now_proto.value == "pppoe" || F.now_proto.value == "pptp" || F.now_proto.value == "l2tp"){
		if(F.ppp_username.value == ""){
			alert("You must input a username!");
			F.ppp_username.focus();
			return false;
		}
		//if(F.ppp_passwd.value == ""){
		//	alert("You must input a passwd!");
		//	F.ppp_passwd.focus();
		//	return false;
		//}
	}

	if(!valid_dhcp_server(F))
		return false;

	if(F.router_name.value == ""){
		alert("You must input a Router Name!");
                F.router_name.focus();
                return false;
	}

	return true;
}
function valid_dhcp_server(F)
{
	if(F.lan_proto.selectedIndex == 0)
                return true;

        a1 = parseInt(F.dhcp_start.value,10);
        a2 = parseInt(F.dhcp_num.value,10);
        if(a1 + a2 > 255){
                alert("Out of range, please adjust start IP address or user's numbers.");
                return false;
        }

        if(!valid_ip(F,"F.wan_dns0","DNS",MASK_NO))
                return false;
        if(!valid_ip(F,"F.wan_dns1","DNS",MASK_NO))
                return false;
        if(!valid_ip(F,"F.wan_dns2","DNS",MASK_NO))
                return false;
        if(!valid_ip(F,"F.wan_wins","WINS",MASK_NO))
                return false;

	return true;
}
function SelDHCP(T,F)
{
	dhcp_enable_disable(F,T);
}

function dhcp_enable_disable(F,T)
{
	var start = '';
	var end = '';
 	var total = F.elements.length;
	for(i=0 ; i < total ; i++){
		if(F.elements[i].name == "dhcp_start")	start = i;
		if(F.elements[i].name == "wan_wins_3")	end = i;
	}
	if(start == '' || end == '')	return true;

	if( T == "static" ) {
		EN_DIS = 0;
		for(i = start; i<=end ;i++)
			choose_disable(F.elements[i]);
	}
	else {
		EN_DIS = 1;
		for(i = start; i<=end ;i++)
			choose_enable(F.elements[i]);
	}
}
function SelTime(num,f)
{
	aaa = f.time_zone.options[num].value.charAt(6);
	daylight_enable_disable(f,aaa);
}

function ppp_enable_disable(F,I)
{
	if( I == "0"){
		choose_disable(F.ppp_idletime);
		choose_enable(F.ppp_redialperiod);
	}
	else{
		choose_enable(F.ppp_idletime);
		choose_disable(F.ppp_redialperiod);
	}
}
function daylight_enable_disable(F,aaa)
{
	if(aaa == 0){
                F._daylight_time.checked = false;
                choose_disable(F._daylight_time);
                F.daylight_time.value = 0;
        }
        else{
                choose_enable(F._daylight_time);                
                F._daylight_time.checked = true;
                F.daylight_time.value = 1;
        }

}
function init()
{
	mtu_enable_disable(document.setup,'<% nvram_get("mtu_enable"); %>');
	aaa = document.setup.time_zone.options[document.setup.time_zone.selectedIndex].value.charAt(6);
	if(aaa == 0){
                document.setup._daylight_time.checked = false;
                choose_disable(document.setup._daylight_time);
                document.setup.daylight_time.value = 0;
        }

	if(document.setup.now_proto.value == "pppoe" || document.setup.now_proto.value == "pptp" || document.setup.now_proto.value == "l2tp" || document.setup.now_proto.value == "heartbeat")
		ppp_enable_disable(document.setup,'<% nvram_get("ppp_demand"); %>');

	dhcp_enable_disable(document.setup,'<% nvram_get("lan_proto"); %>');

}
</SCRIPT>
</HEAD>
<BODY onload=init()>
<DIV align=center>
<FORM name=setup method=<% get_http_method(); %> action=apply.cgi>
<input type=hidden name=submit_button>
<input type=hidden name=change_action>
<input type=hidden name=submit_type>
<input type=hidden name=action>
<input type=hidden name=now_proto value='<% nvram_gozila_get("wan_proto"); %>'>
<input type=hidden name=daylight_time value=0>
<input type=hidden name="lan_ipaddr" value="4">

<TABLE cellSpacing=0 cellPadding=0 width=809 border=0>
  <TBODY>
  <TR>
    <TD width=95>
    <IMG src="image/UI_Linksys.gif"
      border=0 width="165" height="57"></TD>
    <TD vAlign=bottom align=right width=714 bgColor=#6666cc><FONT
      style="FONT-SIZE: 7pt"><FONT face=Arial><font color=#AAAAAA><br>Firmware version:&nbsp;</font><FONT Color=#FFFFFF><% get_firmware_version(); %>&nbsp;&nbsp;&nbsp;</font></FONT></TD></TR>

  <TR>
    <TD width=808 bgColor=#6666cc colSpan=2>
    <IMG height=11
      src="image/UI_10.gif" width=809 border=0></TD></TR></TBODY></TABLE>
<TABLE height=77 cellSpacing=0 cellPadding=0 width=809 bgColor=black border=0>
  <TBODY>
  <TR>
    <TD 
    style="FONT-WEIGHT: normal; FONT-SIZE: 10pt; COLOR: black; FONT-STYLE: normal; FONT-FAMILY: Arial, Helvetica, sans-serif; FONT-VARIANT: normal" 
    borderColor=#000000 align=middle width=163 height=49>
      <H3 style="MARGIN-TOP: 1px; MARGIN-BOTTOM: 1px"><FONT
      style="FONT-SIZE: 15pt" face=Arial color=#ffffff>Setup</FONT></H3></TD>
    <TD 
    style="FONT-WEIGHT: normal; FONT-SIZE: 10pt; COLOR: black; FONT-STYLE: normal; FONT-FAMILY: Arial, Helvetica, sans-serif; FONT-VARIANT: normal" 
    vAlign=center borderColor=#000000 width=646 bgColor=#000000 height=49>
      <TABLE 
      style="FONT-WEIGHT: normal; FONT-SIZE: 10pt; COLOR: black; FONT-STYLE: normal; FONT-FAMILY: Arial, Helvetica, sans-serif; BORDER-COLLAPSE: collapse; FONT-VARIANT: normal"
      height=33 cellSpacing=0 cellPadding=0 bgColor=#6666cc border=0>
        <TBODY>
        <TR>
          <TD style="FONT-WEIGHT: bolder; FONT-SIZE: 10pt" align=right 
          bgColor=#6666cc height=33><FONT color=#ffffff> Wireless-G Broadband Router&nbsp;&nbsp;</FONT></TD>
          <TD borderColor=#000000 borderColorLight=#000000 align=middle 
          width=109 bgColor=#000000 borderColorDark=#000000 height=12
            rowSpan=2><FONT color=#ffffff><SPAN 
            style="FONT-SIZE: 8pt"><B><% nvram_get("router_name"); %></B></SPAN></FONT></TD></TR>
        <TR>
          <TD 
          style="FONT-WEIGHT: normal; FONT-SIZE: 1pt; COLOR: black; FONT-STYLE: normal; FONT-FAMILY: Arial, Helvetica, sans-serif; FONT-VARIANT: normal" 
          width=537 bgColor=#000000 height=1>&nbsp;</TD></TR>
        <TR>
          <TD width=646 bgColor=#000000 colSpan=2 height=32>
            <TABLE id=AutoNumber1
            style="FONT-WEIGHT: normal; FONT-SIZE: 10pt; COLOR: black; FONT-STYLE: normal; FONT-FAMILY: Arial, Helvetica, sans-serif; BORDER-COLLAPSE: collapse; FONT-VARIANT: normal" 
            height=6 cellSpacing=0 cellPadding=0 width=637 border=0>
              <TBODY>
              <TR 
              style="BORDER-RIGHT: medium none; BORDER-TOP: medium none; FONT-WEIGHT: normal; FONT-SIZE: 1pt; BORDER-LEFT: medium none; COLOR: black; BORDER-BOTTOM: medium none; FONT-STYLE: normal; FONT-FAMILY: Arial, Helvetica, sans-serif; FONT-VARIANT: normal" 
              align=middle bgColor=#6666cc>
                <TD width=83 height=1>
                <IMG height=10 
                  src="image/UI_07.gif" width=83 border=0></TD>
                <TD width=73 height=1>
                <IMG height=10 
                  src="image/UI_06.gif" width=83 border=0></TD>
                <TD width=113 height=1>
                <IMG height=10 
                  src="image/UI_06.gif" width=83 border=0></TD>
                <TD width=103 height=1>
                <IMG height=10
                  src="image/UI_06.gif" width=103 border=0></TD>
                <TD width=85 height=1>
                <IMG height=10 
                  src="image/UI_06.gif" width=100 border=0></TD>
                <TD width=115 height=1>
                <IMG height=10 
                  src="image/UI_06.gif" width=115 border=0></TD>
                <TD width=74 height=1>
                <IMG height=10 
                  src="image/UI_06.gif" width=79 border=0></TD></TR>
              <TR>
                <TD align=middle bgColor=#6666cc height=20><FONT 
                  style="FONT-WEIGHT: 700" color=#ffffff>
                <A 
                  style="TEXT-DECORATION: none" 
                  href="index.asp">Setup</A></FONT></TD>
                <TD align=middle bgColor=#000000 height=20><FONT
                  style="FONT-WEIGHT: 700" color=#ffffff>
                <a style="TEXT-DECORATION: none" href="Wireless_Basic.asp">Wireless</a></FONT></TD>
                <TD align=middle bgColor=#000000 height=20><FONT 
                  style="FONT-WEIGHT: 700" color=#ffffff>
                <a style="TEXT-DECORATION: none" href="Firewall.asp">Security</a></FONT></TD>
                <TD align=middle bgColor=#000000 height=20><FONT 
                  style="FONT-WEIGHT: 700" color=#ffffff>
                <a style="TEXT-DECORATION: none" href="<% support_elsematch("PARENTAL_CONTROL_SUPPORT", "1", "Parental_Control.asp", "Filters.asp"); %>">Access Restrictions</a></FONT></TD>
                <TD align=middle bgColor=#000000 height=20>
                  <P style="MARGIN-BOTTOM: 4px"><FONT style="FONT-WEIGHT: 700" 
                  color=#ffffff>
                  <a style="TEXT-DECORATION: none" href="Forward.asp">Applications 
                  <BR>&amp; Gaming</a>&nbsp;&nbsp;&nbsp;&nbsp;</FONT></P></TD>
                <TD align=middle bgColor=#000000 height=20>
                  <P style="MARGIN-BOTTOM: 4px"><FONT style="FONT-WEIGHT: 700" 
                  color=#ffffff>
                  <a style="TEXT-DECORATION: none" href="Management.asp">Administration</a>&nbsp;&nbsp;&nbsp;&nbsp;</FONT></P></TD>
                <TD align=middle bgColor=#000000 height=20>
                  <P style="MARGIN-BOTTOM: 4px"><FONT style="FONT-WEIGHT: 700" 
                  color=#ffffff>
                  <a style="TEXT-DECORATION: none" href="Status_Router.asp">Status</a>&nbsp;&nbsp;&nbsp;&nbsp;</FONT></P></TD>
              </TR>
                <TD width=643 bgColor=#6666cc colSpan=7 height=21>
                  <TABLE borderColor=black height=21 cellSpacing=0 cellPadding=0 width=558>
                    <TBODY>
                    <TR align=left>
                      <TD width=30></TD>
                      <TD class=small width=135><FONT style="COLOR: white">Basic Setup</FONT></TD>
                      <TD>
                        <P class=bar><font color='white'><b>|</b></font></P></TD>
                      <TD width=30></TD>
                      <TD class=small width=50><A href="DDNS.asp">DDNS</A></TD>
                      <TD>
                        <P class=bar><font color='white'><b>|</b></font></P></TD>
                      <TD width=30></TD>
                      <TD class=small width=180><A href="WanMAC.asp">MAC Address Clone</A></TD>
                      <TD>
                        <P class=bar><font color='white'><b>|</b></font></P></TD>
                      <TD width=30></TD>
                      <TD class=small width=160><A href="Routing.asp">Advanced Routing</TD>
                      <TD>
                        <P class=bar><font color='white'><b>|</b></font></P></TD>
                      <TD width=30></TD>
                      <TD class=small width=60><A href="Vlan.asp">VLANs</TD>
<% support_invmatch("HSIAB_SUPPORT", "1", "<!--"); %>
                      <TD><P class=bar><font color='white'><b>|</b></font></P></TD>
                      <TD width=30></TD>
                      <TD class=small width=140><A href="HotSpot_Admin.asp">Hot Spot</TD>
<% support_invmatch("HSIAB_SUPPORT", "1", "-->"); %>
                    </TR>
                    </TBODY>
                  </TABLE>
                </TD>
              </TR></TBODY></TABLE></TD></TR></TBODY></TABLE></TD></TR></TBODY></TABLE>
<TABLE height=5 cellSpacing=0 cellPadding=0 width=806 bgColor=black border=0>
  <TBODY>
  <TR bgColor=black>
    <TD 
    style="FONT-WEIGHT: normal; FONT-SIZE: 10pt; COLOR: black; FONT-STYLE: normal; FONT-FAMILY: Arial, Helvetica, sans-serif; FONT-VARIANT: normal" 
    borderColor=#e7e7e7 width=163 bgColor=#e7e7e7 height=1>
    <IMG height=15 
      src="image/UI_03.gif" width=164 border=0></TD>
    <TD 
    style="FONT-WEIGHT: normal; FONT-SIZE: 10pt; COLOR: black; FONT-STYLE: normal; FONT-FAMILY: Arial, Helvetica, sans-serif; FONT-VARIANT: normal" 
    width=646 height=1>
    <IMG height=15 src="image/UI_02.gif" width=645 
      border=0></TD></TR></TBODY></TABLE>
<TABLE id=AutoNumber9 style="BORDER-COLLAPSE: collapse" borderColor=#111111 
height=23 cellSpacing=0 cellPadding=0 width=809 border=0>
  <TBODY>
  <TR>
    <TD width=633>
      <TABLE cellSpacing=0 cellPadding=0 border=0>
        <TBODY>
        <TR>
          <TD align=right width=156 bgColor=#000000 colSpan=3 
            height=25><B><FONT style="FONT-SIZE: 9pt" face=Arial
            color=#ffffff><% nvram_match("wl_mode", "ap", "Internet"); %><% nvram_invmatch("wl_mode", "ap", "Wireless"); %> Setup</FONT></B></TD>
          <TD width=8 bgColor=#000000 height=25>&nbsp;</TD>
          <TD width=14 height=25>&nbsp;</TD>
          <TD width=17 height=25>&nbsp;</TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=101 height=25>&nbsp;</TD>
          <TD width=296 height=25>&nbsp;</TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
        <TR>
          <TD align=right width=156 bgColor=#e7e7e7 colSpan=3 height=1><B>Internet Connection Type</B></TD>
          <TD width=8 background=image/UI_04.gif height=1>&nbsp;</TD>
          <TD colSpan=6>
            <TABLE>
              <TBODY>
              <TR>
                <TD width=16 height=1>&nbsp;</TD>
                <TD width=28 height=1>&nbsp;</TD>
                <TD width=396 colSpan=3 height=1><SELECT name="wan_proto" onChange=SelWAN(this.form.wan_proto.selectedIndex,this.form)>
		     <OPTION value="disabled" <% nvram_selmatch("wan_proto", "disabled", "selected"); %>>Disable</OPTION>
	             <OPTION value="dhcp" <% nvram_selmatch("wan_proto", "dhcp", "selected"); %>>Automatic Configuration - DHCP</OPTION>
                     <OPTION value="static" <% nvram_selmatch("wan_proto", "static", "selected"); %>>Static IP</OPTION>
	             <OPTION value="pppoe" <% nvram_selmatch("wan_proto", "pppoe", "selected"); %>>PPPoE</OPTION>
                     <OPTION value="pptp" <% nvram_selmatch("wan_proto", "pptp", "selected"); %>>PPTP</OPTION>
		     <OPTION value="l2tp" <% nvram_selmatch("wan_proto", "l2tp", "selected"); %>>L2TP</OPTION>
                     <OPTION value="heartbeat" <% nvram_selmatch("wan_proto", "heartbeat", "selected"); %>>HeartBeat Signal</OPTION>
                     </SELECT></TD>
                <TD width=15>&nbsp;</TD></TR></TBODY></TABLE></TD>
                <TD width=15 background=image/UI_05.gif height=1>&nbsp;</TD></TR>


        <% show_index_setting(); %>
	
	<TR>
          <TD width=153 bgColor=#e7e7e7 colSpan=3 height=25>&nbsp;</TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25 width="41">&nbsp;</TD>
          <TD width=100 height=25><SPAN lang=zh-tw style="FONT-SIZE: 8pt">STP:</SPAN></TD>
          <TD width=298 height=25>
            <TABLE id=AutoNumber12 cellSpacing=0 cellPadding=0 width=242 border=0>
              <TBODY>
              <TR>
                <TD width=242 height=25><INPUT type=radio value=1 name=lan_stp <% nvram_match("lan_stp","1","checked"); %>><b>Enable</b>&nbsp;&nbsp;&nbsp;<INPUT type=radio value=0 name=lan_stp <% nvram_match("lan_stp","0","checked"); %>>
                          <b>Disable<br>
                          </b> (disable for COMCAST ISP)</TD>
                </TR></TBODY></TABLE></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>

        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=1>&nbsp;</TD>
          <TD width=8 background=image/UI_04.gif height=1>&nbsp;</TD>
          <TD colSpan=6>
            <TABLE>
              <TBODY>
              <TR>
                <TD width=16 height=1>&nbsp;</TD>
                <TD width=13 height=1>&nbsp;</TD>
                <TD width=410 colSpan=3 height=1>
                  <HR color=#b5b5e6 SIZE=1>
                </TD>
                <TD width=15 height=1>&nbsp;</TD></TR></TBODY></TABLE></TD>
          <TD width=15 background=image/UI_05.gif height=1>&nbsp;</TD></TR>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25>
            <P align=right><FONT style="FONT-WEIGHT: 700"><B>Optional Settings</B><BR><B>(required by some ISPs)</B></FONT></P></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><FONT style="FONT-SIZE: 8pt"
            face=Arial>&nbsp;Router Name:&nbsp;</FONT></TD>
          <TD width=296 height=25><FONT style="FONT-SIZE: 8pt"
            face=Arial><INPUT maxLength=39 name="router_name" size="20" value='<% nvram_get("router_name"); %>' onBlur=valid_name(this,"Router%20Name")></FONT></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif
        height=25>&nbsp;</TD></TR>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25>&nbsp;</TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><FONT style="FONT-SIZE: 8pt"
            face=Arial>&nbsp;Host Name:&nbsp;</FONT></TD>
          <TD width=296 height=25><FONT style="FONT-SIZE: 8pt"
            face=Arial><INPUT maxLength=39 name="wan_hostname" size="20" value='<% nvram_get("wan_hostname"); %>' onBlur=valid_name(this,"Host%20Name")></FONT></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif
        height=25>&nbsp;</TD></TR>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><FONT style="FONT-SIZE: 8pt"
            face=Arial>&nbsp;Domain Name:&nbsp;</FONT></TD>
          <TD width=296 height=25><FONT style="FONT-SIZE: 8pt"
            face=Arial><INPUT maxLength=79 name="wan_domain" size="20" value='<% nvram_get("wan_domain"); %>' onBlur=valid_name(this,"Domain%20name",SPACE_NO)></FONT></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><FONT style="FONT-SIZE: 8pt" 
            face=Arial>&nbsp;MTU:</FONT></TD>
          <TD width=296 height=25><B><select name="mtu_enable" onChange=SelMTU(this.form.mtu_enable.selectedIndex,this.form)>
			<option value="0" <% nvram_match("mtu_enable", "0", "selected"); %>><b>Auto</b></option>
			<option value="1" <% nvram_match("mtu_enable", "1", "selected"); %>><b>Manual&nbsp;</b></option>
		</select></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><FONT style="FONT-SIZE: 8pt"
            face=Arial>&nbsp;</FONT>Size:</B></TD>
          <TD width=296 height=25><INPUT class=num maxLength=4 onBlur=valid_mtu(this) size=5 value='<% nvram_get("wan_mtu"); %>' name="wan_mtu"></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=1>&nbsp;</TD>
          <TD width=8 background=image/UI_04.gif height=1>&nbsp;</TD>
          <TD colSpan=6>
            <TABLE>
              <TBODY>
              <TR>
                <TD width=16 height=1>&nbsp;</TD>
                <TD width=13 height=1>&nbsp;</TD>
                <TD width=410 colSpan=3 height=1>
                  <HR color=#b5b5e6 SIZE=1>
                </TD>
                <TD width=15 height=1>&nbsp;</TD></TR></TBODY></TABLE></TD>
          <TD width=15 background=image/UI_05.gif height=1>&nbsp;</TD></TR>
        <TR>
          <TD align=right width=156 bgColor=#000000 colSpan=3
            height=25><B><FONT style="FONT-SIZE: 9pt" face=Arial
            color=#ffffff>Network Setup</FONT></B></TD>
          <TD width=8 bgColor=#000000 height=25>&nbsp;</TD>
          <TD width=14 height=25>&nbsp;</TD>
          <TD width=17 height=25>&nbsp;</TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=101 height=25>&nbsp;</TD>
          <TD width=296 height=25>&nbsp;</TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD>
        </TR>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=1>&nbsp;</TD>
          <TD width=8 background=image/UI_04.gif height=1>&nbsp;</TD>
          <TD colSpan=6>
            <TABLE>
              <TBODY>
              <TR>
                <TD width=16 height=1>&nbsp;</TD>
                <TD width=13 height=1>&nbsp;</TD>
                <TD width=410 colSpan=3 height=1><HR color=#b5b5e6 SIZE=1></TD>
                <TD width=15 height=1>&nbsp;</TD></TR></TBODY></TABLE></TD>
          <TD width=15 background=image/UI_05.gif height=1>&nbsp;</TD></TR>
        <TR>
          <TD align=right width=156 bgColor=#e7e7e7 colSpan=3 height=25><B>Router IP</B></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25>&nbsp;Local IP Address:</TD>
          <TD width=296 height=25><INPUT class=num maxLength=3 onBlur=valid_range(this,1,223,"IP") size=3 value='<% get_single_ip("lan_ipaddr","0"); %>' name="lan_ipaddr_0"> .
            <INPUT class=num maxLength=3 onBlur=valid_range(this,0,255,"IP") size=3 value='<% get_single_ip("lan_ipaddr","1"); %>' name="lan_ipaddr_1"> .
            <INPUT class=num maxLength=3 onBlur=valid_range(this,0,255,"IP") size=3 value='<% get_single_ip("lan_ipaddr","2"); %>' name="lan_ipaddr_2"> .
            <INPUT class=num maxLength=3 onBlur=valid_range(this,1,254,"IP") size=3 value='<% get_single_ip("lan_ipaddr","3"); %>' name="lan_ipaddr_3"></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><FONT style="FONT-SIZE: 8pt" face=Arial>&nbsp;Subnet Mask:</FONT></TD>
          <TD width=296 height=25><SELECT class=num size=1 name="lan_netmask"><OPTION
              value=255.255.255.0 <% nvram_match("lan_netmask", "255.255.255.0", "selected"); %>>255.255.255.0</OPTION><OPTION
              value=255.255.255.128 <% nvram_match("lan_netmask", "255.255.255.128", "selected"); %>>255.255.255.128</OPTION><OPTION
              value=255.255.255.192 <% nvram_match("lan_netmask", "255.255.255.192", "selected"); %>>255.255.255.192</OPTION><OPTION
              value=255.255.255.224 <% nvram_match("lan_netmask", "255.255.255.224", "selected"); %>>255.255.255.224</OPTION><OPTION
              value=255.255.255.240 <% nvram_match("lan_netmask", "255.255.255.240", "selected"); %>>255.255.255.240</OPTION><OPTION
              value=255.255.255.248 <% nvram_match("lan_netmask", "255.255.255.248", "selected"); %>>255.255.255.248</OPTION><OPTION
              value=255.255.255.252 <% nvram_match("lan_netmask", "255.255.255.252", "selected"); %>>255.255.255.252</OPTION></SELECT></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>

        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><FONT style="FONT-SIZE: 8pt" face=Arial>&nbsp;Gateway:</FONT></TD>
          <TD width=296 height=25><input type=hidden name="lan_gateway" value=4>
                <INPUT class=num maxLength=3 size=3 value='<% get_single_ip("lan_gateway","0"); %>' name="lan_gateway_0" onBlur=valid_range(this,0,255,"IP")> .
                <INPUT class=num maxLength=3 size=3 value='<% get_single_ip("lan_gateway","1"); %>' name="lan_gateway_1" onBlur=valid_range(this,0,255,"IP")> .
                <INPUT class=num maxLength=3 size=3 value='<% get_single_ip("lan_gateway","2"); %>' name="lan_gateway_2" onBlur=valid_range(this,0,255,"IP")> .
                <INPUT class=num maxLength=3 size=3 value='<% get_single_ip("lan_gateway","3"); %>' name="lan_gateway_3" onBlur=valid_range(this,0,254,"IP")>
	  </TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>

        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><FONT style="FONT-SIZE: 8pt" face=Arial>&nbsp;Local DNS:</FONT></TD>
          <TD width=296 height=25><input type=hidden name="sv_localdns" value=4>
                <INPUT class=num maxLength=3 size=3 value='<% get_single_ip("sv_localdns","0"); %>' name="sv_localdns_0" onBlur=valid_range(this,0,255,"IP")> .
                <INPUT class=num maxLength=3 size=3 value='<% get_single_ip("sv_localdns","1"); %>' name="sv_localdns_1" onBlur=valid_range(this,0,255,"IP")> .
                <INPUT class=num maxLength=3 size=3 value='<% get_single_ip("sv_localdns","2"); %>' name="sv_localdns_2" onBlur=valid_range(this,0,255,"IP")> .
                <INPUT class=num maxLength=3 size=3 value='<% get_single_ip("sv_localdns","3"); %>' name="sv_localdns_3" onBlur=valid_range(this,0,254,"IP")>
	  </TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>

        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=1>&nbsp;</TD>
          <TD width=8 background=image/UI_04.gif height=1>&nbsp;</TD>
          <TD colSpan=6>
            <TABLE>
              <TBODY>
              <TR>
                <TD width=16 height=1>&nbsp;</TD>
                <TD width=13 height=1>&nbsp;</TD>
                <TD width=410 colSpan=3 height=1><HR color=#b5b5e6 SIZE=1></TD>
                <TD width=15 height=1>&nbsp;</TD></TR></TBODY></TABLE></TD>
          <TD width=15 background=image/UI_05.gif height=1>&nbsp;</TD></TR>
        <TR>
          <TD align=right width=156 bgColor=#e7e7e7 colSpan=3 height=25><B>Network Address</B><BR><B>Server Settings (DHCP)</B></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25>&nbsp;DHCP Server:</TD>
          <TD width=296 height=25><input type="radio" name="lan_proto" value="dhcp" <% nvram_selmatch("lan_proto", "dhcp", "checked"); %> onClick="SelDHCP('dhcp',this.form)"><B><span >Enable</span></B>
          <input type="radio" name="lan_proto" value="static" <% nvram_selmatch("lan_proto", "static", "checked"); %> onClick="SelDHCP('static',this.form)"><B><span >Disable</span></B></TD>  
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
<input type=hidden name=dhcp_check>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><FONT style="FONT-SIZE: 8pt" face=Arial>&nbsp;Starting IP Address:</FONT></TD>
          <TD width=296 height=25>&nbsp;<b><% prefix_ip_get("lan_ipaddr",1); %></b><B><INPUT maxLength=3 onBlur=valid_range(this,1,254,"DHCP%20starting%20IP") size=3 value='<% nvram_get("dhcp_start"); %>' name="dhcp_start" class=num></B></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><FONT style="FONT-SIZE: 8pt" face=Arial>&nbsp;Maximum Number of &nbsp;DHCP Users:</FONT></TD>
          <TD width=296 height=25>&nbsp;<INPUT maxLength=3 onBlur=valid_range(this,1,253,"Number%20of%20DHCP%20users") size=3 value='<% nvram_get("dhcp_num"); %>' name="dhcp_num" class=num></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><FONT style="FONT-SIZE: 8pt" 
            face=Arial>&nbsp;Client Lease Time:</FONT></TD>
          <TD width=296 height=25>&nbsp;<INPUT maxLength=4 onBlur=valid_range(this,0,9999,"DHCP%20Lease%20Time") size=4 value='<% nvram_get("dhcp_lease"); %>' name="dhcp_lease" class=num>&nbsp;minutes</TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
<% nvram_selmatch("wan_proto","static","<!--"); %>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><FONT style="FONT-SIZE: 8pt" 
            face=Arial>&nbsp;Static DNS 1:&nbsp;</FONT></TD>
          <TD width=296 height=25>&nbsp;<input type=hidden name=wan_dns value=4><INPUT maxLength=3 onBlur=valid_range(this,0,255,"DNS") size=3 value='<% get_dns_ip("wan_dns","0","0"); %>' name="wan_dns0_0" class=num> . 
            <INPUT maxLength=3 onBlur=valid_range(this,0,255,"DNS") size=3 value='<% get_dns_ip("wan_dns","0","1"); %>' name="wan_dns0_1" class=num> . 
            <INPUT maxLength=3 onBlur=valid_range(this,0,255,"DNS") size=3 value='<% get_dns_ip("wan_dns","0","2"); %>' name="wan_dns0_2" class=num> . 
            <INPUT maxLength=3 onBlur=valid_range(this,0,254,"DNS") size=3 value='<% get_dns_ip("wan_dns","0","3"); %>' name="wan_dns0_3" class=num></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><FONT style="FONT-SIZE: 8pt" 
            face=Arial>&nbsp;Static DNS 2:&nbsp;</FONT></TD>
          <TD width=296 height=25>&nbsp;<INPUT maxLength=3 onBlur=valid_range(this,0,255,"DNS") size=3 value='<% get_dns_ip("wan_dns","1","0"); %>' name="wan_dns1_0" class=num> . 
            <INPUT maxLength=3 onBlur=valid_range(this,0,255,"DNS") size=3 value='<% get_dns_ip("wan_dns","1","1"); %>' name="wan_dns1_1" class=num> . 
            <INPUT maxLength=3 onBlur=valid_range(this,0,255,"DNS") size=3 value='<% get_dns_ip("wan_dns","1","2"); %>' name="wan_dns1_2" class=num> . 
            <INPUT maxLength=3 onBlur=valid_range(this,0,254,"DNS") size=3 value='<% get_dns_ip("wan_dns","1","3"); %>' name="wan_dns1_3" class=num></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><FONT style="FONT-SIZE: 8pt" 
            face=Arial>&nbsp;Static DNS 3:&nbsp;</FONT></TD>
          <TD width=296 height=25>&nbsp;<INPUT maxLength=3 onBlur=valid_range(this,0,255,"DNS") size=3 value='<% get_dns_ip("wan_dns","2","0"); %>' name="wan_dns2_0" class=num> . 
            <INPUT maxLength=3 onBlur=valid_range(this,0,255,"DNS") size=3 value='<% get_dns_ip("wan_dns","2","1"); %>' name="wan_dns2_1" class=num> . 
            <INPUT maxLength=3 onBlur=valid_range(this,0,255,"DNS") size=3 value='<% get_dns_ip("wan_dns","2","2"); %>' name="wan_dns2_2" class=num> . 
            <INPUT maxLength=3 onBlur=valid_range(this,0,254,"DNS") size=3 value='<% get_dns_ip("wan_dns","2","3"); %>' name="wan_dns2_3" class=num></B></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
<% nvram_selmatch("wan_proto","static","-->"); %>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><FONT style="FONT-SIZE: 8pt" 
            face=Arial>&nbsp;WINS:&nbsp;</FONT></TD>
          <TD width=296 height=25>&nbsp;<input type=hidden name=wan_wins value=4><INPUT maxLength=3 onBlur=valid_range(this,0,255,"WINS") size=3 value='<% get_single_ip("wan_wins","0"); %>' name="wan_wins_0" class=num> . 
            <INPUT maxLength=3 onBlur=valid_range(this,0,255,"WINS") size=3 value='<% get_single_ip("wan_wins","1"); %>' name="wan_wins_1" class=num> . 
            <INPUT maxLength=3 onBlur=valid_range(this,0,255,"WINS") size=3 value='<% get_single_ip("wan_wins","2"); %>' name="wan_wins_2" class=num> . 
            <INPUT maxLength=3 onBlur=valid_range(this,0,254,"WINS") size=3 value='<% get_single_ip("wan_wins","3"); %>' name="wan_wins_3" class=num></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>        
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=1>&nbsp;</TD>
          <TD width=8 background=image/UI_04.gif height=1>&nbsp;</TD>
          <TD colSpan=6>
            <TABLE>
              <TBODY>
              <TR>
                <TD width=16 height=1>&nbsp;</TD>
                <TD width=13 height=1>&nbsp;</TD>
                <TD width=410 colSpan=3 height=1>
                  <HR color=#b5b5e6 SIZE=1>
                </TD>
                <TD width=15 height=1>&nbsp;</TD></TR></TBODY></TABLE></TD>
          <TD width=15 background=image/UI_05.gif height=1>&nbsp;</TD></TR>
        <!--TR>
          <TD align=right width=156 bgColor=#e7e7e7 colSpan=3 height=25><B>Time Setting</B></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><input type=radio name=time_mode>Manually</TD>
          <TD width=296 height=25>&nbsp;</TD>  
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><FONT style="FONT-SIZE: 8pt" 
            face=Arial>&nbsp;Date:</FONT></TD>
          <TD width=296 height=25>&nbsp;<font face="Arial" style="font-size: 8pt">
                	<INPUT class=num maxLength=4 size=4 name="year" value="<% show_time_setting("year","0"); %>" style="font-family:Courier; font-size:10pt">&nbsp;-&nbsp;
                	<INPUT class=num maxLength=3 size=3 name="mon" value="<% show_time_setting("mon","0"); %>" style="font-family:Courier; font-size:10pt">&nbsp;-&nbsp;
                	<INPUT class=num maxLength=3 size=3 name="mday" value="<% show_time_setting("mday","0"); %>" style="font-family:Courier; font-size:10pt">&nbsp;
                	(yyyy-mm-dd)</font></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=25></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><FONT style="FONT-SIZE: 8pt" 
            face=Arial>&nbsp;Time:</FONT></TD>
          <TD width=296 height=25>&nbsp;<font face="Arial" style="font-size: 8pt">
                	<INPUT class=num maxLength=3 size=3 name="hour" value="<% show_time_setting("hour","0"); %>" style="font-family:Courier; font-size:10pt">&nbsp;:&nbsp;
                	<INPUT class=num maxLength=3 size=3 name="min" value="<% show_time_setting("min","0"); %>" style="font-family:Courier; font-size:10pt">&nbsp;:&nbsp;
                	<INPUT class=num maxLength=3 size=3 name="sec" value="<% show_time_setting("sec","0"); %>" style="font-family:Courier; font-size:10pt">&nbsp;(hh-mm-ss)	</font></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
        <TR>
          <TD width=156 bgColor=#e7e7e7 colSpan=3 height=1>&nbsp;</TD>
          <TD width=8 background=image/UI_04.gif height=1>&nbsp;</TD>
          <TD colSpan=6>
            <TABLE>
              <TBODY>
              <TR>
                <TD width=16 height=1>&nbsp;</TD>
                <TD width=13 height=1>&nbsp;</TD>
                <TD width=410 colSpan=3 height=1>
                  <HR color=#b5b5e6 SIZE=1>
                </TD>
                <TD width=15 height=1>&nbsp;</TD></TR></TBODY></TABLE></TD>
          <TD width=15 background=image/UI_05.gif height=1>&nbsp;</TD></TR>
        <TR>
          <TD align=right width=156 bgColor=#e7e7e7 colSpan=3 height=25><B>Time Setting</B></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25><input type=radio name=time_mode checked value="1">Automatically</TD>
          <TD width=296 height=25>&nbsp;</TD>  
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR-->
        <TR>
          <TD align=right width=156 bgColor=#e7e7e7 colSpan=3 height=25><b>Time Setting</b></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=101 height=25>&nbsp;Time Zone:</TD>
          <TD width=296 height=25>&nbsp;</TD>  
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
        <TR>
          <TD align=right width=156 bgColor=#e7e7e7 colSpan=3 height=25></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=397 height=25 colspan="2">&nbsp;<select name="time_zone" onChange=SelTime(this.form.time_zone.selectedIndex,this.form)>
	  <option value="-12 1 0" <% nvram_match("time_zone", "-12 1 0", "selected"); %>>(GMT-12:00) Kwajalein</option>
	  <option value="-11 1 0" <% nvram_match("time_zone", "-11 1 0", "selected"); %>>(GMT-11:00) Midway Island, Samoa</option>
	  <option value="-10 1 0" <% nvram_match("time_zone", "-10 1 0", "selected"); %>>(GMT-10:00) Hawaii</option>
	  <option value="-09 1 1" <% nvram_match("time_zone", "-09 1 1", "selected"); %>>(GMT-09:00) Alaska</option>
	  <option value="-08 1 1" <% nvram_match("time_zone", "-08 1 1", "selected"); %>>(GMT-08:00) Pacific Time (USA &amp; Canada)</option>
	  <option value="-07 1 0" <% nvram_match("time_zone", "-07 1 0", "selected"); %>>(GMT-07:00) Arizona</option>
	  <option value="-07 2 1" <% nvram_match("time_zone", "-07 2 1", "selected"); %>>(GMT-07:00) Mountain Time (USA &amp; Canada)</option>
	  <option value="-06 1 0" <% nvram_match("time_zone", "-06 1 0", "selected"); %>>(GMT-06:00) Mexico</option>
	  <option value="-06 2 1" <% nvram_match("time_zone", "-06 2 1", "selected"); %>>(GMT-06:00) Central Time (USA &amp; Canada)</option>
	  <option value="-05 1 0" <% nvram_match("time_zone", "-05 1 0", "selected"); %>>(GMT-05:00) Indiana East, Colombia, Panama</option>
	  <option value="-05 2 1" <% nvram_match("time_zone", "-05 2 1", "selected"); %>>(GMT-05:00) Eastern Time (USA &amp; Canada)</option>
	  <option value="-04 1 0" <% nvram_match("time_zone", "-04 1 0", "selected"); %>>(GMT-04:00) Bolivia, Venezuela</option>
	  <option value="-04 2 1" <% nvram_match("time_zone", "-04 2 1", "selected"); %>>(GMT-04:00) Atlantic Time (Canada), Brazil West</option>
	  <option value="-03.5 1 1" <% nvram_match("time_zone", "-03.5 1 1", "selected"); %>>(GMT-03:30) Newfoundland</option>
	  <option value="-03 1 0" <% nvram_match("time_zone", "-03 1 0", "selected"); %>>(GMT-03:00) Guyana</option>
	  <option value="-03 2 1" <% nvram_match("time_zone", "-03 2 1", "selected"); %>>(GMT-03:00) Brazil East, Greenland</option>
	  <option value="-02 1 0" <% nvram_match("time_zone", "-02 1 0", "selected"); %>>(GMT-02:00) Mid-Atlantic</option>
	  <option value="-01 1 2" <% nvram_match("time_zone", "-01 1 2", "selected"); %>>(GMT-01:00) Azores</option>
	  <option value="+00 1 0" <% nvram_match("time_zone", "+00 1 0", "selected"); %>>(GMT) Gambia, Liberia, Morocco</option>
	  <option value="+00 2 2" <% nvram_match("time_zone", "+00 2 2", "selected"); %>>(GMT) England</option>
	  <option value="+01 1 0" <% nvram_match("time_zone", "+01 1 0", "selected"); %>>(GMT+01:00) Tunisia</option>
	  <option value="+01 2 2" <% nvram_match("time_zone", "+01 2 2", "selected"); %>>(GMT+01:00) France, Germany, Italy</option>
	  <option value="+02 1 0" <% nvram_match("time_zone", "+02 1 0", "selected"); %>>(GMT+02:00) South Africa</option>
	  <option value="+02 2 2" <% nvram_match("time_zone", "+02 2 2", "selected"); %>>(GMT+02:00) Greece, Ukraine, Romania, Turkey</option>
	  <option value="+03 1 0" <% nvram_match("time_zone", "+03 1 0", "selected"); %>>(GMT+03:00) Iraq, Jordan, Kuwait</option>
	  <option value="+04 1 0" <% nvram_match("time_zone", "+04 1 0", "selected"); %>>(GMT+04:00) Armenia</option>
	  <option value="+05 1 0" <% nvram_match("time_zone", "+05 1 0", "selected"); %>>(GMT+05:00) Pakistan, Russia</option>
	  <option value="+06 1 0" <% nvram_match("time_zone", "+06 1 0", "selected"); %>>(GMT+06:00) Bangladesh, Russia</option>
	  <option value="+07 1 0" <% nvram_match("time_zone", "+07 1 0", "selected"); %>>(GMT+07:00) Thailand, Russia</option>
	  <option value="+08 1 0" <% nvram_match("time_zone", "+08 1 0", "selected"); %>>(GMT+08:00) China, Hong Kong, Australia Western</option>
	  <option value="+08 2 0" <% nvram_match("time_zone", "+08 2 0", "selected"); %>>(GMT+08:00) Singapore, Taiwan, Russia</option>
	  <option value="+09 1 0" <% nvram_match("time_zone", "+09 1 0", "selected"); %>>(GMT+09:00) Japan, Korea</option>
	  <option value="+09.5 1 4" <% nvram_match("time_zone", "+09.5 1 4", "selected"); %>>(GMT+09:30) Australia Central</option>
	  <option value="+10 1 0" <% nvram_match("time_zone", "+10 1 0", "selected"); %>>(GMT+10:00) Guam, Russia</option>
	  <option value="+10 2 4" <% nvram_match("time_zone", "+10 2 4", "selected"); %>>(GMT+10:00) Australia Eastern</option>
	  <option value="+11 1 0" <% nvram_match("time_zone", "+11 1 0", "selected"); %>>(GMT+11:00) Solomon Islands</option>
	  <option value="+12 1 0" <% nvram_match("time_zone", "+12 1 0", "selected"); %>>(GMT+12:00) Fiji</option>
	  <option value="+12 2 4" <% nvram_match("time_zone", "+12 2 4", "selected"); %>>(GMT+12:00) New Zealand</option>
	</select></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
        <TR>
          <TD align=right width=156 bgColor=#e7e7e7 colSpan=3 height=25></TD>
          <TD width=8 background=image/UI_04.gif height=25>&nbsp;</TD>
          <TD colSpan=3 height=25>&nbsp;</TD>
          <TD width=397 height=25 colspan="2"><INPUT type=checkbox value="1" name="_daylight_time" <% nvram_match("daylight_time","1","checked"); %>><font face="Arial" style="font-size: 8pt">Automatically adjust clock for daylight saving changes</font></TD>
          <TD width=13 height=25>&nbsp;</TD>
          <TD width=15 background=image/UI_05.gif height=25>&nbsp;</TD></TR>
        <TR>
          <TD width=44 bgColor=#e7e7e7 height=5>&nbsp;</TD>
          <TD width=65 bgColor=#e7e7e7 height=5>&nbsp;</TD>
          <TD width=47 bgColor=#e7e7e7 height=5>&nbsp;</TD>
          <TD width=8 background=image/UI_04.gif height=5>&nbsp;</TD>
          <TD width=454 colSpan=6 height=5></TD>
          <TD width=15 background=image/UI_05.gif 
        height=5>&nbsp;</TD></TR></TBODY></TABLE></TD>
    <TD vAlign=top width=176 bgColor=#6666cc>
      <TABLE cellSpacing=0 cellPadding=0 width=176 border=0>
        <TBODY>
        <TR>
          <TD width=11 bgColor=#6666cc height=25>&nbsp;</TD>
          <TD width=156 bgColor=#6666cc height=25><font color="#FFFFFF">
          <span ><a target="_blank" href="help/HSetup.asp">More...</a></span></font></TD>
          <TD width=9 bgColor=#6666cc 
  height=25>&nbsp;</TD></TR></TBODY></TABLE></TD></TR>
  <TR>
    <TD width=809 colSpan=2>
      <TABLE cellSpacing=0 cellPadding=0 border=0>
        <TBODY>
        <TR>
          <TD width=156 bgColor=#e7e7e height=30>&nbsp;</TD>
          <TD width=8 background=image/UI_04.gif>&nbsp;</TD>
          <TD width=16>&nbsp;</TD>
          <TD width=12>&nbsp;</TD>
          <TD width=411>&nbsp;</TD>
          <TD width=15>
          <TD width=15 background=image/UI_05.gif>&nbsp;</TD>
          <TD width=176 bgColor=#6666cc rowSpan=2>
          <IMG 
            src="image/UI_Cisco.gif" border=0 width="176" height="64"></TD></TR>
        <TR>
          <TD width=156 bgColor=#000000>&nbsp;</TD>
          <TD width=8 bgColor=#000000>&nbsp;</TD>
          <TD width=16 bgColor=#6666cc>&nbsp;</TD>
          <TD width=12 bgColor=#6666cc>&nbsp;</TD>
          <TD width=411 bgColor=#6666cc>
            <TABLE height=19 cellSpacing=0 cellPadding=0 align=right 
              border=0><TBODY>
              <TR>
                <TD align=middle width=101></FONT><INPUT type=button value="Save Settings" onClick=to_submit(this.form)></TD>
                <TD align=middle width=8 bgColor=#6666cc>&nbsp;</TD>
                <TD align=middle bgColor=#6666cc><INPUT type=button value="Cancel Changes" onclick=window.location.reload()></TD>
                </TR></TBODY></TABLE></TD>
          <TD width=15 bgColor=#6666cc height=33>&nbsp;</TD>
          <TD width=15 bgColor=#000000 
  height=33>&nbsp;</TD></TR></TBODY></TABLE></TD></TR></TBODY></TABLE></FORM></DIV></BODY></HTML>
