#define SSL ssl_t;

struct BIO
{
	BIO_METHOD *method;
	/* bio, mode, argp, argi, argl, ret */
	long (*callback)(struct bio_st *,int,const char *,int, long,long);
	char *cb_arg; /* first argument for the callback */

	int init;
	int shutdown;
	int flags;	/* extra storage */
	int retry_reason;
	int num;
	void *ptr;
	struct bio_st *next_bio;	/* used by filter BIOs */
	struct bio_st *prev_bio;	/* used by filter BIOs */
	int references;
	unsigned long num_read;
	unsigned long num_write;

	CRYPTO_EX_DATA ex_data;
};

SSL_METHOD *meth;
SSL_CTX *ctx = NULL;

int     load_dh_params(SSL_CTX ctx,DHFILE);
SSL_CTX *initialize_ctx(char *keyfile, char *password);
void    destroy_ctx(SSL_CTX *ctx);
int     SSL_library_init(void );
void    SSL_load_error_strings(void );
SSL*	SSL_new(SSL_CTX *ctx);
void	SSL_set_bio(SSL *s, BIO *rbio,BIO *wbio);
int 	SSL_accept(SSL *ssl);


/* Create our context*/
SSL_METHOD *SSLv23_method(void);	/* SSLv3 but can rollback to v2 */
SSL_CTX *SSL_CTX_new(SSL_METHOD *meth);

/* Load our keys and certificates*/
int  SSL_CTX_use_certificate_chain_file(SSL_CTX *ctx, const char *file); /* PEM type */
void SSL_CTX_set_default_passwd_cb(SSL_CTX *ctx, pem_password_cb *cb);
int  SSL_CTX_use_PrivateKey_file(SSL_CTX *ctx, const char *file, int type);
int  SSL_CTX_load_verify_locations(SSL_CTX *ctx, const char *CAfile, const char *CApath);
void SSL_CTX_free(SSL_CTX *);

BIO*    BIO_new_socket(int sock, int close_flag);
BIO*    BIO_new_ssl(SSL_CTX *ctx,int client);
long    BIO_set_ssl(BIO *bp, long larg, void *parg);
BIO*    BIO_push(BIO *b,BIO *append);
int	BIO_read(BIO *b, void *data, int len);
int	BIO_gets(BIO *bp,char *buf, int size);
int	BIO_write(BIO *b, const void *data, int len);
int	BIO_puts(BIO *bp,const char *buf);
int     BIO_printf(BIO *bio, const char *format, ...);
int 	BIO_flush(BIO *a);
void	BIO_free_all(BIO *a);
BIO*    BIO_new_fp(FILE *stream, int close_flag);



