#ifndef _NFNETLINK_CONNTRACK_H
#define _NFNETLINK_CONNTRACK_H
#include <linux/nfnetlink.h>
#include <linux/netfilter_ipv4/ip_conntrack.h>

/* CTNETLINK for ip_conntrack */

enum cntl_msg_types {
	CTNL_MSG_NEWCONNTRACK,
	CTNL_MSG_GETCONNTRACK,
	CTNL_MSG_DELCONNTRACK,

	CTNL_MSG_NEWEXPECT,
	CTNL_MSG_GETEXPECT,
	CTNL_MSG_DELEXPECT,

	CTNL_MSG_COUNT,
};

/* ctnetlink attribute types.
 */

enum ctattr_type_t
{
	CTA_UNSPEC,     /* [none] I don't know (unspecified). */
	CTA_ORIG,       /* [ip_conntrack_tuple] Original tuple. */
	CTA_RPLY,       /* [ip_conntrack_tuple] Reply tuple. */
	CTA_STATUS,     /* [unsigned long] Status of connection. */
	CTA_PROTOINFO,  /* [cta_proto] Protocol specific ct information. */
	CTA_HELPINFO,   /* [cta_help] Helper specific information. */
	CTA_NATINFO,    /* [cta_nat] Any NAT transformations. */
	CTA_TIMEOUT,    /* [unsigned long] timer */
	CTA_MARK,       /* [unsigned long] mark .*/
	
	CTA_EXP_TUPLE,	/* [ip_conntrack_tuple] Expected tuple */
	CTA_EXP_MASK,	/* [ip_conntrack_tuple] Mask for EXP_TUPLE */
	CTA_EXP_SEQNO,	/* [u_int32_t] sequence number */
	CTA_EXP_PROTO,	/* [cta_exp_proto] */
	CTA_EXP_HELP,	/* [cta_exp_help] */
	CTA_EXP_TIMEOUT,/* [unsigned long] timer */

	CTA_MAX = CTA_EXP_TIMEOUT
};

/* Attribute specific data structures.
 */

#include <linux/netfilter_ipv4/ip_nat.h>
struct cta_nat {
	unsigned int num_manips;
	struct ip_nat_info_manip manips[IP_NAT_MAX_MANIPS];
};

struct cta_proto {
	unsigned char num_proto;	/* Protocol number IPPROTO_X */
	union ip_conntrack_proto proto;
};

#define CTA_HELP_MAXNAMESZ	31

struct cta_help {
	char name[CTA_HELP_MAXNAMESZ];	/* name of conntrack helper */
	union ip_conntrack_help help;
};

struct cta_exp_proto {
	union ip_conntrack_expect_proto proto;
};

struct cta_exp_help {
	union ip_conntrack_expect_help help;
};

/* ctnetlink multicast groups: reports any change of ctinfo,
 * ctstatus, or protocol state change.
 */
#define NFGRP_IPV4_CT_TCP	0x01
#define NFGRP_IPV4_CT_UDP	0x02
#define NFGRP_IPV4_CT_ICMP	0x04
#define NFGRP_IPV4_CT_OTHER 	0x08

#define NFGRP_IPV6_CT_TCP       0x10
#define NFGRP_IPV6_CT_UDP       0x20
#define NFGRP_IPV6_CT_ICMP      0x40
#define NFGRP_IPV6_CT_OTHER 	0x80

#endif /* _NFNETLINK_CONNTRACK_H */
