/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.check_values.conf,v 1.6 2003/06/13 18:18:04 hardaker Exp $
 */

/********************************************************************
 *                       NOTE   NOTE   NOTE
 *   This file is auto-generated and SHOULD NOT BE EDITED by hand.
 *   Modify the qos_checkfns_local.[ch] files insead so that you
 *   can regenerate this one as mib2c improvements are made.
 ********************************************************************/

/*
 * standard headers 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include "qos_checkfns.h"
#include "qos_checkfns_local.h"
#include "qos_enums.h"
#include<time.h>

void initialize_qos_table(qos_table *table) {
// first object in table is permanent a due to this fact declared as static
// its initialization
    memset(table,0,sizeof(qos_table));
    table->next=NULL;
    table->data.dev_name[0]=0x0;
    table->data.type[0]=0x0;
    table->data.text_parent[0]=0x0;
    table->data.text_handle[0]=0x0;
    table->data.text_leaf[0]=0x0;
    table->data.qosBytes=0;
    table->data.info[0]=0x0;
}

void update_qos_table_data(qos_table *table) {
// deletes old data from qos_table and calls functions to fetch new data
// it happens only if time between calls is greater than UPDATE_INTERVAL 
// (located in header file)
// memory allocations and fetch is a bit complicated and it could take 
// relatively long time to proceed (especially in cases with lot of classes/qdisc)
    static long old_time;
    long actual_time;
    long diff;
    actual_time = (long)time(NULL);
    diff = actual_time-old_time;
    if(diff<UPDATE_INTERVAL) {
	return;
    }
    old_time=actual_time;
    
    delete_old_qos_table_data(table);    
    add_new_entries_to_table();
    // fetches all data from kernel and stores them in linked list of structures
}

void delete_old_qos_table_data(qos_table *table) {
    // deletes all table data except those in first pointer (they are not mallocced - static)
    qos_table *iterator;
    qos_table *temp=NULL;
    iterator=table;

    if(iterator->next==NULL) return;
    iterator=iterator->next;    
    
    while(iterator!=NULL) {
	temp=iterator->next;
	free(iterator);
	iterator=temp;
    }
    table->next=NULL; //delete first point in line
    
}

qos_table* create_new_qos_table_entry() {
// allocates a new entry into table, don't care about qos_table identifier, it should be named
// qos_table_entry, but it's around all code :-), qos_table doesn't mean whole table, but only 
// one entry in linked list... sorry for that

    qos_table *new_entry;

    new_entry = (qos_table*)malloc(sizeof(qos_table));

    if(new_entry==NULL) {
	snmp_log(LOG_WARNING,"qos-ext: create_new_qos_table_entry: cannot allocate memory for new entry\n");
	return(NULL);
    }

    memset(new_entry,0,sizeof(qos_table));

    new_entry->next=NULL;
    new_entry->data.dev_name[0]=0x0;
    new_entry->data.type[0]=0x0;
    new_entry->data.text_parent[0]=0x0;
    new_entry->data.text_handle[0]=0x0;    
    new_entry->data.text_leaf[0]=0x0;
    new_entry->data.qosBytes=0;
    new_entry->data.info[0]=0x0;
    //string initialization
    return(new_entry);
}

qos_table* get_last_entry_in_list(qos_table *table) {
// finds last entry in linked list of qos_table entities
    qos_table *iterator;
    iterator = table;
    while(iterator->next!=NULL) {
	iterator=iterator->next;
    }
    return(iterator);
}


