/*
 * Copyright (c) 2021-2025 Symas Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above
 *   copyright notice, this list of conditions and the following disclaimer
 *   in the documentation and/or other materials provided with the
 *   distribution.
 * * Neither the name of the Symas Corporation nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifdef _CBLDIAG_H
#pragma message __FILE__ " included twice"
#else
#define _CBLDIAG_H

const char * cobol_filename();

/*
 *  These are user-facing messages.  They go through the gcc
 *  diagnostic framework and use text that can be localized.
 */
void yyerror( const char fmt[], ... );
bool yywarn( const char fmt[], ... );

/* Location type.  Borrowed from parse.h as generated by Bison. */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1

const YYLTYPE& cobol_location();
#endif

#if ! defined YDFLTYPE && ! defined YDFLTYPE_IS_DECLARED
typedef struct YDFLTYPE YDFLTYPE;
struct YDFLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YDFLTYPE_IS_DECLARED 1
# define YDFLTYPE_IS_TRIVIAL 1

#endif

// an error at a location, called from the parser for semantic errors
void error_msg( const YYLTYPE& loc, const char gmsgid[], ... );

void dialect_error( const YYLTYPE& loc, const char term[], const char dialect[] );


// for CDF and other warnings that refer back to an earlier line
// (not in diagnostic framework yet)
void yyerrorvl( int line, const char *filename, const char fmt[], ... );

void cbl_unimplementedw(const char *gmsgid, ...); // warning
void cbl_unimplemented(const char *gmsgid, ...);  // error
void cbl_unimplemented_at( const  YYLTYPE& loc, const char *gmsgid, ... );

/*
 * dbgmsg produce messages not intended for the user.  They cannot
 * be localized and fwrite directly to standard out.  dbgmsg is activated by
 * -fflex-debug or -fyacc-debug.  
 */
void dbgmsg( const char fmt[], ... );

void gcc_location_set( const YYLTYPE& loc );

// tree.h defines yy_flex_debug as a macro because options.h
#if ! defined(yy_flex_debug)
template <typename LOC>
static void
location_dump( const char func[], int line, const char tag[], const LOC& loc) {
  extern int yy_flex_debug;
  if( yy_flex_debug && getenv("update_location") )
    fprintf(stderr, "%s:%d: %s location (%d,%d) to (%d,%d)\n",
            func, line, tag,
            loc.first_line, loc.first_column, loc.last_line, loc.last_column);
}
#endif // defined(yy_flex_debug)

#endif
