; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=fiji -verify-machineinstrs < %s | FileCheck -check-prefix=GCN %s

define amdgpu_kernel void @private_load_maybe_divergent(ptr addrspace(4) %k, ptr %flat) {
; GCN-LABEL: private_load_maybe_divergent:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_add_i32 s12, s12, s17
; GCN-NEXT:    s_mov_b64 s[22:23], s[2:3]
; GCN-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-NEXT:    s_mov_b64 s[20:21], s[0:1]
; GCN-NEXT:    s_add_u32 s20, s20, s17
; GCN-NEXT:    s_addc_u32 s21, s21, 0
; GCN-NEXT:    buffer_load_dword v0, v0, s[20:23], 0 offen glc
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GCN-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v2, s1
; GCN-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCN-NEXT:    v_lshlrev_b64 v[0:1], 2, v[0:1]
; GCN-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, v2, v1, vcc
; GCN-NEXT:    flat_load_dword v0, v[0:1]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    flat_store_dword v[0:1], v0
; GCN-NEXT:    s_endpgm
  %load = load volatile i32, ptr addrspace(5) poison, align 4
  %gep = getelementptr inbounds i32, ptr addrspace(4) %k, i32 %load
  %maybe.not.uniform.load = load i32, ptr addrspace(4) %gep, align 4
  store i32 %maybe.not.uniform.load, ptr addrspace(1) poison
  ret void
}

define amdgpu_kernel void @flat_load_maybe_divergent(ptr addrspace(4) %k, ptr %flat) {
; GCN-LABEL: flat_load_maybe_divergent:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GCN-NEXT:    s_add_i32 s12, s12, s17
; GCN-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    flat_load_dword v0, v[0:1]
; GCN-NEXT:    v_mov_b32_e32 v2, s1
; GCN-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v1, 31, v0
; GCN-NEXT:    v_lshlrev_b64 v[0:1], 2, v[0:1]
; GCN-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; GCN-NEXT:    v_addc_u32_e32 v1, vcc, v2, v1, vcc
; GCN-NEXT:    flat_load_dword v0, v[0:1]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    flat_store_dword v[0:1], v0
; GCN-NEXT:    s_endpgm
  %load = load i32, ptr %flat, align 4
  %gep = getelementptr inbounds i32, ptr addrspace(4) %k, i32 %load
  %maybe.not.uniform.load = load i32, ptr addrspace(4) %gep, align 4
  store i32 %maybe.not.uniform.load, ptr addrspace(1) poison
  ret void
}

; This decomposes into a sequence of divergent sub carries. The first
; subs in the sequence are divergent from the value inputs, but the
; last values are divergent due to the carry in glue (such that
; divergence needs to propagate through glue if there are any non-void
; outputs)
define <2 x i128> @wide_carry_divergence_error(i128 %arg) {
; GCN-LABEL: wide_carry_divergence_error:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ffbh_u32_e32 v0, v0
; GCN-NEXT:    v_ffbh_u32_e32 v4, v2
; GCN-NEXT:    v_add_u32_e64 v0, s[4:5], v0, 32 clamp
; GCN-NEXT:    v_ffbh_u32_e32 v1, v1
; GCN-NEXT:    v_add_u32_e32 v4, vcc, 32, v4
; GCN-NEXT:    v_min3_u32 v0, v0, v1, 64
; GCN-NEXT:    v_add_u32_e32 v0, vcc, 64, v0
; GCN-NEXT:    v_ffbh_u32_e32 v5, v3
; GCN-NEXT:    v_addc_u32_e64 v1, s[4:5], 0, 0, vcc
; GCN-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[2:3]
; GCN-NEXT:    v_min_u32_e32 v4, v4, v5
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v1, v1, 0, vcc
; GCN-NEXT:    v_sub_u32_e32 v0, vcc, 0, v0
; GCN-NEXT:    v_mov_b32_e32 v3, 0
; GCN-NEXT:    v_subb_u32_e32 v1, vcc, 0, v1, vcc
; GCN-NEXT:    v_subb_u32_e32 v2, vcc, 0, v3, vcc
; GCN-NEXT:    v_subb_u32_e32 v3, vcc, 0, v3, vcc
; GCN-NEXT:    v_mov_b32_e32 v4, 0
; GCN-NEXT:    v_mov_b32_e32 v5, 0
; GCN-NEXT:    v_mov_b32_e32 v6, 0
; GCN-NEXT:    v_mov_b32_e32 v7, 0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %i = call i128 @llvm.ctlz.i128(i128 %arg, i1 false)
  %i1 = sub i128 0, %i
  %i2 = insertelement <2 x i128> zeroinitializer, i128 %i1, i64 0
  ret <2 x i128> %i2
}
