; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -passes=newgvn -S < %s | FileCheck %s

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-f128:128:128-n8:16:32:64"

; GVN shouldn't PRE the load around the loop backedge because it's
; not actually redundant around the loop backedge, despite appearances
; if phi-translation is ignored.

define void @test0(ptr %begin) {
; CHECK-LABEL: define void @test0(
; CHECK-SAME: ptr [[BEGIN:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[PHI:%.*]] = phi ptr [ [[BEGIN]], [[ENTRY:%.*]] ], [ [[NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[L0:%.*]] = load i8, ptr [[PHI]], align 1
; CHECK-NEXT:    call void @bar(i8 [[L0]])
; CHECK-NEXT:    [[L1:%.*]] = load i8, ptr [[PHI]], align 1
; CHECK-NEXT:    [[NEXT]] = getelementptr inbounds i8, ptr [[PHI]], i8 [[L1]]
; CHECK-NEXT:    br label [[LOOP]]
;
entry:
  br label %loop

loop:
  %phi = phi ptr [ %begin, %entry ], [ %next, %loop ]
  %l0 = load i8, ptr %phi
  call void @bar(i8 %l0)
  %l1 = load i8, ptr %phi
  %next = getelementptr inbounds i8, ptr %phi, i8 %l1
  br label %loop
}

declare void @bar(i8)
