.PS
# Reg723.m4
# see Horowitz and Hill p 600
cct_init
  svg_font(sans-serif,10bp__)

 R1: resistor(down_ dimen_*3/4)
  rlabel(,"R`'svg_sub(1)" rjust "1.15k" rjust)
 R2: potentiometer(down_ dimen_) with .Start at Here
   rlabel(,"R`'svg_sub(2)" rjust "2.0k" rjust)
   "V`'svg_sub(adj)" at R2.T1 below
 R3: resistor(down_ dimen_ from R2.End)
   rlabel(,"R`'svg_sub(3)" rjust "4.02k" wid 4*textht rjust)
   ground

   line right_ dimen_*4/3 from R2.T1
 A: opamp(,,,,R) with .In1 at Here

   line right_ dimen_*3/4 from A.Out
 B1: dot
 Q2: bi_tr(up_ dimen_) with .B at Here
   line right_ dimen_ from Q2.E
 Q1: bi_tr(up_ dimen_*3/2)  with .B at Here; heatsink(at Q1.e+(dimen_/2,0),,D)
   "heat" ljust at last [].e+(dimen_/5,0) "sink" ljust
   dot(at Q1.E)
   resistor(down_ dimen_*3/2)
   llabel(,"0.25`'svg_Omega" ljust "3W" ljust)
 P5: dot

 Q3: bi_tr(up_ dimen_,R) with .B at (Q2.C.x,Q1.E.y); dot(at Q3.C)
   { line to Q2.B }
   resistor(left_ dimen_ from Q1.E); llabel(,"100")
   line to Q3.B
   line from Q3.E to (Q3.E,P5) then to P5+(dimen_,0)
 Out: "+5V" ljust "2A" ljust
   dot(at P5+(dimen_/2,0))
   capacitor(down_ dimen_,C+); ground(,T)
   rlabel(,"10`'svg_micro`'F" rjust "15V" rjust)

Vref: box wid boxwid/2 ht boxht/2 with .w at (A.E.x,A.n.y+dimen_/3) \
  "V`'svg_sub(ref)"
Bx: box thick 0.4 wid Q2.C.x-A.w.x+dimen_/2 rad 0.1 \
    ht Vref.n.y-Q3.E.y+dimen_/3 with .sw at (A.In1.x-dimen_/7,Q3.E.y) dashed
  "723" at Bx.n above

  line from Vref.w to (Bx.w,Vref.w)
  { "V`'svg_sub(ref)" above rjust }
  continue to ((R1.x+Here.x)/2,Here.y); continue to (Here,R1.start) \
   then to R1.start
  "+7.15V" above ljust

P6: dot(at P5-(dimen_*2/3,0))
  line from Q3.C left_ dimen_/2 then down_ Q3.C.y-Bx.s.y
Cp: capacitor(down_ dimen_*3/2); rlabel(,"100pF"); dot
  line from A.In2 left_ dimen_/2 then down_ A.In2.y-Cp.end.y then to Cp.end
R4: resistor(right_ to (P6,Here)); rlabel(,"R`'svg_sub(4) 1.5k"); line to P6
   
  line from A.SE to (A.SE,Bx.s); ground
  "COMP" at (Cp,Bx.s) below rjust
  "CS" at (Q3.E,Bx.s) below ljust
  "CL" at (Bx.e,Q1.E) below ljust
  "NI" at (Bx.w,A.In1) rjust above
  "V`'svg_sub(out)" at (Bx.e,Q1.B) above ljust
  "INV" at (Bx.w,A.In2) rjust above

  line from A.NE to (A.NE.x,Bx.n.y+dimen_/2)
  { "V`'svg_sub(+)" at (Here,Bx.n) above rjust }
  continue to (Out,Here)
  {"+V`'svg_sub(in) (unreg)" wid 8*textht "+9.5V (min)" below}
  {dot(at (Q2.C,Here)); line to Q2.C
   "V`'svg_sub(C)" at (Here,Bx.n) above rjust }
  dot(at (Q1.C,Here)); line to Q1.C
  "Q`'svg_sub(1)" ljust "TIP41" ljust

  command "</g>"
.PE
