# Liederbuch-Package
This is a LaTeX package for creating easy-to-use songbooks and including these songs in songbooklets for i.e. weddings. It is intended for songs, but it can include any content you want to reuse once in a while.

This material is subject to the LaTeX Project Public License 1.3. You can do whatever you want with it, just don't upload the same under the same name.

The basic concept is to have one database, the Liederbuch (songbook) and a document fetching the songs from there.

A songbook looks like that:

    \ProvidesPackage{testSongbook}
    \RequirePackage{liederbuch}
    
    \begin{liederbuch}[publisher=me & date = today]{testSongbook-1}
    
    \begin{lied}[meta data=this is just a test & otherData = it really is a test]{var1}{144000}
       No notes and text yet.
    \end{lied}
    
    \begin{lied}{var2}{144000}
       Same song, but different variant (var2)
    \end{lied}
    
    \begin{lied}{versionA}{001}
       Another song with song number 001 in versionA. The version parameter exists, that song numbers can be overloaded.
    \end{lied}
    
    \end{liederbuch}
    
    
    \begin{liederbuch}{testSongbook-2}
    
    \begin{lied}[meta data= some other values]{aSong}{1}
       Another song in another songbook
    \end{lied}
    \end{liederbuch}

To call a song, you just write

    \LBsong{testSongbook-1}{144000}{var1}

and it automatically adds the previous defined song to your document.


This is useful, if you reuse text segments, songs or graphics very often (you can store anything within \begin{lied}...\end{lied}).

Written by Gabriel Ruprecht, version 1.1.0 / 2025-01-20